/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.multipart;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"openKeyTable", "deletedTable", "multipartInfoTable"})
public class S3MultipartUploadCommitPartResponse
extends OMClientResponse {
    private String multipartKey;
    private String openKey;
    private OmMultipartKeyInfo omMultipartKeyInfo;
    private OzoneManagerProtocolProtos.PartKeyInfo oldPartKeyInfo;
    private OmKeyInfo openPartKeyInfoToBeDeleted;
    private boolean isRatisEnabled;
    private OmBucketInfo omBucketInfo;

    public S3MultipartUploadCommitPartResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, String multipartKey, String openKey, @Nullable OmMultipartKeyInfo omMultipartKeyInfo, @Nullable OzoneManagerProtocolProtos.PartKeyInfo oldPartKeyInfo, @Nullable OmKeyInfo openPartKeyInfoToBeDeleted, boolean isRatisEnabled, @Nonnull OmBucketInfo omBucketInfo) {
        super(omResponse);
        this.multipartKey = multipartKey;
        this.openKey = openKey;
        this.omMultipartKeyInfo = omMultipartKeyInfo;
        this.oldPartKeyInfo = oldPartKeyInfo;
        this.openPartKeyInfoToBeDeleted = openPartKeyInfoToBeDeleted;
        this.isRatisEnabled = isRatisEnabled;
        this.omBucketInfo = omBucketInfo;
    }

    @Override
    public void checkAndUpdateDB(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.NO_SUCH_MULTIPART_UPLOAD_ERROR) {
            RepeatedOmKeyInfo repeatedOmKeyInfo = (RepeatedOmKeyInfo)omMetadataManager.getDeletedTable().get((Object)this.openKey);
            repeatedOmKeyInfo = OmUtils.prepareKeyForDelete((OmKeyInfo)this.openPartKeyInfoToBeDeleted, (RepeatedOmKeyInfo)repeatedOmKeyInfo, (long)this.openPartKeyInfoToBeDeleted.getUpdateID(), (boolean)this.isRatisEnabled);
            omMetadataManager.getDeletedTable().putWithBatch(batchOperation, (Object)this.openKey, (Object)repeatedOmKeyInfo);
        }
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            this.addToDBBatch(omMetadataManager, batchOperation);
        }
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.oldPartKeyInfo != null) {
            OmKeyInfo partKeyToBeDeleted = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)this.oldPartKeyInfo.getPartKeyInfo());
            RepeatedOmKeyInfo repeatedOmKeyInfo = (RepeatedOmKeyInfo)omMetadataManager.getDeletedTable().get((Object)this.oldPartKeyInfo.getPartName());
            repeatedOmKeyInfo = OmUtils.prepareKeyForDelete((OmKeyInfo)partKeyToBeDeleted, (RepeatedOmKeyInfo)repeatedOmKeyInfo, (long)this.omMultipartKeyInfo.getUpdateID(), (boolean)this.isRatisEnabled);
            omMetadataManager.getDeletedTable().putWithBatch(batchOperation, (Object)this.oldPartKeyInfo.getPartName(), (Object)repeatedOmKeyInfo);
        }
        omMetadataManager.getMultipartInfoTable().putWithBatch(batchOperation, (Object)this.multipartKey, (Object)this.omMultipartKeyInfo);
        omMetadataManager.getOpenKeyTable().deleteWithBatch(batchOperation, (Object)this.openKey);
        omMetadataManager.getBucketTable().putWithBatch(batchOperation, (Object)omMetadataManager.getBucketKey(this.omBucketInfo.getVolumeName(), this.omBucketInfo.getBucketName()), (Object)this.omBucketInfo);
    }
}

