/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocolPB;

import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.server.OzoneProtocolMessageDispatcher;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.ProtocolMessageMetrics;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMLeaderNotReadyException;
import org.apache.hadoop.ozone.om.exceptions.OMNotLeaderException;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolPB;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerDoubleBuffer;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerRatisServer;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerRatisUtils;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OzoneManagerRequestHandler;
import org.apache.hadoop.ozone.protocolPB.RequestHandler;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.util.ExitUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneManagerProtocolServerSideTranslatorPB
implements OzoneManagerProtocolPB {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerProtocolServerSideTranslatorPB.class);
    private final OzoneManagerRatisServer omRatisServer;
    private final RequestHandler handler;
    private final boolean isRatisEnabled;
    private final OzoneManager ozoneManager;
    private final OzoneManagerDoubleBuffer ozoneManagerDoubleBuffer;
    private final AtomicLong transactionIndex;
    private final OzoneProtocolMessageDispatcher<OzoneManagerProtocolProtos.OMRequest, OzoneManagerProtocolProtos.OMResponse, ProtocolMessageEnum> dispatcher;

    public OzoneManagerProtocolServerSideTranslatorPB(OzoneManager impl, OzoneManagerRatisServer ratisServer, ProtocolMessageMetrics<ProtocolMessageEnum> metrics, boolean enableRatis, long lastTransactionIndexForNonRatis) {
        this.ozoneManager = impl;
        this.isRatisEnabled = enableRatis;
        this.transactionIndex = new AtomicLong(lastTransactionIndexForNonRatis);
        if (this.isRatisEnabled) {
            this.ozoneManagerDoubleBuffer = null;
            this.handler = new OzoneManagerRequestHandler(impl, null);
        } else {
            this.ozoneManagerDoubleBuffer = new OzoneManagerDoubleBuffer.Builder().setOmMetadataManager(this.ozoneManager.getMetadataManager()).setOzoneManagerRatisSnapShot(i -> {}).enableRatis(this.isRatisEnabled).enableTracing(TracingUtil.isTracingEnabled((ConfigurationSource)this.ozoneManager.getConfiguration())).build();
            this.handler = new OzoneManagerRequestHandler(impl, this.ozoneManagerDoubleBuffer);
        }
        this.omRatisServer = ratisServer;
        this.dispatcher = new OzoneProtocolMessageDispatcher("OzoneProtocol", metrics, LOG);
    }

    public OzoneManagerProtocolProtos.OMResponse submitRequest(RpcController controller, OzoneManagerProtocolProtos.OMRequest request) throws ServiceException {
        return (OzoneManagerProtocolProtos.OMResponse)this.dispatcher.processRequest((Object)request, this::processRequest, (Object)request.getCmdType(), request.getTraceID());
    }

    private OzoneManagerProtocolProtos.OMResponse processRequest(OzoneManagerProtocolProtos.OMRequest request) throws ServiceException {
        if (this.isRatisEnabled) {
            if (OmUtils.isReadOnly((OzoneManagerProtocolProtos.OMRequest)request)) {
                return this.submitReadRequestToOM(request);
            }
            OzoneManagerRatisServer.RaftServerStatus raftServerStatus = this.omRatisServer.checkLeaderStatus();
            if (raftServerStatus == OzoneManagerRatisServer.RaftServerStatus.LEADER_AND_READY) {
                try {
                    OMClientRequest omClientRequest = OzoneManagerRatisUtils.createClientRequest(request);
                    request = omClientRequest.preExecute(this.ozoneManager);
                }
                catch (IOException ex) {
                    return this.createErrorResponse(request, ex);
                }
                return this.submitRequestToRatis(request);
            }
            throw this.createLeaderErrorException(raftServerStatus);
        }
        return this.submitRequestDirectlyToOM(request);
    }

    private OzoneManagerProtocolProtos.OMResponse createErrorResponse(OzoneManagerProtocolProtos.OMRequest omRequest, IOException exception) {
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setStatus(OzoneManagerRatisUtils.exceptionToResponseStatus(exception)).setCmdType(omRequest.getCmdType()).setTraceID(omRequest.getTraceID()).setSuccess(false);
        if (exception.getMessage() != null) {
            omResponse.setMessage(exception.getMessage());
        }
        return omResponse.build();
    }

    private OzoneManagerProtocolProtos.OMResponse submitRequestToRatis(OzoneManagerProtocolProtos.OMRequest request) throws ServiceException {
        return this.omRatisServer.submitRequest(request);
    }

    private OzoneManagerProtocolProtos.OMResponse submitReadRequestToOM(OzoneManagerProtocolProtos.OMRequest request) throws ServiceException {
        OzoneManagerRatisServer.RaftServerStatus raftServerStatus = this.omRatisServer.checkLeaderStatus();
        if (raftServerStatus == OzoneManagerRatisServer.RaftServerStatus.LEADER_AND_READY) {
            return this.handler.handleReadRequest(request);
        }
        throw this.createLeaderErrorException(raftServerStatus);
    }

    private ServiceException createNotLeaderException() {
        RaftPeerId raftPeerId = this.omRatisServer.getRaftPeerId();
        OMNotLeaderException notLeaderException = new OMNotLeaderException(raftPeerId);
        if (LOG.isDebugEnabled()) {
            LOG.debug(notLeaderException.getMessage());
        }
        return new ServiceException((Throwable)notLeaderException);
    }

    private ServiceException createLeaderErrorException(OzoneManagerRatisServer.RaftServerStatus raftServerStatus) {
        if (raftServerStatus == OzoneManagerRatisServer.RaftServerStatus.NOT_LEADER) {
            return this.createNotLeaderException();
        }
        return this.createLeaderNotReadyException();
    }

    private ServiceException createLeaderNotReadyException() {
        RaftPeerId raftPeerId = this.omRatisServer.getRaftPeerId();
        OMLeaderNotReadyException leaderNotReadyException = new OMLeaderNotReadyException(raftPeerId.toString() + " is Leader but not ready to process request");
        return new ServiceException((Throwable)leaderNotReadyException);
    }

    private OzoneManagerProtocolProtos.OMResponse submitRequestDirectlyToOM(OzoneManagerProtocolProtos.OMRequest request) {
        OMClientResponse omClientResponse = null;
        long index = 0L;
        try {
            if (OmUtils.isReadOnly((OzoneManagerProtocolProtos.OMRequest)request)) {
                return this.handler.handleReadRequest(request);
            }
            OMClientRequest omClientRequest = OzoneManagerRatisUtils.createClientRequest(request);
            request = omClientRequest.preExecute(this.ozoneManager);
            index = this.transactionIndex.incrementAndGet();
            omClientResponse = this.handler.handleWriteRequest(request, index);
        }
        catch (IOException ex) {
            return this.createErrorResponse(request, ex);
        }
        try {
            omClientResponse.getFlushFuture().get();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Future for {} is completed", (Object)request);
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            String errorMessage = "Got error during waiting for flush to be completed for request" + request.toString();
            ExitUtils.terminate((int)1, (String)errorMessage, (Throwable)ex, (Logger)LOG);
        }
        return omClientResponse.getOMResponse();
    }

    public void stop() {
        if (!this.isRatisEnabled) {
            this.ozoneManagerDoubleBuffer.stop();
        }
    }
}

