/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import com.google.common.annotations.VisibleForTesting;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.enterprise.context.RequestScoped;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.hadoop.ozone.s3.SignatureProcessor;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.apache.hadoop.ozone.s3.header.AuthorizationHeaderV2;
import org.apache.hadoop.ozone.s3.header.AuthorizationHeaderV4;
import org.apache.hadoop.ozone.s3.header.Credential;
import org.apache.kerby.util.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class AWSSignatureProcessor
implements SignatureProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AWSSignatureProcessor.class);
    @Context
    private ContainerRequestContext context;
    private Map<String, String> headers;
    private MultivaluedMap<String, String> queryMap;
    private String uri;
    private String method;
    private AuthorizationHeaderV4 v4Header;
    private AuthorizationHeaderV2 v2Header;
    private String stringToSign;
    private Exception exception;

    @PostConstruct
    public void init() throws Exception {
        this.headers = new LowerCaseKeyStringMap(new HashMap<String, String>());
        for (Map.Entry headerEntry : this.context.getHeaders().entrySet()) {
            if (0 >= ((List)headerEntry.getValue()).size()) continue;
            String headerKey = (String)headerEntry.getKey();
            if (this.headers.containsKey(headerKey)) {
                this.headers.put(headerKey, this.headers.get(headerKey) + "," + (String)((List)headerEntry.getValue()).get(0));
                continue;
            }
            this.headers.put(headerKey, (String)((List)headerEntry.getValue()).get(0));
        }
        if (this.headers.containsKey("X-Ozone-Original-Content-Type")) {
            this.headers.put("Content-Type", this.headers.get("X-Ozone-Original-Content-Type"));
        }
        this.queryMap = this.context.getUriInfo().getQueryParameters();
        this.uri = this.context.getUriInfo().getRequestUri().getPath();
        this.method = this.context.getMethod();
        String authHeader = this.headers.get("Authorization");
        try {
            if (authHeader != null) {
                String[] split = authHeader.split(" ");
                if (split[0].equals("AWS")) {
                    if (this.v2Header == null) {
                        this.v2Header = new AuthorizationHeaderV2(authHeader);
                    }
                } else {
                    if (this.v4Header == null) {
                        this.v4Header = new AuthorizationHeaderV4(authHeader);
                    }
                    this.parse();
                }
            } else {
                this.v4Header = null;
                this.v2Header = null;
            }
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error during Validation of Auth Header:{}", (Object)authHeader);
            }
            this.exception = ex;
        }
    }

    private void parse() throws Exception {
        StringBuilder strToSign = new StringBuilder();
        String algorithm = this.v4Header.getAlgorithm();
        String requestDateTime = this.headers.get("X-Amz-Date");
        Credential credential = this.v4Header.getCredentialObj();
        String credentialScope = String.format("%s/%s/%s/%s", credential.getDate(), credential.getAwsRegion(), credential.getAwsService(), credential.getAwsRequest());
        this.uri = this.uri.trim().length() > 0 ? this.uri : "/";
        strToSign.append(algorithm + "\n");
        strToSign.append(requestDateTime + "\n");
        strToSign.append(credentialScope + "\n");
        String canonicalRequest = this.buildCanonicalRequest();
        strToSign.append(AWSSignatureProcessor.hash(canonicalRequest));
        if (LOG.isDebugEnabled()) {
            LOG.debug("canonicalRequest:[{}]", (Object)canonicalRequest);
        }
        if (LOG.isTraceEnabled()) {
            this.headers.keySet().forEach(k -> LOG.trace("Header:{},value:{}", k, (Object)this.headers.get(k)));
        }
        LOG.debug("StringToSign:[{}]", (Object)strToSign);
        this.stringToSign = strToSign.toString();
    }

    @VisibleForTesting
    protected String buildCanonicalRequest() throws OS3Exception {
        Iterable<String> parts = AWSSignatureProcessor.split("/", this.uri);
        ArrayList<String> encParts = new ArrayList<String>();
        for (String p : parts) {
            encParts.add(this.urlEncode(p));
        }
        String canonicalUri = AWSSignatureProcessor.join("/", encParts);
        String canonicalQueryStr = this.getQueryParamString();
        StringBuilder canonicalHeaders = new StringBuilder();
        for (String header : this.v4Header.getSignedHeaders()) {
            canonicalHeaders.append(header.toLowerCase());
            canonicalHeaders.append(":");
            if (this.headers.containsKey(header)) {
                String headerValue = this.headers.get(header);
                canonicalHeaders.append(headerValue);
                canonicalHeaders.append("\n");
                this.validateSignedHeader(header, headerValue);
                continue;
            }
            throw new RuntimeException("Header " + header + " not present in request but requested to be signed.");
        }
        String payloadHash = "UNSIGNED-PAYLOAD".equals(this.headers.get("X-Amz-Content-SHA256")) ? "UNSIGNED-PAYLOAD" : this.headers.get("X-Amz-Content-SHA256");
        String signedHeaderStr = this.v4Header.getSignedHeaderString();
        String canonicalRequest = this.method + "\n" + canonicalUri + "\n" + canonicalQueryStr + "\n" + canonicalHeaders + "\n" + signedHeaderStr + "\n" + payloadHash;
        return canonicalRequest;
    }

    @VisibleForTesting
    void validateSignedHeader(String header, String headerValue) throws OS3Exception {
        switch (header) {
            case "host": {
                try {
                    String schema = this.context.getUriInfo().getRequestUri().getScheme();
                    URI hostUri = new URI(schema + "://" + headerValue);
                    InetAddress.getByName(hostUri.getHost());
                    break;
                }
                catch (URISyntaxException | UnknownHostException e) {
                    LOG.error("Host value mentioned in signed header is not valid. Host:{}", (Object)headerValue);
                    throw S3ErrorTable.S3_AUTHINFO_CREATION_ERROR;
                }
            }
            case "X-Amz-Date": {
                LocalDate date = LocalDate.parse(headerValue, TIME_FORMATTER);
                LocalDate now = LocalDate.now();
                if (!date.isBefore(now.minus(604800L, ChronoUnit.SECONDS)) && !date.isAfter(now.plus(604800L, ChronoUnit.SECONDS))) break;
                LOG.error("AWS date not in valid range. Request timestamp:{} should not be older than {} seconds.", (Object)headerValue, (Object)604800L);
                throw S3ErrorTable.S3_AUTHINFO_CREATION_ERROR;
            }
            case "X-Amz-Content-SHA256": {
                break;
            }
        }
    }

    private static String join(String glue, List<String> parts) {
        StringBuilder result = new StringBuilder();
        boolean addSeparator = false;
        for (String p : parts) {
            if (addSeparator) {
                result.append(glue);
            }
            result.append(p);
            addSeparator = true;
        }
        return result.toString();
    }

    private static Iterable<String> split(String regex, String whole) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(whole);
        ArrayList<String> result = new ArrayList<String>();
        int pos = 0;
        while (m.find()) {
            result.add(whole.substring(pos, m.start()));
            pos = m.end();
        }
        result.add(whole.substring(pos));
        return result;
    }

    private String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20").replaceAll("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String getQueryParamString() {
        ArrayList params = new ArrayList(this.queryMap.keySet());
        Collections.sort(params, (o1, o2) -> o1.equals(o2) ? ((String)this.queryMap.getFirst(o1)).compareTo((String)this.queryMap.getFirst(o2)) : o1.compareTo((String)o2));
        StringBuilder result = new StringBuilder();
        for (String p : params) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(this.urlEncode(p));
            result.append('=');
            result.append(this.urlEncode((String)this.queryMap.getFirst((Object)p)));
        }
        return result.toString();
    }

    public static String hash(String payload) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(payload.getBytes(StandardCharsets.UTF_8));
        return Hex.encode((byte[])md.digest()).toLowerCase();
    }

    @Override
    public String getAwsAccessId() {
        return this.v4Header != null ? this.v4Header.getAccessKeyID() : (this.v2Header != null ? this.v2Header.getAccessKeyID() : "");
    }

    @Override
    public String getSignature() {
        return this.v4Header != null ? this.v4Header.getSignature() : (this.v2Header != null ? this.v2Header.getSignature() : "");
    }

    @Override
    public String getStringToSign() throws Exception {
        return this.stringToSign;
    }

    @VisibleForTesting
    public void setContext(ContainerRequestContext context) {
        this.context = context;
    }

    @VisibleForTesting
    public void setV4Header(AuthorizationHeaderV4 v4Header) {
        this.v4Header = v4Header;
    }

    @VisibleForTesting
    public void setV2Header(AuthorizationHeaderV2 v2Header) {
        this.v2Header = v2Header;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    public static class LowerCaseKeyStringMap
    implements Map<String, String> {
        private HashMap<String, String> delegate;

        public LowerCaseKeyStringMap(HashMap<String, String> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key.toString().toLowerCase());
        }

        @Override
        public boolean containsValue(Object value) {
            return this.delegate.containsValue(value);
        }

        @Override
        public String get(Object key) {
            return this.delegate.get(key.toString().toLowerCase());
        }

        @Override
        public String put(String key, String value) {
            return this.delegate.put(key.toLowerCase(), value);
        }

        @Override
        public String remove(Object key) {
            return this.delegate.remove(key.toString());
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> m) {
            for (Map.Entry<? extends String, ? extends String> entry : m.entrySet()) {
                this.put(entry.getKey().toLowerCase(), entry.getValue());
            }
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public Set<String> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public Collection<String> values() {
            return this.delegate.values();
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.delegate.entrySet();
        }
    }
}

