/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;

@Provider
@PreMatching
@Priority(value=150)
public class HeaderPreprocessor
implements ContainerRequestFilter {
    public static final String MULTIPART_UPLOAD_MARKER = "ozone/mpu";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String ORIGINAL_CONTENT_TYPE = "X-Ozone-Original-Content-Type";

    public void filter(ContainerRequestContext requestContext) throws IOException {
        MultivaluedMap queryParameters = requestContext.getUriInfo().getQueryParameters();
        if (requestContext.getHeaderString(CONTENT_TYPE) != null) {
            requestContext.getHeaders().putSingle((Object)ORIGINAL_CONTENT_TYPE, (Object)requestContext.getHeaderString(CONTENT_TYPE));
        }
        if (queryParameters.containsKey((Object)"delete")) {
            requestContext.getHeaders().putSingle((Object)CONTENT_TYPE, (Object)"application/xml");
        }
        if (queryParameters.containsKey((Object)"uploadId")) {
            requestContext.getHeaders().putSingle((Object)CONTENT_TYPE, (Object)"application/xml");
        } else if (queryParameters.containsKey((Object)"uploads")) {
            requestContext.getHeaders().putSingle((Object)CONTENT_TYPE, (Object)MULTIPART_UPLOAD_MARKER);
        }
    }
}

