/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.s3.util.OzoneS3Util;
import org.apache.hadoop.security.SecurityUtil;

@ApplicationScoped
public class OzoneServiceProvider {
    private Text omServiceAddr;
    private String omserviceID;
    @Inject
    private OzoneConfiguration conf;

    @PostConstruct
    public void init() {
        Collection serviceIdList = this.conf.getTrimmedStringCollection("ozone.om.service.ids");
        if (serviceIdList.size() == 0) {
            this.omServiceAddr = SecurityUtil.buildTokenService((InetSocketAddress)OmUtils.getOmAddressForClients((ConfigurationSource)this.conf));
        } else {
            if (serviceIdList.size() > 1) {
                throw new IllegalArgumentException("Multiple serviceIds are configured. " + Arrays.toString(serviceIdList.toArray()));
            }
            String serviceId = (String)serviceIdList.iterator().next();
            Collection omNodeIds = OmUtils.getOMNodeIds((ConfigurationSource)this.conf, (String)serviceId);
            if (omNodeIds.size() == 0) {
                throw new IllegalArgumentException("ozone.om.nodes." + serviceId + " is not defined");
            }
            this.omServiceAddr = new Text(OzoneS3Util.buildServiceNameForToken(this.conf, serviceId, omNodeIds));
            this.omserviceID = serviceId;
        }
    }

    @Produces
    public Text getService() {
        return this.omServiceAddr;
    }

    @Produces
    public String getOmServiceID() {
        return this.omserviceID;
    }
}

