/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.util.GlobalTracer;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;

@Provider
public class TracingFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    public static final String TRACING_SCOPE = "TRACING_SCOPE";
    public static final String TRACING_SPAN = "TRACING_SPAN";
    @Context
    private ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext) {
        this.finishAndCloseActiveSpan();
        Span span = GlobalTracer.get().buildSpan(this.resourceInfo.getResourceClass().getSimpleName() + "." + this.resourceInfo.getResourceMethod().getName()).start();
        Scope scope = GlobalTracer.get().activateSpan(span);
        requestContext.setProperty(TRACING_SCOPE, (Object)scope);
        requestContext.setProperty(TRACING_SPAN, (Object)span);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        Span span;
        Scope scope = (Scope)requestContext.getProperty(TRACING_SCOPE);
        if (scope != null) {
            scope.close();
        }
        if ((span = (Span)requestContext.getProperty(TRACING_SPAN)) != null) {
            span.finish();
        }
        this.finishAndCloseActiveSpan();
    }

    private void finishAndCloseActiveSpan() {
        ScopeManager scopeManager = GlobalTracer.get().scopeManager();
        if (scopeManager != null && scopeManager.activeSpan() != null) {
            scopeManager.activeSpan().finish();
            scopeManager.activate(null);
        }
    }
}

