/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import com.google.common.annotations.VisibleForTesting;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneKeyDetails;
import org.apache.hadoop.ozone.client.OzoneMultipartUploadPartListParts;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmMultipartCommitUploadPartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteInfo;
import org.apache.hadoop.ozone.s3.SignedChunksInputStream;
import org.apache.hadoop.ozone.s3.endpoint.CompleteMultipartUploadRequest;
import org.apache.hadoop.ozone.s3.endpoint.CompleteMultipartUploadResponse;
import org.apache.hadoop.ozone.s3.endpoint.CopyObjectResponse;
import org.apache.hadoop.ozone.s3.endpoint.CopyPartResult;
import org.apache.hadoop.ozone.s3.endpoint.EndpointBase;
import org.apache.hadoop.ozone.s3.endpoint.ListPartsResponse;
import org.apache.hadoop.ozone.s3.endpoint.MultipartUploadInitiateResponse;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.apache.hadoop.ozone.s3.io.S3WrapperInputStream;
import org.apache.hadoop.ozone.s3.util.RFC1123Util;
import org.apache.hadoop.ozone.s3.util.RangeHeader;
import org.apache.hadoop.ozone.s3.util.RangeHeaderParserUtil;
import org.apache.hadoop.ozone.s3.util.S3StorageType;
import org.apache.hadoop.ozone.web.utils.OzoneUtils;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{bucket}/{path:.+}")
public class ObjectEndpoint
extends EndpointBase {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectEndpoint.class);
    @Context
    private HttpHeaders headers;
    private List<String> customizableGetHeaders = new ArrayList<String>();
    private int bufferSize;
    @Inject
    private OzoneConfiguration ozoneConfiguration;

    public ObjectEndpoint() {
        this.customizableGetHeaders.add("Content-Type");
        this.customizableGetHeaders.add("Content-Language");
        this.customizableGetHeaders.add("Expires");
        this.customizableGetHeaders.add("Cache-Control");
        this.customizableGetHeaders.add("Content-Disposition");
        this.customizableGetHeaders.add("Content-Encoding");
    }

    @PostConstruct
    public void init() {
        this.bufferSize = (int)this.ozoneConfiguration.getStorageSize("ozone.s3g.client.buffer.size", "4KB", StorageUnit.BYTES);
    }

    @PUT
    public Response put(@PathParam(value="bucket") String bucketName, @PathParam(value="path") String keyPath, @HeaderParam(value="Content-Length") long length, @QueryParam(value="partNumber") int partNumber, @QueryParam(value="uploadId") @DefaultValue(value="") String uploadID, InputStream body) throws IOException, OS3Exception {
        OzoneOutputStream output = null;
        if (uploadID != null && !uploadID.equals("")) {
            return this.createMultipartKey(bucketName, keyPath, length, partNumber, uploadID, body);
        }
        try {
            boolean storageTypeDefault;
            S3StorageType s3StorageType;
            String copyHeader = this.headers.getHeaderString("x-amz-copy-source");
            String storageType = this.headers.getHeaderString("x-amz-storage-class");
            if (storageType == null || storageType.equals("")) {
                s3StorageType = S3StorageType.getDefault();
                storageTypeDefault = true;
            } else {
                s3StorageType = ObjectEndpoint.toS3StorageType(storageType);
                storageTypeDefault = false;
            }
            ReplicationType replicationType = s3StorageType.getType();
            ReplicationFactor replicationFactor = s3StorageType.getFactor();
            if (copyHeader != null) {
                CopyObjectResponse copyObjectResponse = this.copyObject(copyHeader, bucketName, keyPath, replicationType, replicationFactor, storageTypeDefault);
                Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)copyObjectResponse).header("Connection", (Object)"close").build();
                return response;
            }
            OzoneBucket bucket = this.getBucket(bucketName);
            output = bucket.createKey(keyPath, length, replicationType, replicationFactor, new HashMap());
            if ("STREAMING-AWS4-HMAC-SHA256-PAYLOAD".equals(this.headers.getHeaderString("x-amz-content-sha256"))) {
                body = new SignedChunksInputStream(body);
            }
            IOUtils.copy((InputStream)body, (OutputStream)output);
            Response response = Response.ok().status(200).build();
            return response;
        }
        catch (IOException ex) {
            LOG.error("Exception occurred in PutObject", (Throwable)ex);
            if (ex instanceof OMException) {
                if (((OMException)((Object)ex)).getResult() == OMException.ResultCodes.NOT_A_FILE) {
                    OS3Exception os3Exception = S3ErrorTable.newError(S3ErrorTable.INVALID_REQUEST, keyPath);
                    os3Exception.setErrorMessage("An error occurred (InvalidRequest) when calling the PutObject/MPU PartUpload operation: ozone.om.enable.filesystem.paths is enabled Keys are considered as Unix Paths. Path has Violated FS Semantics which caused put operation to fail.");
                    throw os3Exception;
                }
                if (((OMException)((Object)ex)).getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                    throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, keyPath);
                }
            }
            throw ex;
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    @GET
    public Response get(@PathParam(value="bucket") String bucketName, @PathParam(value="path") String keyPath, @QueryParam(value="uploadId") String uploadId, @QueryParam(value="max-parts") @DefaultValue(value="1000") int maxParts, @QueryParam(value="part-number-marker") String partNumberMarker, InputStream body) throws IOException, OS3Exception {
        try {
            Response.ResponseBuilder responseBuilder;
            if (uploadId != null) {
                int partMarker = ObjectEndpoint.parsePartNumberMarker(partNumberMarker);
                return this.listParts(bucketName, keyPath, uploadId, partMarker, maxParts);
            }
            OzoneBucket bucket = this.getBucket(bucketName);
            OzoneKeyDetails keyDetails = bucket.getKey(keyPath);
            long length = keyDetails.getDataSize();
            LOG.debug("Data length of the key {} is {}", (Object)keyPath, (Object)length);
            String rangeHeaderVal = this.headers.getHeaderString("Range");
            RangeHeader rangeHeader = null;
            LOG.debug("range Header provided value: {}", (Object)rangeHeaderVal);
            if (rangeHeaderVal != null) {
                rangeHeader = RangeHeaderParserUtil.parseRangeHeader(rangeHeaderVal, length);
                LOG.debug("range Header provided: {}", (Object)rangeHeader);
                if (rangeHeader.isInValidRange()) {
                    throw S3ErrorTable.newError(S3ErrorTable.INVALID_RANGE, rangeHeaderVal);
                }
            }
            if (rangeHeaderVal == null || rangeHeader.isReadFull()) {
                StreamingOutput output = dest -> {
                    try (OzoneInputStream key = bucket.readKey(keyPath);){
                        IOUtils.copy((InputStream)key, (OutputStream)dest);
                    }
                };
                responseBuilder = Response.ok((Object)output).header("Content-Length", (Object)keyDetails.getDataSize());
            } else {
                OzoneInputStream key = bucket.readKey(keyPath);
                long startOffset = rangeHeader.getStartOffset();
                long endOffset = rangeHeader.getEndOffset();
                long copyLength = endOffset - startOffset + 1L;
                StreamingOutput output = dest -> {
                    try (S3WrapperInputStream s3WrapperInputStream = new S3WrapperInputStream(key.getInputStream());){
                        s3WrapperInputStream.seek(startOffset);
                        IOUtils.copyLarge((InputStream)((Object)s3WrapperInputStream), (OutputStream)dest, (long)0L, (long)copyLength, (byte[])new byte[this.bufferSize]);
                    }
                };
                responseBuilder = Response.ok((Object)output).header("Content-Length", (Object)copyLength);
                String contentRangeVal = "bytes " + rangeHeader.getStartOffset() + "-" + rangeHeader.getEndOffset() + "/" + length;
                responseBuilder.header("Content-Range", (Object)contentRangeVal);
            }
            responseBuilder.header("Accept-Ranges", (Object)"bytes");
            for (String responseHeader : this.customizableGetHeaders) {
                String headerValue = this.headers.getHeaderString(responseHeader);
                if (headerValue == null) continue;
                responseBuilder.header(responseHeader, (Object)headerValue);
            }
            this.addLastModifiedDate(responseBuilder, keyDetails);
            return responseBuilder.build();
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.KEY_NOT_FOUND) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_KEY, keyPath);
            }
            if (ex.getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, keyPath);
            }
            throw ex;
        }
    }

    private void addLastModifiedDate(Response.ResponseBuilder responseBuilder, OzoneKeyDetails key) {
        ZonedDateTime lastModificationTime = key.getModificationTime().atZone(ZoneId.of("GMT"));
        responseBuilder.header("Last-Modified", (Object)RFC1123Util.FORMAT.format(lastModificationTime));
    }

    @HEAD
    public Response head(@PathParam(value="bucket") String bucketName, @PathParam(value="path") String keyPath) throws IOException, OS3Exception {
        OzoneKeyDetails key;
        try {
            key = this.getBucket(bucketName).getKey(keyPath);
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.KEY_NOT_FOUND) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (ex.getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, keyPath);
            }
            throw ex;
        }
        Response.ResponseBuilder response = Response.ok().status(200).header("ETag", (Object)("" + key.getModificationTime())).header("Content-Length", (Object)key.getDataSize()).header("Content-Type", (Object)"binary/octet-stream");
        this.addLastModifiedDate(response, key);
        return response.build();
    }

    private Response abortMultipartUpload(String bucket, String key, String uploadId) throws IOException, OS3Exception {
        try {
            OzoneBucket ozoneBucket = this.getBucket(bucket);
            ozoneBucket.abortMultipartUpload(key, uploadId);
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_UPLOAD, uploadId);
            }
            throw ex;
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @DELETE
    public Response delete(@PathParam(value="bucket") String bucketName, @PathParam(value="path") String keyPath, @QueryParam(value="uploadId") @DefaultValue(value="") String uploadId) throws IOException, OS3Exception {
        block5: {
            try {
                if (uploadId != null && !uploadId.equals("")) {
                    return this.abortMultipartUpload(bucketName, keyPath, uploadId);
                }
                OzoneBucket bucket = this.getBucket(bucketName);
                bucket.getKey(keyPath);
                bucket.deleteKey(keyPath);
            }
            catch (OMException ex) {
                if (ex.getResult() == OMException.ResultCodes.BUCKET_NOT_FOUND) {
                    throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_BUCKET, bucketName);
                }
                if (ex.getResult() == OMException.ResultCodes.KEY_NOT_FOUND) break block5;
                if (ex.getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                    throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, keyPath);
                }
                throw ex;
            }
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @POST
    @Produces(value={"application/xml"})
    @Consumes(value={"ozone/mpu"})
    public Response initializeMultipartUpload(@PathParam(value="bucket") String bucket, @PathParam(value="path") String key) throws IOException, OS3Exception {
        try {
            OzoneBucket ozoneBucket = this.getBucket(bucket);
            String storageType = this.headers.getHeaderString("x-amz-storage-class");
            S3StorageType s3StorageType = storageType == null || storageType.equals("") ? S3StorageType.getDefault() : ObjectEndpoint.toS3StorageType(storageType);
            ReplicationType replicationType = s3StorageType.getType();
            ReplicationFactor replicationFactor = s3StorageType.getFactor();
            OmMultipartInfo multipartInfo = ozoneBucket.initiateMultipartUpload(key, replicationType, replicationFactor);
            MultipartUploadInitiateResponse multipartUploadInitiateResponse = new MultipartUploadInitiateResponse();
            multipartUploadInitiateResponse.setBucket(bucket);
            multipartUploadInitiateResponse.setKey(key);
            multipartUploadInitiateResponse.setUploadID(multipartInfo.getUploadID());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)multipartUploadInitiateResponse).build();
        }
        catch (OMException ex) {
            LOG.error("Error in Initiate Multipart Upload Request for bucket: {}, key: {}", new Object[]{bucket, key, ex});
            if (ex.getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, key);
            }
            throw ex;
        }
    }

    @POST
    @Produces(value={"application/xml"})
    public Response completeMultipartUpload(@PathParam(value="bucket") String bucket, @PathParam(value="path") String key, @QueryParam(value="uploadId") @DefaultValue(value="") String uploadID, CompleteMultipartUploadRequest multipartUploadRequest) throws IOException, OS3Exception {
        OzoneBucket ozoneBucket = this.getBucket(bucket);
        LinkedHashMap<Integer, String> partsMap = new LinkedHashMap<Integer, String>();
        List<CompleteMultipartUploadRequest.Part> partList = multipartUploadRequest.getPartList();
        try {
            for (CompleteMultipartUploadRequest.Part part : partList) {
                partsMap.put(part.getPartNumber(), part.geteTag());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parts map {}", partsMap);
            }
            OmMultipartUploadCompleteInfo omMultipartUploadCompleteInfo = ozoneBucket.completeMultipartUpload(key, uploadID, partsMap);
            CompleteMultipartUploadResponse completeMultipartUploadResponse = new CompleteMultipartUploadResponse();
            completeMultipartUploadResponse.setBucket(bucket);
            completeMultipartUploadResponse.setKey(key);
            completeMultipartUploadResponse.setETag(omMultipartUploadCompleteInfo.getHash());
            completeMultipartUploadResponse.setLocation(bucket);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)completeMultipartUploadResponse).build();
        }
        catch (OMException ex) {
            LOG.error("Error in Complete Multipart Upload Request for bucket: {}, , key: {}", new Object[]{bucket, key, ex});
            if (ex.getResult() == OMException.ResultCodes.INVALID_PART) {
                throw S3ErrorTable.newError(S3ErrorTable.INVALID_PART, key);
            }
            if (ex.getResult() == OMException.ResultCodes.INVALID_PART_ORDER) {
                throw S3ErrorTable.newError(S3ErrorTable.INVALID_PART_ORDER, key);
            }
            if (ex.getResult() == OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_UPLOAD, uploadID);
            }
            if (ex.getResult() == OMException.ResultCodes.ENTITY_TOO_SMALL) {
                throw S3ErrorTable.newError(S3ErrorTable.ENTITY_TOO_SMALL, key);
            }
            if (ex.getResult() == OMException.ResultCodes.INVALID_REQUEST) {
                OS3Exception os3Exception = S3ErrorTable.newError(S3ErrorTable.INVALID_REQUEST, key);
                os3Exception.setErrorMessage("An error occurred (InvalidRequest) when calling the CompleteMultipartUpload operation: You must specify at least one part");
                throw os3Exception;
            }
            if (ex.getResult() == OMException.ResultCodes.NOT_A_FILE) {
                OS3Exception os3Exception = S3ErrorTable.newError(S3ErrorTable.INVALID_REQUEST, key);
                os3Exception.setErrorMessage("An error occurred (InvalidRequest) when calling the CompleteMultipartUpload operation: ozone.om.enable.filesystem.paths is enabled Keys are considered as Unix Paths. A directory already exists with a given KeyName caused failure for MPU");
                throw os3Exception;
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response createMultipartKey(String bucket, String key, long length, int partNumber, String uploadID, InputStream body) throws IOException, OS3Exception {
        try {
            String copyHeader;
            OzoneOutputStream ozoneOutputStream;
            block28: {
                OzoneBucket ozoneBucket = this.getBucket(bucket);
                ozoneOutputStream = null;
                if ("STREAMING-AWS4-HMAC-SHA256-PAYLOAD".equals(this.headers.getHeaderString("x-amz-content-sha256"))) {
                    body = new SignedChunksInputStream(body);
                }
                try {
                    ozoneOutputStream = ozoneBucket.createMultipartKey(key, length, partNumber, uploadID);
                    copyHeader = this.headers.getHeaderString("x-amz-copy-source");
                    if (copyHeader != null) {
                        String copySourceIfUnmodifiedSince;
                        String copySourceIfModifiedSince;
                        Pair<String, String> result = ObjectEndpoint.parseSourceHeader(copyHeader);
                        String sourceBucket = (String)result.getLeft();
                        String sourceKey = (String)result.getRight();
                        Long sourceKeyModificationTime = this.getBucket(sourceBucket).getKey(sourceKey).getModificationTime().toEpochMilli();
                        if (!this.checkCopySourceModificationTime(sourceKeyModificationTime, copySourceIfModifiedSince = this.headers.getHeaderString("x-amz-copy-source-if-modified-since"), copySourceIfUnmodifiedSince = this.headers.getHeaderString("x-amz-copy-source-if-unmodified-since"))) {
                            throw S3ErrorTable.newError(S3ErrorTable.PRECOND_FAILED, sourceBucket + "/" + sourceKey);
                        }
                        try (OzoneInputStream sourceObject = this.getBucket(sourceBucket).readKey(sourceKey);){
                            String range = this.headers.getHeaderString("x-amz-copy-source-range");
                            if (range != null) {
                                RangeHeader rangeHeader = RangeHeaderParserUtil.parseRangeHeader(range, 0L);
                                long skipped = sourceObject.skip(rangeHeader.getStartOffset());
                                if (skipped != rangeHeader.getStartOffset()) {
                                    throw new EOFException("Bytes to skip: " + rangeHeader.getStartOffset() + " actual: " + skipped);
                                }
                                IOUtils.copyLarge((InputStream)sourceObject, (OutputStream)ozoneOutputStream, (long)0L, (long)(rangeHeader.getEndOffset() - rangeHeader.getStartOffset() + 1L));
                            } else {
                                IOUtils.copy((InputStream)sourceObject, (OutputStream)ozoneOutputStream);
                            }
                            break block28;
                        }
                    }
                    IOUtils.copy((InputStream)body, (OutputStream)ozoneOutputStream);
                }
                finally {
                    if (ozoneOutputStream != null) {
                        ozoneOutputStream.close();
                    }
                }
            }
            assert (ozoneOutputStream != null);
            OmMultipartCommitUploadPartInfo omMultipartCommitUploadPartInfo = ozoneOutputStream.getCommitUploadPartInfo();
            String eTag = omMultipartCommitUploadPartInfo.getPartName();
            if (copyHeader != null) {
                return Response.ok((Object)new CopyPartResult(eTag)).build();
            }
            return Response.ok().header("ETag", (Object)eTag).build();
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_UPLOAD, uploadID);
            }
            if (ex.getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, bucket + "/" + key);
            }
            throw ex;
        }
    }

    private Response listParts(String bucket, String key, String uploadID, int partNumberMarker, int maxParts) throws IOException, OS3Exception {
        ListPartsResponse listPartsResponse = new ListPartsResponse();
        try {
            OzoneBucket ozoneBucket = this.getBucket(bucket);
            OzoneMultipartUploadPartListParts ozoneMultipartUploadPartListParts = ozoneBucket.listParts(key, uploadID, partNumberMarker, maxParts);
            listPartsResponse.setBucket(bucket);
            listPartsResponse.setKey(key);
            listPartsResponse.setUploadID(uploadID);
            listPartsResponse.setMaxParts(maxParts);
            listPartsResponse.setPartNumberMarker(partNumberMarker);
            listPartsResponse.setTruncated(false);
            listPartsResponse.setStorageClass(S3StorageType.fromReplicationType(ozoneMultipartUploadPartListParts.getReplicationType(), ozoneMultipartUploadPartListParts.getReplicationFactor()).toString());
            if (ozoneMultipartUploadPartListParts.isTruncated()) {
                listPartsResponse.setTruncated(ozoneMultipartUploadPartListParts.isTruncated());
                listPartsResponse.setNextPartNumberMarker(ozoneMultipartUploadPartListParts.getNextPartNumberMarker());
            }
            ozoneMultipartUploadPartListParts.getPartInfoList().forEach(partInfo -> {
                ListPartsResponse.Part part = new ListPartsResponse.Part();
                part.setPartNumber(partInfo.getPartNumber());
                part.setETag(partInfo.getPartName());
                part.setSize(partInfo.getSize());
                part.setLastModified(Instant.ofEpochMilli(partInfo.getModificationTime()));
                listPartsResponse.addPart(part);
            });
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_UPLOAD, uploadID);
            }
            if (ex.getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, bucket + "/" + key + "/" + uploadID);
            }
            throw ex;
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)listPartsResponse).build();
    }

    @VisibleForTesting
    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    private CopyObjectResponse copyObject(String copyHeader, String destBucket, String destkey, ReplicationType replicationType, ReplicationFactor replicationFactor, boolean storageTypeDefault) throws OS3Exception, IOException {
        Pair<String, String> result = ObjectEndpoint.parseSourceHeader(copyHeader);
        String sourceBucket = (String)result.getLeft();
        String sourceKey = (String)result.getRight();
        OzoneInputStream sourceInputStream = null;
        OzoneOutputStream destOutputStream = null;
        boolean closed = false;
        try {
            if (sourceBucket.equals(destBucket) && sourceKey.equals(destkey)) {
                if (storageTypeDefault) {
                    OS3Exception ex = S3ErrorTable.newError(S3ErrorTable.INVALID_REQUEST, copyHeader);
                    ex.setErrorMessage("This copy request is illegal because it is trying to copy an object to it self itself without changing the object's metadata, storage class, website redirect location or encryption attributes.");
                    throw ex;
                }
                CopyObjectResponse copyObjectResponse = new CopyObjectResponse();
                copyObjectResponse.setETag(OzoneUtils.getRequestID());
                copyObjectResponse.setLastModified(Instant.ofEpochMilli(Time.now()));
                CopyObjectResponse copyObjectResponse2 = copyObjectResponse;
                return copyObjectResponse2;
            }
            OzoneBucket sourceOzoneBucket = this.getBucket(sourceBucket);
            OzoneBucket destOzoneBucket = this.getBucket(destBucket);
            OzoneKeyDetails sourceKeyDetails = sourceOzoneBucket.getKey(sourceKey);
            long sourceKeyLen = sourceKeyDetails.getDataSize();
            sourceInputStream = sourceOzoneBucket.readKey(sourceKey);
            destOutputStream = destOzoneBucket.createKey(destkey, sourceKeyLen, replicationType, replicationFactor, new HashMap());
            IOUtils.copy((InputStream)sourceInputStream, (OutputStream)destOutputStream);
            sourceInputStream.close();
            destOutputStream.close();
            closed = true;
            OzoneKeyDetails destKeyDetails = destOzoneBucket.getKey(destkey);
            CopyObjectResponse copyObjectResponse = new CopyObjectResponse();
            copyObjectResponse.setETag(OzoneUtils.getRequestID());
            copyObjectResponse.setLastModified(destKeyDetails.getModificationTime());
            CopyObjectResponse copyObjectResponse3 = copyObjectResponse;
            return copyObjectResponse3;
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.KEY_NOT_FOUND) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_KEY, sourceKey);
            }
            if (ex.getResult() == OMException.ResultCodes.BUCKET_NOT_FOUND) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_BUCKET, sourceBucket);
            }
            if (ex.getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, destBucket + "/" + destkey);
            }
            throw ex;
        }
        finally {
            if (!closed) {
                if (sourceInputStream != null) {
                    sourceInputStream.close();
                }
                if (destOutputStream != null) {
                    destOutputStream.close();
                }
            }
        }
    }

    @VisibleForTesting
    public static Pair<String, String> parseSourceHeader(String copyHeader) throws OS3Exception {
        int pos;
        String header = copyHeader;
        if (header.startsWith("/")) {
            header = copyHeader.substring(1);
        }
        if ((pos = header.indexOf(47)) == -1) {
            OS3Exception ex = S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, header);
            ex.setErrorMessage("Copy Source must mention the source bucket and key: sourcebucket/sourcekey");
            throw ex;
        }
        return Pair.of((Object)header.substring(0, pos), (Object)header.substring(pos + 1));
    }

    private static S3StorageType toS3StorageType(String storageType) throws OS3Exception {
        try {
            return S3StorageType.valueOf(storageType);
        }
        catch (IllegalArgumentException ex) {
            throw S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, storageType);
        }
    }

    private static int parsePartNumberMarker(String partNumberMarker) {
        int partMarker = 0;
        if (partNumberMarker != null) {
            partMarker = Integer.parseInt(partNumberMarker);
        }
        return partMarker;
    }

    private static long parseOzoneDate(String ozoneDateStr) throws OS3Exception {
        long ozoneDateInMs;
        try {
            ozoneDateInMs = OzoneUtils.formatDate((String)ozoneDateStr);
        }
        catch (ParseException e) {
            throw S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, ozoneDateStr);
        }
        return ozoneDateInMs;
    }

    private boolean checkCopySourceModificationTime(Long lastModificationTime, String copySourceIfModifiedSinceStr, String copySourceIfUnmodifiedSinceStr) throws OS3Exception {
        long copySourceIfModifiedSince = Long.MIN_VALUE;
        long copySourceIfUnmodifiedSince = Long.MAX_VALUE;
        if (copySourceIfModifiedSinceStr != null) {
            copySourceIfModifiedSince = ObjectEndpoint.parseOzoneDate(copySourceIfModifiedSinceStr);
        }
        if (copySourceIfUnmodifiedSinceStr != null) {
            copySourceIfUnmodifiedSince = ObjectEndpoint.parseOzoneDate(copySourceIfUnmodifiedSinceStr);
        }
        return copySourceIfModifiedSince <= lastModificationTime && lastModificationTime <= copySourceIfUnmodifiedSince;
    }
}

