/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import java.io.IOException;
import java.util.Iterator;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.s3.commontypes.BucketMetadata;
import org.apache.hadoop.ozone.s3.endpoint.EndpointBase;
import org.apache.hadoop.ozone.s3.endpoint.ListBucketResponse;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class RootEndpoint
extends EndpointBase {
    private static final Logger LOG = LoggerFactory.getLogger(RootEndpoint.class);

    @GET
    public Response get() throws OS3Exception, IOException {
        ListBucketResponse response = new ListBucketResponse();
        Iterator<? extends OzoneBucket> bucketIterator = this.listS3Buckets(null);
        while (bucketIterator.hasNext()) {
            OzoneBucket next = bucketIterator.next();
            BucketMetadata bucketMetadata = new BucketMetadata();
            bucketMetadata.setName(next.getName());
            bucketMetadata.setCreationDate(next.getCreationTime());
            response.addBucket(bucketMetadata);
        }
        return Response.ok((Object)response).build();
    }
}

