/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.header;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.ozone.s3.AWSSignatureProcessor;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.apache.hadoop.ozone.s3.header.Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationHeaderV4 {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationHeaderV4.class);
    private static final String CREDENTIAL = "Credential=";
    private static final String SIGNEDHEADERS = "SignedHeaders=";
    private static final String SIGNATURE = "Signature=";
    private String authHeader;
    private String algorithm;
    private String credential;
    private String signedHeadersStr;
    private String signature;
    private Credential credentialObj;
    private Collection<String> signedHeaders;

    public AuthorizationHeaderV4(String header) throws OS3Exception {
        Preconditions.checkNotNull((Object)header);
        this.authHeader = header;
        this.parseAuthHeader();
    }

    public void parseAuthHeader() throws OS3Exception {
        int firstSep = this.authHeader.indexOf(32);
        if (firstSep < 0) {
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        String[] split = this.authHeader.substring(firstSep + 1).trim().split(", *");
        if (split.length != 3) {
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        this.algorithm = this.authHeader.substring(0, firstSep);
        this.validateAlgorithm();
        this.credential = split[0];
        this.signedHeadersStr = split[1];
        this.signature = split[2];
        this.validateCredentials();
        this.validateSignedHeaders();
        this.validateSignature();
    }

    private void validateSignedHeaders() throws OS3Exception {
        if (StringUtils.isNotEmpty((CharSequence)this.signedHeadersStr) && this.signedHeadersStr.startsWith(SIGNEDHEADERS)) {
            this.signedHeadersStr = this.signedHeadersStr.substring(SIGNEDHEADERS.length());
            this.signedHeaders = org.apache.hadoop.util.StringUtils.getStringCollection((String)this.signedHeadersStr, (String)";");
            if (this.signedHeaders.size() == 0) {
                LOG.error("No signed headers found. Authheader:{}", (Object)this.authHeader);
                throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
            }
        } else {
            LOG.error("No signed headers found. Authheader:{}", (Object)this.authHeader);
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
    }

    private void validateSignature() throws OS3Exception {
        if (this.signature.startsWith(SIGNATURE)) {
            this.signature = this.signature.substring(SIGNATURE.length());
            if (StringUtils.isEmpty((CharSequence)this.signature)) {
                LOG.error("Signature can't be empty: {}", (Object)this.signature);
                throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
            }
            try {
                Hex.decodeHex((String)this.signature);
            }
            catch (DecoderException e) {
                LOG.error("Signature:{} should be in hexa-decimal encoding.", (Object)this.signature);
                throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
            }
        } else {
            LOG.error("No signature found: {}", (Object)this.signature);
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
    }

    private void validateCredentials() throws OS3Exception {
        if (!StringUtils.isNotEmpty((CharSequence)this.credential) || !this.credential.startsWith(CREDENTIAL)) {
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        this.credential = this.credential.substring(CREDENTIAL.length());
        this.credentialObj = new Credential(this.credential);
        if (this.credentialObj.getAccessKeyID().isEmpty()) {
            LOG.error("AWS access id shouldn't be empty. credential:{}", (Object)this.credential);
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        if (this.credentialObj.getAwsRegion().isEmpty()) {
            LOG.error("AWS region shouldn't be empty. credential:{}", (Object)this.credential);
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        if (this.credentialObj.getAwsRequest().isEmpty()) {
            LOG.error("AWS request shouldn't be empty. credential:{}", (Object)this.credential);
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        if (this.credentialObj.getAwsService().isEmpty()) {
            LOG.error("AWS service shouldn't be empty. credential:{}", (Object)this.credential);
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        if (this.credentialObj.getDate().isEmpty()) {
            LOG.error("AWS date shouldn't be empty. credential:{}", (Object)this.credential);
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        this.validateDateRange();
    }

    @VisibleForTesting
    public void validateDateRange() throws OS3Exception {
        LocalDate now;
        LocalDate date = LocalDate.parse(this.credentialObj.getDate(), AWSSignatureProcessor.DATE_FORMATTER);
        if (date.isBefore((now = LocalDate.now()).minus(1L, ChronoUnit.DAYS)) || date.isAfter(now.plus(1L, ChronoUnit.DAYS))) {
            LOG.error("AWS date not in valid range. Date:{} should not be older than 1 day(i.e yesterday) and greater than 1 day(i.e tomorrow).", (Object)this.getDate());
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
    }

    private void validateAlgorithm() throws OS3Exception {
        if (StringUtils.isEmpty((CharSequence)this.algorithm) || !this.algorithm.equals("AWS4-HMAC-SHA256")) {
            LOG.error("Unexpected hash algorithm. Algo:{}", (Object)this.algorithm);
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
    }

    public String getAuthHeader() {
        return this.authHeader;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getCredential() {
        return this.credential;
    }

    public String getSignedHeaderString() {
        return this.signedHeadersStr;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getAccessKeyID() {
        return this.credentialObj.getAccessKeyID();
    }

    public String getDate() {
        return this.credentialObj.getDate();
    }

    public String getAwsRegion() {
        return this.credentialObj.getAwsRegion();
    }

    public String getAwsService() {
        return this.credentialObj.getAwsService();
    }

    public String getAwsRequest() {
        return this.credentialObj.getAwsRequest();
    }

    public Collection<String> getSignedHeaders() {
        return this.signedHeaders;
    }

    public Credential getCredentialObj() {
        return this.credentialObj;
    }
}

