/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.util;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.security.SecurityUtil;

public final class OzoneS3Util {
    private OzoneS3Util() {
    }

    public static String getS3Username(String userName) {
        Objects.requireNonNull(userName);
        return DigestUtils.md5Hex((String)userName.toLowerCase());
    }

    public static String buildServiceNameForToken(@Nonnull OzoneConfiguration configuration, @Nonnull String serviceId, @Nonnull Collection<String> omNodeIds) {
        StringBuilder rpcAddress = new StringBuilder();
        int nodesLength = omNodeIds.size();
        int counter = 0;
        for (String nodeId : omNodeIds) {
            ++counter;
            String rpcAddrKey = OmUtils.addKeySuffixes((String)"ozone.om.address", (String[])new String[]{serviceId, nodeId});
            String rpcAddrStr = OmUtils.getOmRpcAddress((ConfigurationSource)configuration, (String)rpcAddrKey);
            if (rpcAddrStr == null || rpcAddrStr.isEmpty()) {
                throw new IllegalArgumentException("Could not find rpcAddress for ozone.om.address." + serviceId + "." + nodeId);
            }
            if (counter != nodesLength) {
                rpcAddress.append(SecurityUtil.buildTokenService((InetSocketAddress)NetUtils.createSocketAddr((String)rpcAddrStr)) + ",");
                continue;
            }
            rpcAddress.append(SecurityUtil.buildTokenService((InetSocketAddress)NetUtils.createSocketAddr((String)rpcAddrStr)));
        }
        return rpcAddress.toString();
    }
}

