/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.util;

import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;

public enum S3StorageType {
    REDUCED_REDUNDANCY(ReplicationType.RATIS, ReplicationFactor.ONE),
    STANDARD(ReplicationType.RATIS, ReplicationFactor.THREE);

    private final ReplicationType type;
    private final ReplicationFactor factor;

    private S3StorageType(ReplicationType type, ReplicationFactor factor) {
        this.type = type;
        this.factor = factor;
    }

    public ReplicationFactor getFactor() {
        return this.factor;
    }

    public ReplicationType getType() {
        return this.type;
    }

    public static S3StorageType getDefault() {
        return STANDARD;
    }

    public static S3StorageType fromReplicationType(ReplicationType replicationType, ReplicationFactor factor) {
        if (replicationType == ReplicationType.STAND_ALONE || factor == ReplicationFactor.ONE) {
            return REDUCED_REDUNDANCY;
        }
        return STANDARD;
    }
}

