/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen.datatypes;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.tools.rumen.ParsedHost;
import org.apache.hadoop.tools.rumen.anonymization.WordList;
import org.apache.hadoop.tools.rumen.datatypes.AnonymizableDataType;
import org.apache.hadoop.tools.rumen.state.State;
import org.apache.hadoop.tools.rumen.state.StatePool;
import org.codehaus.jackson.annotate.JsonIgnore;

public class NodeName
implements AnonymizableDataType<String> {
    private String hostName;
    private String rackName;
    private String nodeName;
    private String anonymizedNodeName;
    public static final NodeName ROOT = new NodeName("<root>");

    public NodeName(String nodeName) {
        this.nodeName = nodeName;
        ParsedHost pHost = ParsedHost.parse(nodeName);
        if (pHost == null) {
            this.rackName = null;
            this.hostName = nodeName;
        } else {
            this.rackName = pHost.getRackName();
            this.hostName = pHost.getNodeName();
        }
    }

    public NodeName(String rName, String hName) {
        String string = rName == null ? rName : (rName = rName.length() == 0 ? null : rName);
        String string2 = hName == null ? hName : (hName = hName.length() == 0 ? null : hName);
        if (hName == null) {
            this.nodeName = rName;
            this.rackName = rName;
        } else if (rName == null) {
            this.nodeName = hName;
            ParsedHost pHost = ParsedHost.parse(this.nodeName);
            if (pHost == null) {
                this.rackName = null;
                this.hostName = hName;
            } else {
                this.rackName = pHost.getRackName();
                this.hostName = pHost.getNodeName();
            }
        } else {
            this.rackName = rName;
            this.hostName = hName;
            this.nodeName = "/" + rName + "/" + hName;
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getRackName() {
        return this.rackName;
    }

    @Override
    public String getValue() {
        return this.nodeName;
    }

    @Override
    public String getAnonymizedValue(StatePool statePool, Configuration conf) {
        if (this.getValue().equals(ROOT.getValue())) {
            return this.getValue();
        }
        if (this.anonymizedNodeName == null) {
            this.anonymize(statePool);
        }
        return this.anonymizedNodeName;
    }

    private void anonymize(StatePool pool) {
        StringBuffer buf = new StringBuffer();
        NodeNameState state = (NodeNameState)pool.getState(this.getClass());
        if (state == null) {
            state = new NodeNameState();
            pool.addState(this.getClass(), state);
        }
        if (this.rackName != null && this.hostName != null) {
            buf.append('/');
            buf.append(NodeName.anonymize(this.rackName, state.getRackNameState()));
            buf.append('/');
            buf.append(NodeName.anonymize(this.hostName, state.getHostNameState()));
        } else if (state.getRackNameState().contains(this.nodeName) || this.rackName != null) {
            buf.append(NodeName.anonymize(this.nodeName, state.getRackNameState()));
        } else {
            buf.append(NodeName.anonymize(this.nodeName, state.getHostNameState()));
        }
        this.anonymizedNodeName = buf.toString();
    }

    private static String anonymize(String data, WordList wordList) {
        if (data == null) {
            return null;
        }
        if (!wordList.contains(data)) {
            wordList.add(data);
        }
        return wordList.getName() + wordList.indexOf(data);
    }

    public static class NodeNameState
    implements State {
        private WordList rackNameState = new WordList("rack");
        private WordList hostNameState = new WordList("host");

        @Override
        @JsonIgnore
        public boolean isUpdated() {
            return this.rackNameState.isUpdated() || this.hostNameState.isUpdated();
        }

        public WordList getRackNameState() {
            return this.rackNameState;
        }

        public WordList getHostNameState() {
            return this.hostNameState;
        }

        public void setRackNameState(WordList state) {
            this.rackNameState = state;
        }

        public void setHostNameState(WordList state) {
            this.hostNameState = state;
        }

        @Override
        public String getName() {
            return "node";
        }

        @Override
        public void setName(String name) {
            if (!this.getName().equals(name)) {
                throw new RuntimeException("State name mismatch! Expected '" + this.getName() + "' but found '" + name + "'.");
            }
        }
    }
}

