/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.AMStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JhCounters;
import org.apache.hadoop.mapreduce.jobhistory.JobFinished;
import org.apache.hadoop.mapreduce.jobhistory.JobFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobInfoChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobInitedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobPriorityChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobStatusChangedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobSubmittedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.jobhistory.MapAttemptFinished;
import org.apache.hadoop.mapreduce.jobhistory.MapAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.ReduceAttemptFinished;
import org.apache.hadoop.mapreduce.jobhistory.ReduceAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptFinished;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptUnsuccessfulCompletion;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFailed;
import org.apache.hadoop.mapreduce.jobhistory.TaskFailedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFinished;
import org.apache.hadoop.mapreduce.jobhistory.TaskFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskUpdatedEvent;
import org.apache.hadoop.tools.rumen.Histogram;
import org.apache.hadoop.tools.rumen.JobBuilder;
import org.apache.hadoop.tools.rumen.JobConfPropertyNames;
import org.apache.hadoop.tools.rumen.JobHistoryUtils;
import org.apache.hadoop.tools.rumen.LoggedDiscreteCDF;
import org.apache.hadoop.tools.rumen.LoggedJob;
import org.apache.hadoop.tools.rumen.LoggedLocation;
import org.apache.hadoop.tools.rumen.LoggedTask;
import org.apache.hadoop.tools.rumen.LoggedTaskAttempt;
import org.apache.hadoop.tools.rumen.ParsedHost;
import org.apache.hadoop.tools.rumen.ParsedJob;
import org.apache.hadoop.tools.rumen.ParsedTask;
import org.apache.hadoop.tools.rumen.ParsedTaskAttempt;
import org.apache.hadoop.tools.rumen.Pre21JobHistoryConstants;
import org.apache.hadoop.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class JobBuilder {
    private static final long BYTES_IN_MEG = StringUtils.TraditionalBinaryPrefix.string2long((String)"1m");
    private String jobID;
    private boolean finalized = false;
    private ParsedJob result = new ParsedJob();
    private Map<String, ParsedTask> mapTasks = new HashMap();
    private Map<String, ParsedTask> reduceTasks = new HashMap();
    private Map<String, ParsedTask> otherTasks = new HashMap();
    private Map<String, ParsedTaskAttempt> attempts = new HashMap();
    private Map<ParsedHost, ParsedHost> allHosts = new HashMap();
    private static final int MAXIMUM_PREFERRED_LOCATIONS = 25;
    private int[] attemptTimesPercentiles = null;
    private static final Pattern heapPattern = Pattern.compile("-Xmx([0-9]+[kKmMgGtT])");
    private Properties jobConfigurationParameters = null;

    public JobBuilder(String jobID) {
        if (this.attemptTimesPercentiles == null) {
            this.attemptTimesPercentiles = new int[19];
            for (int i = 0; i < 19; ++i) {
                this.attemptTimesPercentiles[i] = (i + 1) * 5;
            }
        }
        this.jobID = jobID;
    }

    public String getJobID() {
        return this.jobID;
    }

    public void process(HistoryEvent event) {
        if (this.finalized) {
            throw new IllegalStateException("JobBuilder.process(HistoryEvent event) called after ParsedJob built");
        }
        if (event instanceof AMStartedEvent) {
            return;
        }
        if (event instanceof JobFinishedEvent) {
            this.processJobFinishedEvent((JobFinishedEvent)event);
        } else if (event instanceof JobInfoChangeEvent) {
            this.processJobInfoChangeEvent((JobInfoChangeEvent)event);
        } else if (event instanceof JobInitedEvent) {
            this.processJobInitedEvent((JobInitedEvent)event);
        } else if (event instanceof JobPriorityChangeEvent) {
            this.processJobPriorityChangeEvent((JobPriorityChangeEvent)event);
        } else if (event instanceof JobStatusChangedEvent) {
            this.processJobStatusChangedEvent((JobStatusChangedEvent)event);
        } else if (event instanceof JobSubmittedEvent) {
            this.processJobSubmittedEvent((JobSubmittedEvent)event);
        } else if (event instanceof JobUnsuccessfulCompletionEvent) {
            this.processJobUnsuccessfulCompletionEvent((JobUnsuccessfulCompletionEvent)event);
        } else if (event instanceof MapAttemptFinishedEvent) {
            this.processMapAttemptFinishedEvent((MapAttemptFinishedEvent)event);
        } else if (event instanceof ReduceAttemptFinishedEvent) {
            this.processReduceAttemptFinishedEvent((ReduceAttemptFinishedEvent)event);
        } else if (event instanceof TaskAttemptFinishedEvent) {
            this.processTaskAttemptFinishedEvent((TaskAttemptFinishedEvent)event);
        } else if (event instanceof TaskAttemptStartedEvent) {
            this.processTaskAttemptStartedEvent((TaskAttemptStartedEvent)event);
        } else if (event instanceof TaskAttemptUnsuccessfulCompletionEvent) {
            this.processTaskAttemptUnsuccessfulCompletionEvent((TaskAttemptUnsuccessfulCompletionEvent)event);
        } else if (event instanceof TaskFailedEvent) {
            this.processTaskFailedEvent((TaskFailedEvent)event);
        } else if (event instanceof TaskFinishedEvent) {
            this.processTaskFinishedEvent((TaskFinishedEvent)event);
        } else if (event instanceof TaskStartedEvent) {
            this.processTaskStartedEvent((TaskStartedEvent)event);
        } else if (event instanceof TaskUpdatedEvent) {
            this.processTaskUpdatedEvent((TaskUpdatedEvent)event);
        } else {
            throw new IllegalArgumentException("JobBuilder.process(HistoryEvent): unknown event type");
        }
    }

    static String extract(Properties conf, String[] names, String defaultValue) {
        for (String name : names) {
            String result = conf.getProperty(name);
            if (result == null) continue;
            return result;
        }
        return defaultValue;
    }

    private Integer extractMegabytes(Properties conf, String[] names) {
        String javaOptions = JobBuilder.extract((Properties)conf, (String[])names, null);
        if (javaOptions == null) {
            return null;
        }
        Matcher matcher = heapPattern.matcher(javaOptions);
        Integer heapMegabytes = null;
        while (matcher.find()) {
            String heapSize = matcher.group(1);
            heapMegabytes = (int)(StringUtils.TraditionalBinaryPrefix.string2long((String)heapSize) / BYTES_IN_MEG);
        }
        return heapMegabytes;
    }

    private void maybeSetHeapMegabytes(Integer megabytes) {
        if (megabytes != null) {
            this.result.setHeapMegabytes(megabytes.intValue());
        }
    }

    private void maybeSetJobMapMB(Integer megabytes) {
        if (megabytes != null) {
            this.result.setJobMapMB(megabytes.intValue());
        }
    }

    private void maybeSetJobReduceMB(Integer megabytes) {
        if (megabytes != null) {
            this.result.setJobReduceMB(megabytes.intValue());
        }
    }

    public void process(Properties conf) {
        if (this.finalized) {
            throw new IllegalStateException("JobBuilder.process(Properties conf) called after ParsedJob built");
        }
        String queue = JobBuilder.extract((Properties)conf, (String[])JobConfPropertyNames.QUEUE_NAMES.getCandidates(), null);
        if (queue != null) {
            this.result.setQueue(queue);
        }
        this.result.setJobName(JobBuilder.extract((Properties)conf, (String[])JobConfPropertyNames.JOB_NAMES.getCandidates(), null));
        this.maybeSetHeapMegabytes(this.extractMegabytes(conf, JobConfPropertyNames.TASK_JAVA_OPTS_S.getCandidates()));
        this.maybeSetJobMapMB(this.extractMegabytes(conf, JobConfPropertyNames.MAP_JAVA_OPTS_S.getCandidates()));
        this.maybeSetJobReduceMB(this.extractMegabytes(conf, JobConfPropertyNames.REDUCE_JAVA_OPTS_S.getCandidates()));
        this.jobConfigurationParameters = conf;
    }

    public ParsedJob build() {
        this.finalized = true;
        if (this.jobConfigurationParameters != null) {
            this.result.setJobProperties(this.jobConfigurationParameters);
        }
        Histogram[] successfulMapAttemptTimes = new Histogram[ParsedHost.numberOfDistances() + 1];
        for (int i = 0; i < successfulMapAttemptTimes.length; ++i) {
            successfulMapAttemptTimes[i] = new Histogram();
        }
        Histogram successfulReduceAttemptTimes = new Histogram();
        Histogram[] failedMapAttemptTimes = new Histogram[ParsedHost.numberOfDistances() + 1];
        for (int i = 0; i < failedMapAttemptTimes.length; ++i) {
            failedMapAttemptTimes[i] = new Histogram();
        }
        Histogram failedReduceAttemptTimes = new Histogram();
        Histogram successfulNthMapperAttempts = new Histogram();
        for (LoggedTask task : this.result.getMapTasks()) {
            for (LoggedTaskAttempt attempt : task.getAttempts()) {
                int distance = successfulMapAttemptTimes.length - 1;
                Long runtime = null;
                if (attempt.getFinishTime() <= 0L || attempt.getStartTime() <= 0L) continue;
                runtime = attempt.getFinishTime() - attempt.getStartTime();
                if (attempt.getResult() == Pre21JobHistoryConstants.Values.SUCCESS) {
                    TaskAttemptID attemptID;
                    LoggedLocation host = attempt.getLocation();
                    List locs = task.getPreferredLocations();
                    if (host != null && locs != null) {
                        for (LoggedLocation loc : locs) {
                            ParsedHost preferedLoc = new ParsedHost(loc);
                            distance = Math.min(distance, preferedLoc.distance(new ParsedHost(host)));
                        }
                    }
                    if (attempt.getStartTime() > 0L && attempt.getFinishTime() > 0L && runtime != null) {
                        successfulMapAttemptTimes[distance].enter(runtime.longValue());
                    }
                    if ((attemptID = attempt.getAttemptID()) == null) continue;
                    successfulNthMapperAttempts.enter((long)attemptID.getId());
                    continue;
                }
                if (attempt.getResult() != Pre21JobHistoryConstants.Values.FAILED || runtime == null) continue;
                failedMapAttemptTimes[distance].enter(runtime.longValue());
            }
        }
        for (LoggedTask task : this.result.getReduceTasks()) {
            for (LoggedTaskAttempt attempt : task.getAttempts()) {
                Long runtime = attempt.getFinishTime() - attempt.getStartTime();
                if (attempt.getFinishTime() > 0L && attempt.getStartTime() > 0L) {
                    runtime = attempt.getFinishTime() - attempt.getStartTime();
                }
                if (attempt.getResult() == Pre21JobHistoryConstants.Values.SUCCESS) {
                    if (runtime == null) continue;
                    successfulReduceAttemptTimes.enter(runtime.longValue());
                    continue;
                }
                if (attempt.getResult() != Pre21JobHistoryConstants.Values.FAILED) continue;
                failedReduceAttemptTimes.enter(runtime.longValue());
            }
        }
        this.result.setFailedMapAttemptCDFs(this.mapCDFArrayList(failedMapAttemptTimes));
        LoggedDiscreteCDF failedReduce = new LoggedDiscreteCDF();
        failedReduce.setCDF(failedReduceAttemptTimes, this.attemptTimesPercentiles, 100);
        this.result.setFailedReduceAttemptCDF(failedReduce);
        this.result.setSuccessfulMapAttemptCDFs(this.mapCDFArrayList(successfulMapAttemptTimes));
        LoggedDiscreteCDF succReduce = new LoggedDiscreteCDF();
        succReduce.setCDF(successfulReduceAttemptTimes, this.attemptTimesPercentiles, 100);
        this.result.setSuccessfulReduceAttemptCDF(succReduce);
        long totalSuccessfulAttempts = 0L;
        long maxTriesToSucceed = 0L;
        for (Map.Entry ent : successfulNthMapperAttempts) {
            totalSuccessfulAttempts += ((Long)ent.getValue()).longValue();
            maxTriesToSucceed = Math.max(maxTriesToSucceed, (Long)ent.getKey());
        }
        if (totalSuccessfulAttempts > 0L) {
            double[] successAfterI = new double[(int)maxTriesToSucceed + 1];
            for (int i = 0; i < successAfterI.length; ++i) {
                successAfterI[i] = 0.0;
            }
            for (Map.Entry ent : successfulNthMapperAttempts) {
                successAfterI[((Long)ent.getKey()).intValue()] = (double)((Long)ent.getValue()).longValue() / (double)totalSuccessfulAttempts;
            }
            this.result.setMapperTriesToSucceed(successAfterI);
        } else {
            this.result.setMapperTriesToSucceed(null);
        }
        return this.result;
    }

    private ArrayList<LoggedDiscreteCDF> mapCDFArrayList(Histogram[] data) {
        ArrayList<LoggedDiscreteCDF> result = new ArrayList<LoggedDiscreteCDF>();
        for (Histogram hist : data) {
            LoggedDiscreteCDF discCDF = new LoggedDiscreteCDF();
            discCDF.setCDF(hist, this.attemptTimesPercentiles, 100);
            result.add(discCDF);
        }
        return result;
    }

    private static Pre21JobHistoryConstants.Values getPre21Value(String name) {
        if (name.equalsIgnoreCase("JOB_CLEANUP")) {
            return Pre21JobHistoryConstants.Values.CLEANUP;
        }
        if (name.equalsIgnoreCase("JOB_SETUP")) {
            return Pre21JobHistoryConstants.Values.SETUP;
        }
        if (name.equalsIgnoreCase(TaskStatus.State.SUCCEEDED.toString())) {
            return Pre21JobHistoryConstants.Values.SUCCESS;
        }
        return Pre21JobHistoryConstants.Values.valueOf((String)name.toUpperCase());
    }

    private void processTaskUpdatedEvent(TaskUpdatedEvent event) {
        ParsedTask task = this.getTask(event.getTaskId().toString());
        if (task == null) {
            return;
        }
        task.setFinishTime(event.getFinishTime());
    }

    private void processTaskStartedEvent(TaskStartedEvent event) {
        ParsedTask task = this.getOrMakeTask(event.getTaskType(), event.getTaskId().toString(), true);
        task.setStartTime(event.getStartTime());
        task.setPreferredLocations((List)this.preferredLocationForSplits(event.getSplitLocations()));
    }

    private void processTaskFinishedEvent(TaskFinishedEvent event) {
        ParsedTask task = this.getOrMakeTask(event.getTaskType(), event.getTaskId().toString(), false);
        if (task == null) {
            return;
        }
        task.setFinishTime(event.getFinishTime());
        task.setTaskStatus(JobBuilder.getPre21Value((String)event.getTaskStatus()));
        task.incorporateCounters(((TaskFinished)event.getDatum()).counters);
    }

    private void processTaskFailedEvent(TaskFailedEvent event) {
        ParsedTask task = this.getOrMakeTask(event.getTaskType(), event.getTaskId().toString(), false);
        if (task == null) {
            return;
        }
        task.setFinishTime(event.getFinishTime());
        task.setTaskStatus(JobBuilder.getPre21Value((String)event.getTaskStatus()));
        TaskFailed t = (TaskFailed)event.getDatum();
        task.putDiagnosticInfo(t.error.toString());
        task.putFailedDueToAttemptId(t.failedDueToAttempt.toString());
    }

    private void processTaskAttemptUnsuccessfulCompletionEvent(TaskAttemptUnsuccessfulCompletionEvent event) {
        ParsedTaskAttempt attempt = this.getOrMakeTaskAttempt(event.getTaskType(), event.getTaskId().toString(), event.getTaskAttemptId().toString());
        if (attempt == null) {
            return;
        }
        attempt.setResult(JobBuilder.getPre21Value((String)event.getTaskStatus()));
        attempt.setHostName(event.getHostname(), event.getRackName());
        ParsedHost pHost = this.getAndRecordParsedHost(event.getRackName(), event.getHostname());
        if (pHost != null) {
            attempt.setLocation(pHost.makeLoggedLocation());
        }
        attempt.setFinishTime(event.getFinishTime());
        attempt.arraySetClockSplits(event.getClockSplits());
        attempt.arraySetCpuUsages(event.getCpuUsages());
        attempt.arraySetVMemKbytes(event.getVMemKbytes());
        attempt.arraySetPhysMemKbytes(event.getPhysMemKbytes());
        TaskAttemptUnsuccessfulCompletion t = (TaskAttemptUnsuccessfulCompletion)event.getDatum();
        attempt.putDiagnosticInfo(t.error.toString());
    }

    private void processTaskAttemptStartedEvent(TaskAttemptStartedEvent event) {
        ParsedTaskAttempt attempt = this.getOrMakeTaskAttempt(event.getTaskType(), event.getTaskId().toString(), event.getTaskAttemptId().toString());
        if (attempt == null) {
            return;
        }
        attempt.setStartTime(event.getStartTime());
        attempt.putTrackerName(event.getTrackerName());
        attempt.putHttpPort(event.getHttpPort());
        attempt.putShufflePort(event.getShufflePort());
    }

    private void processTaskAttemptFinishedEvent(TaskAttemptFinishedEvent event) {
        ParsedTaskAttempt attempt = this.getOrMakeTaskAttempt(event.getTaskType(), event.getTaskId().toString(), event.getAttemptId().toString());
        if (attempt == null) {
            return;
        }
        attempt.setResult(JobBuilder.getPre21Value((String)event.getTaskStatus()));
        ParsedHost pHost = this.getAndRecordParsedHost(event.getRackName(), event.getHostname());
        if (pHost != null) {
            attempt.setLocation(pHost.makeLoggedLocation());
        }
        attempt.setFinishTime(event.getFinishTime());
        attempt.incorporateCounters(((TaskAttemptFinished)event.getDatum()).counters);
    }

    private void processReduceAttemptFinishedEvent(ReduceAttemptFinishedEvent event) {
        ParsedTaskAttempt attempt = this.getOrMakeTaskAttempt(event.getTaskType(), event.getTaskId().toString(), event.getAttemptId().toString());
        if (attempt == null) {
            return;
        }
        attempt.setResult(JobBuilder.getPre21Value((String)event.getTaskStatus()));
        attempt.setHostName(event.getHostname(), event.getRackName());
        ParsedHost pHost = this.getAndRecordParsedHost(event.getRackName(), event.getHostname());
        if (pHost != null) {
            attempt.setLocation(pHost.makeLoggedLocation());
        }
        attempt.setFinishTime(event.getFinishTime());
        attempt.setShuffleFinished(event.getShuffleFinishTime());
        attempt.setSortFinished(event.getSortFinishTime());
        attempt.incorporateCounters(((ReduceAttemptFinished)event.getDatum()).counters);
        attempt.arraySetClockSplits(event.getClockSplits());
        attempt.arraySetCpuUsages(event.getCpuUsages());
        attempt.arraySetVMemKbytes(event.getVMemKbytes());
        attempt.arraySetPhysMemKbytes(event.getPhysMemKbytes());
    }

    private void processMapAttemptFinishedEvent(MapAttemptFinishedEvent event) {
        ParsedTaskAttempt attempt = this.getOrMakeTaskAttempt(event.getTaskType(), event.getTaskId().toString(), event.getAttemptId().toString());
        if (attempt == null) {
            return;
        }
        attempt.setResult(JobBuilder.getPre21Value((String)event.getTaskStatus()));
        attempt.setHostName(event.getHostname(), event.getRackName());
        ParsedHost pHost = this.getAndRecordParsedHost(event.getRackName(), event.getHostname());
        if (pHost != null) {
            attempt.setLocation(pHost.makeLoggedLocation());
        }
        attempt.setFinishTime(event.getFinishTime());
        attempt.incorporateCounters(((MapAttemptFinished)event.getDatum()).counters);
        attempt.arraySetClockSplits(event.getClockSplits());
        attempt.arraySetCpuUsages(event.getCpuUsages());
        attempt.arraySetVMemKbytes(event.getVMemKbytes());
        attempt.arraySetPhysMemKbytes(event.getPhysMemKbytes());
    }

    private void processJobUnsuccessfulCompletionEvent(JobUnsuccessfulCompletionEvent event) {
        this.result.setOutcome(Pre21JobHistoryConstants.Values.valueOf((String)event.getStatus()));
        this.result.setFinishTime(event.getFinishTime());
    }

    private void processJobSubmittedEvent(JobSubmittedEvent event) {
        this.result.setJobID(event.getJobId().toString());
        this.result.setJobName(event.getJobName());
        this.result.setUser(event.getUserName());
        this.result.setSubmitTime(event.getSubmitTime());
        this.result.putJobConfPath(event.getJobConfPath());
        this.result.putJobAcls(event.getJobAcls());
        String queue = event.getJobQueueName();
        if (queue != null) {
            this.result.setQueue(queue);
        }
    }

    private void processJobStatusChangedEvent(JobStatusChangedEvent event) {
        this.result.setOutcome(Pre21JobHistoryConstants.Values.valueOf((String)event.getStatus()));
    }

    private void processJobPriorityChangeEvent(JobPriorityChangeEvent event) {
        this.result.setPriority(LoggedJob.JobPriority.valueOf((String)event.getPriority().toString()));
    }

    private void processJobInitedEvent(JobInitedEvent event) {
        this.result.setLaunchTime(event.getLaunchTime());
        this.result.setTotalMaps(event.getTotalMaps());
        this.result.setTotalReduces(event.getTotalReduces());
    }

    private void processJobInfoChangeEvent(JobInfoChangeEvent event) {
        this.result.setLaunchTime(event.getLaunchTime());
    }

    private void processJobFinishedEvent(JobFinishedEvent event) {
        this.result.setFinishTime(event.getFinishTime());
        this.result.setJobID(this.jobID);
        this.result.setOutcome(Pre21JobHistoryConstants.Values.SUCCESS);
        JobFinished job = (JobFinished)event.getDatum();
        Map countersMap = JobHistoryUtils.extractCounters((JhCounters)job.totalCounters);
        this.result.putTotalCounters(countersMap);
        countersMap = JobHistoryUtils.extractCounters((JhCounters)job.mapCounters);
        this.result.putMapCounters(countersMap);
        countersMap = JobHistoryUtils.extractCounters((JhCounters)job.reduceCounters);
        this.result.putReduceCounters(countersMap);
    }

    private ParsedTask getTask(String taskIDname) {
        ParsedTask result = (ParsedTask)this.mapTasks.get(taskIDname);
        if (result != null) {
            return result;
        }
        result = (ParsedTask)this.reduceTasks.get(taskIDname);
        if (result != null) {
            return result;
        }
        return (ParsedTask)this.otherTasks.get(taskIDname);
    }

    private ParsedTask getOrMakeTask(TaskType type, String taskIDname, boolean allowCreate) {
        Map taskMap = this.otherTasks;
        List tasks = this.result.getOtherTasks();
        switch (1.$SwitchMap$org$apache$hadoop$mapreduce$TaskType[type.ordinal()]) {
            case 1: {
                taskMap = this.mapTasks;
                tasks = this.result.getMapTasks();
                break;
            }
            case 2: {
                taskMap = this.reduceTasks;
                tasks = this.result.getReduceTasks();
                break;
            }
        }
        ParsedTask result = (ParsedTask)taskMap.get(taskIDname);
        if (result == null && allowCreate) {
            result = new ParsedTask();
            result.setTaskType(JobBuilder.getPre21Value((String)type.toString()));
            result.setTaskID(taskIDname);
            taskMap.put(taskIDname, result);
            tasks.add(result);
        }
        return result;
    }

    private ParsedTaskAttempt getOrMakeTaskAttempt(TaskType type, String taskIDName, String taskAttemptName) {
        ParsedTask task = this.getOrMakeTask(type, taskIDName, false);
        ParsedTaskAttempt result = (ParsedTaskAttempt)this.attempts.get(taskAttemptName);
        if (result == null && task != null) {
            result = new ParsedTaskAttempt();
            result.setAttemptID(taskAttemptName);
            this.attempts.put(taskAttemptName, result);
            task.getAttempts().add(result);
        }
        return result;
    }

    private ParsedHost getAndRecordParsedHost(String hostName) {
        return this.getAndRecordParsedHost(null, hostName);
    }

    private ParsedHost getAndRecordParsedHost(String rackName, String hostName) {
        ParsedHost result = null;
        result = rackName == null ? ParsedHost.parse((String)hostName) : new ParsedHost(rackName, hostName);
        if (result != null) {
            ParsedHost canonicalResult = (ParsedHost)this.allHosts.get(result);
            if (canonicalResult != null) {
                return canonicalResult;
            }
            this.allHosts.put(result, result);
            return result;
        }
        return null;
    }

    private ArrayList<LoggedLocation> preferredLocationForSplits(String splits) {
        if (splits != null) {
            ArrayList<LoggedLocation> locations = null;
            StringTokenizer tok = new StringTokenizer(splits, ",", false);
            if (tok.countTokens() <= 25) {
                locations = new ArrayList<LoggedLocation>();
                while (tok.hasMoreTokens()) {
                    String nextSplit = tok.nextToken();
                    ParsedHost node = this.getAndRecordParsedHost(nextSplit);
                    if (locations == null || node == null) continue;
                    locations.add(node.makeLoggedLocation());
                }
                return locations;
            }
        }
        return null;
    }
}

