/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen.datatypes;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.tools.rumen.ParsedHost;
import org.apache.hadoop.tools.rumen.anonymization.WordList;
import org.apache.hadoop.tools.rumen.datatypes.AnonymizableDataType;
import org.apache.hadoop.tools.rumen.datatypes.NodeName;
import org.apache.hadoop.tools.rumen.state.State;
import org.apache.hadoop.tools.rumen.state.StatePool;

/*
 * Exception performing whole class analysis ignored.
 */
public class NodeName
implements AnonymizableDataType<String> {
    private String hostName;
    private String rackName;
    private String nodeName;
    private String anonymizedNodeName;
    public static final NodeName ROOT = new NodeName("<root>");

    public NodeName(String nodeName) {
        this.nodeName = nodeName;
        ParsedHost pHost = ParsedHost.parse((String)nodeName);
        if (pHost == null) {
            this.rackName = null;
            this.hostName = nodeName;
        } else {
            this.rackName = pHost.getRackName();
            this.hostName = pHost.getNodeName();
        }
    }

    public NodeName(String rName, String hName) {
        rName = rName == null || rName.length() == 0 ? null : rName;
        String string = hName = hName == null || hName.length() == 0 ? null : hName;
        if (hName == null) {
            this.nodeName = rName;
            this.rackName = rName;
        } else if (rName == null) {
            this.nodeName = hName;
            ParsedHost pHost = ParsedHost.parse((String)this.nodeName);
            if (pHost == null) {
                this.rackName = null;
                this.hostName = hName;
            } else {
                this.rackName = pHost.getRackName();
                this.hostName = pHost.getNodeName();
            }
        } else {
            this.rackName = rName;
            this.hostName = hName;
            this.nodeName = "/" + rName + "/" + hName;
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getRackName() {
        return this.rackName;
    }

    public String getValue() {
        return this.nodeName;
    }

    public String getAnonymizedValue(StatePool statePool, Configuration conf) {
        if (this.getValue().equals(ROOT.getValue())) {
            return this.getValue();
        }
        if (this.anonymizedNodeName == null) {
            this.anonymize(statePool);
        }
        return this.anonymizedNodeName;
    }

    private void anonymize(StatePool pool) {
        StringBuffer buf = new StringBuffer();
        NodeNameState state = (NodeNameState)pool.getState(this.getClass());
        if (state == null) {
            state = new NodeNameState();
            pool.addState(this.getClass(), (State)state);
        }
        if (this.rackName != null && this.hostName != null) {
            buf.append('/');
            buf.append(NodeName.anonymize((String)this.rackName, (WordList)state.getRackNameState()));
            buf.append('/');
            buf.append(NodeName.anonymize((String)this.hostName, (WordList)state.getHostNameState()));
        } else if (state.getRackNameState().contains(this.nodeName) || this.rackName != null) {
            buf.append(NodeName.anonymize((String)this.nodeName, (WordList)state.getRackNameState()));
        } else {
            buf.append(NodeName.anonymize((String)this.nodeName, (WordList)state.getHostNameState()));
        }
        this.anonymizedNodeName = buf.toString();
    }

    private static String anonymize(String data, WordList wordList) {
        if (data == null) {
            return null;
        }
        if (!wordList.contains(data)) {
            wordList.add(data);
        }
        return wordList.getName() + wordList.indexOf(data);
    }
}

