/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.jobhistory.JhCounter;
import org.apache.hadoop.mapreduce.jobhistory.JhCounterGroup;
import org.apache.hadoop.mapreduce.jobhistory.JhCounters;
import org.apache.hadoop.tools.rumen.DeepCompare;
import org.apache.hadoop.tools.rumen.DeepInequalityException;
import org.apache.hadoop.tools.rumen.LoggedLocation;
import org.apache.hadoop.tools.rumen.LoggedTask;
import org.apache.hadoop.tools.rumen.LoggedTaskAttempt;
import org.apache.hadoop.tools.rumen.Pre21JobHistoryConstants;
import org.apache.hadoop.tools.rumen.TreePath;
import org.codehaus.jackson.annotate.JsonAnySetter;

/*
 * Exception performing whole class analysis ignored.
 */
public class LoggedTask
implements DeepCompare {
    long inputBytes = -1L;
    long inputRecords = -1L;
    long outputBytes = -1L;
    long outputRecords = -1L;
    TaskID taskID;
    long startTime = -1L;
    long finishTime = -1L;
    Pre21JobHistoryConstants.Values taskType;
    Pre21JobHistoryConstants.Values taskStatus;
    List<LoggedTaskAttempt> attempts = new ArrayList();
    List<LoggedLocation> preferredLocations = Collections.emptyList();
    private static Set<String> alreadySeenAnySetterAttributes = new TreeSet();

    @JsonAnySetter
    public void setUnknownAttribute(String attributeName, Object ignored) {
        if (!alreadySeenAnySetterAttributes.contains(attributeName)) {
            alreadySeenAnySetterAttributes.add(attributeName);
            System.err.println("In LoggedJob, we saw the unknown attribute " + attributeName + ".");
        }
    }

    LoggedTask() {
    }

    void adjustTimes(long adjustment) {
        this.startTime += adjustment;
        this.finishTime += adjustment;
        for (LoggedTaskAttempt attempt : this.attempts) {
            attempt.adjustTimes(adjustment);
        }
    }

    public long getInputBytes() {
        return this.inputBytes;
    }

    void setInputBytes(long inputBytes) {
        this.inputBytes = inputBytes;
    }

    public long getInputRecords() {
        return this.inputRecords;
    }

    void setInputRecords(long inputRecords) {
        this.inputRecords = inputRecords;
    }

    public long getOutputBytes() {
        return this.outputBytes;
    }

    void setOutputBytes(long outputBytes) {
        this.outputBytes = outputBytes;
    }

    public long getOutputRecords() {
        return this.outputRecords;
    }

    void setOutputRecords(long outputRecords) {
        this.outputRecords = outputRecords;
    }

    public TaskID getTaskID() {
        return this.taskID;
    }

    void setTaskID(String taskID) {
        this.taskID = TaskID.forName((String)taskID);
    }

    public long getStartTime() {
        return this.startTime;
    }

    void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    void setFinishTime(long finishTime) {
        this.finishTime = finishTime;
    }

    public List<LoggedTaskAttempt> getAttempts() {
        return this.attempts;
    }

    void setAttempts(List<LoggedTaskAttempt> attempts) {
        this.attempts = attempts == null ? new ArrayList() : attempts;
    }

    public List<LoggedLocation> getPreferredLocations() {
        return this.preferredLocations;
    }

    void setPreferredLocations(List<LoggedLocation> preferredLocations) {
        this.preferredLocations = preferredLocations == null || preferredLocations.isEmpty() ? Collections.emptyList() : preferredLocations;
    }

    public Pre21JobHistoryConstants.Values getTaskStatus() {
        return this.taskStatus;
    }

    void setTaskStatus(Pre21JobHistoryConstants.Values taskStatus) {
        this.taskStatus = taskStatus;
    }

    public Pre21JobHistoryConstants.Values getTaskType() {
        return this.taskType;
    }

    void setTaskType(Pre21JobHistoryConstants.Values taskType) {
        this.taskType = taskType;
    }

    private void incorporateMapCounters(JhCounters counters) {
        LoggedTask.incorporateCounter((SetField)new /* Unavailable Anonymous Inner Class!! */, (JhCounters)counters, (String)"HDFS_BYTES_READ");
        LoggedTask.incorporateCounter((SetField)new /* Unavailable Anonymous Inner Class!! */, (JhCounters)counters, (String)"FILE_BYTES_WRITTEN");
        LoggedTask.incorporateCounter((SetField)new /* Unavailable Anonymous Inner Class!! */, (JhCounters)counters, (String)"MAP_INPUT_RECORDS");
        LoggedTask.incorporateCounter((SetField)new /* Unavailable Anonymous Inner Class!! */, (JhCounters)counters, (String)"MAP_OUTPUT_RECORDS");
    }

    private void incorporateReduceCounters(JhCounters counters) {
        LoggedTask.incorporateCounter((SetField)new /* Unavailable Anonymous Inner Class!! */, (JhCounters)counters, (String)"REDUCE_SHUFFLE_BYTES");
        LoggedTask.incorporateCounter((SetField)new /* Unavailable Anonymous Inner Class!! */, (JhCounters)counters, (String)"HDFS_BYTES_WRITTEN");
        LoggedTask.incorporateCounter((SetField)new /* Unavailable Anonymous Inner Class!! */, (JhCounters)counters, (String)"REDUCE_INPUT_RECORDS");
        LoggedTask.incorporateCounter((SetField)new /* Unavailable Anonymous Inner Class!! */, (JhCounters)counters, (String)"REDUCE_OUTPUT_RECORDS");
    }

    public void incorporateCounters(JhCounters counters) {
        switch (9.$SwitchMap$org$apache$hadoop$tools$rumen$Pre21JobHistoryConstants$Values[this.taskType.ordinal()]) {
            case 1: {
                this.incorporateMapCounters(counters);
                return;
            }
            case 2: {
                this.incorporateReduceCounters(counters);
                return;
            }
        }
    }

    private static String canonicalizeCounterName(String nonCanonicalName) {
        String result = nonCanonicalName.toLowerCase();
        result = result.replace(' ', '|');
        result = result.replace('-', '|');
        result = result.replace('_', '|');
        result = result.replace('.', '|');
        return result;
    }

    private static void incorporateCounter(SetField thunk, JhCounters counters, String counterName) {
        counterName = LoggedTask.canonicalizeCounterName((String)counterName);
        for (JhCounterGroup group : counters.groups) {
            for (JhCounter counter : group.counts) {
                if (!counterName.equals(LoggedTask.canonicalizeCounterName((String)((Object)counter.name).toString()))) continue;
                thunk.set(counter.value);
                return;
            }
        }
    }

    private void compare1(long c1, long c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 != c2) {
            throw new DeepInequalityException(eltname + " miscompared", new TreePath(loc, eltname));
        }
    }

    private void compare1(String c1, String c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 == null && c2 == null) {
            return;
        }
        if (c1 == null || c2 == null || !c1.equals(c2)) {
            throw new DeepInequalityException(eltname + " miscompared", new TreePath(loc, eltname));
        }
    }

    private void compare1(Pre21JobHistoryConstants.Values c1, Pre21JobHistoryConstants.Values c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 == null && c2 == null) {
            return;
        }
        if (c1 == null || c2 == null || !c1.equals((Object)c2)) {
            throw new DeepInequalityException(eltname + " miscompared", new TreePath(loc, eltname));
        }
    }

    private void compareLoggedLocations(List<LoggedLocation> c1, List<LoggedLocation> c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 == null && c2 == null) {
            return;
        }
        if (c1 == null || c2 == null || c1.size() != c2.size()) {
            throw new DeepInequalityException(eltname + " miscompared", new TreePath(loc, eltname));
        }
        for (int i = 0; i < c1.size(); ++i) {
            c1.get(i).deepCompare((DeepCompare)c2.get(i), new TreePath(loc, eltname, i));
        }
    }

    private void compareLoggedTaskAttempts(List<LoggedTaskAttempt> c1, List<LoggedTaskAttempt> c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 == null && c2 == null) {
            return;
        }
        if (c1 == null || c2 == null || c1.size() != c2.size()) {
            throw new DeepInequalityException(eltname + " miscompared", new TreePath(loc, eltname));
        }
        for (int i = 0; i < c1.size(); ++i) {
            c1.get(i).deepCompare((DeepCompare)c2.get(i), new TreePath(loc, eltname, i));
        }
    }

    public void deepCompare(DeepCompare comparand, TreePath loc) throws DeepInequalityException {
        if (!(comparand instanceof LoggedTask)) {
            throw new DeepInequalityException("comparand has wrong type", loc);
        }
        LoggedTask other = (LoggedTask)comparand;
        this.compare1(this.inputBytes, other.inputBytes, loc, "inputBytes");
        this.compare1(this.inputRecords, other.inputRecords, loc, "inputRecords");
        this.compare1(this.outputBytes, other.outputBytes, loc, "outputBytes");
        this.compare1(this.outputRecords, other.outputRecords, loc, "outputRecords");
        this.compare1(this.taskID.toString(), other.taskID.toString(), loc, "taskID");
        this.compare1(this.startTime, other.startTime, loc, "startTime");
        this.compare1(this.finishTime, other.finishTime, loc, "finishTime");
        this.compare1(this.taskType, other.taskType, loc, "taskType");
        this.compare1(this.taskStatus, other.taskStatus, loc, "taskStatus");
        this.compareLoggedTaskAttempts(this.attempts, other.attempts, loc, "attempts");
        this.compareLoggedLocations(this.preferredLocations, other.preferredLocations, loc, "preferredLocations");
    }
}

