/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen.state;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.rumen.state.State;
import org.apache.hadoop.tools.rumen.state.StateDeserializer;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.module.SimpleModule;

public class StatePool {
    private static final long VERSION = 1L;
    private boolean isUpdated = false;
    private boolean isInitialized = false;
    private Configuration conf;
    public static final String DIR_CONFIG = "rumen.anonymization.states.dir";
    public static final String RELOAD_CONFIG = "rumen.anonymization.states.reload";
    public static final String PERSIST_CONFIG = "rumen.anonymization.states.persist";
    private static final String COMMIT_STATE_FILENAME = "latest";
    private static final String CURRENT_STATE_FILENAME = "temp";
    private String timeStamp;
    private Path persistDirPath;
    private boolean reload;
    private boolean persist;
    private HashMap<String, StatePair> pool = new HashMap();

    public void addState(Class id, State state) {
        if (this.pool.containsKey(id.getName())) {
            throw new RuntimeException("State '" + state.getName() + "' added for the" + " class " + id.getName() + " already exists!");
        }
        this.isUpdated = true;
        this.pool.put(id.getName(), new StatePair(state));
    }

    public State getState(Class clazz) {
        return this.pool.containsKey(clazz.getName()) ? this.pool.get(clazz.getName()).getState() : null;
    }

    @JsonIgnore
    public boolean isUpdated() {
        if (!this.isUpdated) {
            for (StatePair statePair : this.pool.values()) {
                if (!statePair.getState().isUpdated()) continue;
                this.isUpdated = true;
                return true;
            }
        }
        return this.isUpdated;
    }

    public void initialize(Configuration conf) throws Exception {
        if (this.isInitialized) {
            throw new RuntimeException("StatePool is already initialized!");
        }
        this.conf = conf;
        String persistDir = conf.get(DIR_CONFIG);
        this.reload = conf.getBoolean(RELOAD_CONFIG, false);
        this.persist = conf.getBoolean(PERSIST_CONFIG, false);
        if (this.reload || this.persist) {
            System.out.println("State Manager initializing. State directory : " + persistDir);
            System.out.println("Reload:" + this.reload + " Persist:" + this.persist);
            if (persistDir == null) {
                throw new RuntimeException("No state persist directory configured! Disable persistence.");
            }
            this.persistDirPath = new Path(persistDir);
        } else {
            System.out.println("State Manager disabled.");
        }
        this.reload();
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy-hh'H'-mm'M'-ss'S'");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        this.timeStamp = formatter.format(calendar.getTime());
        this.isInitialized = true;
    }

    private void reload() throws Exception {
        if (this.reload) {
            Path stateFilename = new Path(this.persistDirPath, COMMIT_STATE_FILENAME);
            FileSystem fs = stateFilename.getFileSystem(this.conf);
            if (fs.exists(stateFilename)) {
                this.reloadState(stateFilename, this.conf);
            } else {
                throw new RuntimeException("No latest state persist directory found! Disable persistence and run.");
            }
        }
    }

    private void reloadState(Path stateFile, Configuration conf) throws Exception {
        FileSystem fs = stateFile.getFileSystem(conf);
        if (fs.exists(stateFile)) {
            System.out.println("Reading state from " + stateFile.toString());
            FSDataInputStream in = fs.open(stateFile);
            this.read((DataInput)in);
            in.close();
        } else {
            System.out.println("No state information found for " + stateFile);
        }
    }

    private void read(DataInput in) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS, true);
        SimpleModule module = new SimpleModule("State Serializer", new Version(0, 1, 1, "FINAL"));
        module.addDeserializer(StatePair.class, (JsonDeserializer)new StateDeserializer());
        mapper.registerModule((Module)module);
        JsonParser parser = mapper.getJsonFactory().createJsonParser((InputStream)((DataInputStream)in));
        StatePool statePool = (StatePool)mapper.readValue(parser, StatePool.class);
        this.setStates(statePool.getStates());
        parser.close();
    }

    public void persist() throws IOException {
        if (!this.persist) {
            return;
        }
        if (this.isUpdated()) {
            System.out.println("State is updated! Committing.");
            Path currStateFile = new Path(this.persistDirPath, CURRENT_STATE_FILENAME);
            Path commitStateFile = new Path(this.persistDirPath, COMMIT_STATE_FILENAME);
            FileSystem fs = currStateFile.getFileSystem(this.conf);
            System.out.println("Starting the persist phase. Persisting to " + currStateFile.toString());
            FSDataOutputStream out = fs.create(currStateFile, true);
            this.write((DataOutput)out);
            out.close();
            System.out.println("Persist phase over. The best known un-committed state is located at " + currStateFile.toString());
            if (fs.exists(commitStateFile)) {
                Path commitRelocationFile = new Path(this.persistDirPath, this.timeStamp);
                System.out.println("Starting the pre-commit phase. Moving the previous best known state to " + commitRelocationFile.toString());
                FileUtil.copy((FileSystem)fs, (Path)commitStateFile, (FileSystem)fs, (Path)commitRelocationFile, (boolean)false, (Configuration)this.conf);
            }
            System.out.println("Starting the commit phase. Committing the states in " + currStateFile.toString());
            FileUtil.copy((FileSystem)fs, (Path)currStateFile, (FileSystem)fs, (Path)commitStateFile, (boolean)true, (boolean)true, (Configuration)this.conf);
            System.out.println("Commit phase successful! The best known committed state is located at " + commitStateFile.toString());
        } else {
            System.out.println("State not updated! No commit required.");
        }
    }

    private void write(DataOutput out) throws IOException {
        System.out.println("Dumping the StatePool's in JSON format.");
        ObjectMapper outMapper = new ObjectMapper();
        outMapper.configure(SerializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS, true);
        SimpleModule module = new SimpleModule("State Serializer", new Version(0, 1, 1, "FINAL"));
        outMapper.registerModule((Module)module);
        JsonFactory outFactory = outMapper.getJsonFactory();
        JsonGenerator jGen = outFactory.createJsonGenerator((OutputStream)((DataOutputStream)out), JsonEncoding.UTF8);
        jGen.useDefaultPrettyPrinter();
        jGen.writeObject((Object)this);
        jGen.close();
    }

    public long getVersion() {
        return 1L;
    }

    public void setVersion(long version) {
        if (version != 1L) {
            throw new RuntimeException("Version mismatch! Expected 1 got " + version);
        }
    }

    public HashMap<String, StatePair> getStates() {
        return this.pool;
    }

    public void setStates(HashMap<String, StatePair> states) {
        if (this.pool.size() > 0) {
            throw new RuntimeException("Pool not empty!");
        }
        this.pool = states;
    }

    public static class StatePair {
        private String className;
        private State state;

        public StatePair(State state) {
            this.className = state.getClass().getName();
            this.state = state;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public State getState() {
            return this.state;
        }

        public void setState(State state) {
            this.state = state;
        }
    }
}

