/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.tools.rumen.HistoryEventEmitter;
import org.apache.hadoop.tools.rumen.Job20LineHistoryEventEmitter;
import org.apache.hadoop.tools.rumen.JobHistoryParser;
import org.apache.hadoop.tools.rumen.LogRecordType;
import org.apache.hadoop.tools.rumen.MapAttempt20LineHistoryEventEmitter;
import org.apache.hadoop.tools.rumen.Pair;
import org.apache.hadoop.tools.rumen.ParsedLine;
import org.apache.hadoop.tools.rumen.ReduceAttempt20LineHistoryEventEmitter;
import org.apache.hadoop.tools.rumen.Task20LineHistoryEventEmitter;
import org.apache.hadoop.util.LineReader;

public class Hadoop20JHParser
implements JobHistoryParser {
    final LineReader reader;
    static final String endLineString = " .";
    static final int internalVersion = 1;
    Map<String, HistoryEventEmitter> liveEmitters = new HashMap<String, HistoryEventEmitter>();
    Queue<HistoryEvent> remainingEvents = new LinkedList<HistoryEvent>();

    public static boolean canParse(InputStream input) throws IOException {
        try {
            LineReader reader = new LineReader(input);
            Text buffer = new Text();
            return reader.readLine(buffer) != 0 && buffer.toString().equals("Meta VERSION=\"1\" .");
        }
        catch (EOFException e) {
            return false;
        }
    }

    public Hadoop20JHParser(InputStream input) throws IOException {
        this.reader = new LineReader(input);
    }

    public Hadoop20JHParser(LineReader reader) throws IOException {
        this.reader = reader;
    }

    @Override
    public HistoryEvent nextEvent() {
        try {
            while (this.remainingEvents.isEmpty()) {
                ParsedLine line = new ParsedLine(this.getFullLine(), 1);
                LineType type = LineType.findLineType(line.getType());
                if (type == null) continue;
                String name = type.getName(line);
                HistoryEventEmitter emitter = this.findOrMakeEmitter(name, type);
                Pair<Queue<HistoryEvent>, HistoryEventEmitter.PostEmitAction> pair = emitter.emitterCore(line, name);
                if (pair.second() == HistoryEventEmitter.PostEmitAction.REMOVE_HEE) {
                    this.liveEmitters.remove(name);
                }
                this.remainingEvents = pair.first();
            }
            return this.remainingEvents.poll();
        }
        catch (EOFException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    HistoryEventEmitter findOrMakeEmitter(String name, LineType type) {
        HistoryEventEmitter result = this.liveEmitters.get(name);
        if (result == null) {
            result = type.createEmitter();
            this.liveEmitters.put(name, result);
        }
        return result;
    }

    private String getOneLine() throws IOException {
        Text resultText = new Text();
        if (this.reader.readLine(resultText) == 0) {
            throw new EOFException("apparent bad line");
        }
        return resultText.toString();
    }

    private String getFullLine() throws IOException {
        String addedLine;
        String line = this.getOneLine();
        while (line.length() < endLineString.length()) {
            line = this.getOneLine();
        }
        if (line.endsWith(endLineString)) {
            return line;
        }
        StringBuilder sb = new StringBuilder(line);
        do {
            if ((addedLine = this.getOneLine()) == null) {
                return sb.toString();
            }
            sb.append("\n");
            sb.append(addedLine);
        } while (addedLine.length() < endLineString.length() || !endLineString.equals(addedLine.substring(addedLine.length() - endLineString.length())));
        return sb.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    static enum LineType {
        JOB("Job", "JOBID"){

            @Override
            HistoryEventEmitter createEmitter() {
                return new Job20LineHistoryEventEmitter();
            }
        }
        ,
        TASK("Task", "TASKID"){

            @Override
            HistoryEventEmitter createEmitter() {
                return new Task20LineHistoryEventEmitter();
            }
        }
        ,
        MAP_ATTEMPT("MapAttempt", "TASK_ATTEMPT_ID"){

            @Override
            HistoryEventEmitter createEmitter() {
                return new MapAttempt20LineHistoryEventEmitter();
            }
        }
        ,
        REDUCE_ATTEMPT("ReduceAttempt", "TASK_ATTEMPT_ID"){

            @Override
            HistoryEventEmitter createEmitter() {
                return new ReduceAttempt20LineHistoryEventEmitter();
            }
        };

        private LogRecordType type;
        private String name;

        private LineType(String s, String name) {
            this.type = LogRecordType.intern(s);
            this.name = name;
        }

        LogRecordType recordType() {
            return this.type;
        }

        String getName(ParsedLine line) {
            return line.get(this.name);
        }

        abstract HistoryEventEmitter createEmitter();

        static LineType findLineType(LogRecordType lrt) {
            for (LineType lt : LineType.values()) {
                if (lt.type != lrt) continue;
                return lt;
            }
            return null;
        }
    }
}

