/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.mapreduce.ID;
import org.apache.hadoop.tools.rumen.datatypes.DataType;
import org.apache.hadoop.tools.rumen.serializers.DefaultRumenSerializer;
import org.apache.hadoop.tools.rumen.serializers.ObjectStringSerializer;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.module.SimpleModule;

public class JsonObjectMapperWriter<T>
implements Closeable {
    private JsonGenerator writer;

    public JsonObjectMapperWriter(OutputStream output, boolean prettyPrint) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS, true);
        SimpleModule module = new SimpleModule("Default Serializer", new Version(0, 1, 1, "FINAL"));
        module.addSerializer(DataType.class, (JsonSerializer)new DefaultRumenSerializer());
        module.addSerializer(ID.class, new ObjectStringSerializer());
        mapper.registerModule((Module)module);
        this.writer = mapper.getJsonFactory().createJsonGenerator(output, JsonEncoding.UTF8);
        if (prettyPrint) {
            this.writer.useDefaultPrettyPrinter();
        }
    }

    public void write(T object) throws IOException {
        this.writer.writeObject(object);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

