/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.MapAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.ReduceAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskStartedEvent;
import org.apache.hadoop.tools.rumen.LoggedNetworkTopology;
import org.apache.hadoop.tools.rumen.ParsedHost;

public class TopologyBuilder {
    private Set<ParsedHost> allHosts = new HashSet();

    public void process(HistoryEvent event) {
        if (event instanceof TaskAttemptFinishedEvent) {
            this.processTaskAttemptFinishedEvent((TaskAttemptFinishedEvent)event);
        } else if (event instanceof TaskAttemptUnsuccessfulCompletionEvent) {
            this.processTaskAttemptUnsuccessfulCompletionEvent((TaskAttemptUnsuccessfulCompletionEvent)event);
        } else if (event instanceof TaskStartedEvent) {
            this.processTaskStartedEvent((TaskStartedEvent)event);
        } else if (event instanceof MapAttemptFinishedEvent) {
            this.processMapAttemptFinishedEvent((MapAttemptFinishedEvent)event);
        } else if (event instanceof ReduceAttemptFinishedEvent) {
            this.processReduceAttemptFinishedEvent((ReduceAttemptFinishedEvent)event);
        }
    }

    public void process(Properties conf) {
    }

    public LoggedNetworkTopology build() {
        return new LoggedNetworkTopology(this.allHosts);
    }

    private void processTaskStartedEvent(TaskStartedEvent event) {
        this.preferredLocationForSplits(event.getSplitLocations());
    }

    private void processTaskAttemptUnsuccessfulCompletionEvent(TaskAttemptUnsuccessfulCompletionEvent event) {
        this.recordParsedHost(event.getHostname(), event.getRackName());
    }

    private void processTaskAttemptFinishedEvent(TaskAttemptFinishedEvent event) {
        this.recordParsedHost(event.getHostname(), event.getRackName());
    }

    private void processMapAttemptFinishedEvent(MapAttemptFinishedEvent event) {
        this.recordParsedHost(event.getHostname(), event.getRackName());
    }

    private void processReduceAttemptFinishedEvent(ReduceAttemptFinishedEvent event) {
        this.recordParsedHost(event.getHostname(), event.getRackName());
    }

    private void recordParsedHost(String hostName, String rackName) {
        if (hostName == null) {
            return;
        }
        ParsedHost result = null;
        result = rackName == null ? ParsedHost.parse((String)hostName) : new ParsedHost(rackName, hostName);
        if (result != null && !this.allHosts.contains(result)) {
            this.allHosts.add(result);
        }
    }

    private void recordParsedHost(String nodeName) {
        ParsedHost result = ParsedHost.parse((String)nodeName);
        if (result != null && !this.allHosts.contains(result)) {
            this.allHosts.add(result);
        }
    }

    private void preferredLocationForSplits(String splits) {
        if (splits != null) {
            StringTokenizer tok = new StringTokenizer(splits, ",", false);
            while (tok.hasMoreTokens()) {
                String nextSplit = tok.nextToken();
                this.recordParsedHost(nextSplit);
            }
        }
    }
}

