/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.rumen.ClusterStory;
import org.apache.hadoop.tools.rumen.JobStoryProducer;
import org.apache.hadoop.tools.rumen.JobTraceReader;
import org.apache.hadoop.tools.rumen.LoggedJob;
import org.apache.hadoop.tools.rumen.RandomSeedGenerator;
import org.apache.hadoop.tools.rumen.ZombieCluster;
import org.apache.hadoop.tools.rumen.ZombieJob;

public class ZombieJobProducer
implements JobStoryProducer {
    private final JobTraceReader reader;
    private final ZombieCluster cluster;
    private boolean hasRandomSeed = false;
    private long randomSeed = 0L;

    private ZombieJobProducer(JobTraceReader reader, ZombieCluster cluster, boolean hasRandomSeed, long randomSeed) {
        this.reader = reader;
        this.cluster = cluster;
        this.hasRandomSeed = hasRandomSeed;
        this.randomSeed = hasRandomSeed ? randomSeed : System.nanoTime();
    }

    public ZombieJobProducer(Path path, ZombieCluster cluster, Configuration conf) throws IOException {
        this(new JobTraceReader(path, conf), cluster, false, -1L);
    }

    public ZombieJobProducer(Path path, ZombieCluster cluster, Configuration conf, long randomSeed) throws IOException {
        this(new JobTraceReader(path, conf), cluster, true, randomSeed);
    }

    public ZombieJobProducer(InputStream input, ZombieCluster cluster) throws IOException {
        this(new JobTraceReader(input), cluster, false, -1L);
    }

    public ZombieJobProducer(InputStream input, ZombieCluster cluster, long randomSeed) throws IOException {
        this(new JobTraceReader(input), cluster, true, randomSeed);
    }

    public ZombieJob getNextJob() throws IOException {
        LoggedJob job = (LoggedJob)this.reader.getNext();
        if (job == null) {
            return null;
        }
        if (this.hasRandomSeed) {
            long subRandomSeed = RandomSeedGenerator.getSeed((String)("forZombieJob" + job.getJobID()), (long)this.randomSeed);
            return new ZombieJob(job, (ClusterStory)this.cluster, subRandomSeed);
        }
        return new ZombieJob(job, (ClusterStory)this.cluster);
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

