/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen.datatypes;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.tools.rumen.anonymization.WordList;
import org.apache.hadoop.tools.rumen.anonymization.WordListAnonymizerUtility;
import org.apache.hadoop.tools.rumen.datatypes.AnonymizableDataType;
import org.apache.hadoop.tools.rumen.datatypes.FileName;
import org.apache.hadoop.tools.rumen.datatypes.NodeName;
import org.apache.hadoop.tools.rumen.state.State;
import org.apache.hadoop.tools.rumen.state.StatePool;
import org.apache.hadoop.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileName
implements AnonymizableDataType<String> {
    private final String fileName;
    private String anonymizedFileName;
    private static final String PREV_DIR = "..";
    private static final String[] KNOWN_SUFFIXES = new String[]{".xml", ".jar", ".txt", ".tar", ".zip", ".json", ".gzip", ".lzo"};

    public FileName(String fileName) {
        this.fileName = fileName;
    }

    public String getValue() {
        return this.fileName;
    }

    public String getAnonymizedValue(StatePool statePool, Configuration conf) {
        if (this.anonymizedFileName == null) {
            this.anonymize(statePool, conf);
        }
        return this.anonymizedFileName;
    }

    private void anonymize(StatePool statePool, Configuration conf) {
        FileNameState fState = (FileNameState)statePool.getState(this.getClass());
        if (fState == null) {
            fState = new FileNameState();
            statePool.addState(this.getClass(), (State)fState);
        }
        String[] files = StringUtils.split((String)this.fileName);
        String[] anonymizedFileNames = new String[files.length];
        int i = 0;
        for (String f : files) {
            anonymizedFileNames[i++] = FileName.anonymize((StatePool)statePool, (Configuration)conf, (FileNameState)fState, (String)f);
        }
        this.anonymizedFileName = StringUtils.arrayToString((String[])anonymizedFileNames);
    }

    private static String anonymize(StatePool statePool, Configuration conf, FileNameState fState, String fileName) {
        String ret = null;
        try {
            URI uri = new URI(fileName);
            ret = FileName.anonymizePath((String)uri.getPath(), (WordList)fState.getDirectoryState(), (WordList)fState.getFileNameState());
            String authority = uri.getAuthority();
            String scheme = uri.getScheme();
            if (scheme != null) {
                String anonymizedAuthority = "";
                if (authority != null) {
                    NodeName hostName = new NodeName(null, uri.getHost());
                    anonymizedAuthority = hostName.getAnonymizedValue(statePool, conf);
                }
                ret = scheme + "://" + anonymizedAuthority + ret;
            }
        }
        catch (URISyntaxException use) {
            throw new RuntimeException(use);
        }
        return ret;
    }

    private static String anonymizePath(String path, WordList dState, WordList fState) {
        StringBuilder buffer = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(path, "/", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if ("/".equals(token)) {
                buffer.append(token);
                continue;
            }
            if (".".equals(token)) {
                buffer.append(token);
                continue;
            }
            if ("..".equals(token)) {
                buffer.append(token);
                continue;
            }
            if (tokenizer.hasMoreTokens()) {
                buffer.append(FileName.anonymize((String)token, (WordList)dState));
                continue;
            }
            buffer.append(FileName.anonymize((String)token, (WordList)fState));
        }
        return buffer.toString();
    }

    private static String anonymize(String data, WordList wordList) {
        if (data == null) {
            return null;
        }
        if (WordListAnonymizerUtility.needsAnonymization((String)data)) {
            String suffix = "";
            String coreData = data;
            if (WordListAnonymizerUtility.hasSuffix((String)data, (String[])KNOWN_SUFFIXES)) {
                String[] split = WordListAnonymizerUtility.extractSuffix((String)data, (String[])KNOWN_SUFFIXES);
                suffix = split[1];
                coreData = split[0];
            }
            String anonymizedData = coreData;
            if (!WordListAnonymizerUtility.isKnownData((String)coreData)) {
                if (!wordList.contains(coreData)) {
                    wordList.add(coreData);
                }
                anonymizedData = wordList.getName() + wordList.indexOf(coreData);
            }
            return anonymizedData + suffix;
        }
        return data;
    }
}

