/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.tools.rumen.DefaultOutputter;
import org.apache.hadoop.tools.rumen.Histogram;
import org.apache.hadoop.tools.rumen.LogRecordType;
import org.apache.hadoop.tools.rumen.LoggedDiscreteCDF;
import org.apache.hadoop.tools.rumen.LoggedJob;
import org.apache.hadoop.tools.rumen.LoggedLocation;
import org.apache.hadoop.tools.rumen.LoggedNetworkTopology;
import org.apache.hadoop.tools.rumen.LoggedTask;
import org.apache.hadoop.tools.rumen.LoggedTaskAttempt;
import org.apache.hadoop.tools.rumen.Outputter;
import org.apache.hadoop.tools.rumen.Pair;
import org.apache.hadoop.tools.rumen.ParsedConfigFile;
import org.apache.hadoop.tools.rumen.ParsedHost;
import org.apache.hadoop.tools.rumen.ParsedLine;
import org.apache.hadoop.tools.rumen.Pre21JobHistoryConstants;
import org.apache.hadoop.util.LineReader;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@Deprecated
public class HadoopLogsAnalyzer
extends Configured
implements Tool {
    private PrintStream statusOutput = System.out;
    private PrintStream statisticalOutput = System.out;
    private static PrintStream staticDebugOutput = System.err;
    private static final int MAXIMUM_PREFERRED_LOCATIONS = 25;
    private static final long SMALL_SPREAD_COMPENSATION_THRESHOLD = 5L;
    private static final long MAXIMUM_CLOCK_SKEW = 10000L;
    private static final Pattern taskAttemptIDPattern = Pattern.compile(".*_([0-9]+)");
    private static final Pattern xmlFilePrefix = Pattern.compile("[ \t]*<");
    private static final Pattern confFileHeader = Pattern.compile("_conf.xml!!");
    private final Map<String, Pattern> counterPatterns = new HashMap<String, Pattern>();
    private ParsedConfigFile jobconf = null;
    private boolean omitTaskDetails = false;
    private Outputter<LoggedJob> jobTraceGen = null;
    private boolean prettyprintTrace = true;
    private LoggedJob jobBeingTraced = null;
    private Map<String, LoggedTask> tasksInCurrentJob;
    private Map<String, LoggedTaskAttempt> attemptsInCurrentJob;
    private Histogram[] successfulMapAttemptTimes;
    private Histogram successfulReduceAttemptTimes;
    private Histogram[] failedMapAttemptTimes;
    private Histogram failedReduceAttemptTimes;
    private Histogram successfulNthMapperAttempts;
    private Histogram successfulNthReducerAttempts;
    private Histogram mapperLocality;
    private static final Log LOG = LogFactory.getLog(HadoopLogsAnalyzer.class);
    private int[] attemptTimesPercentiles;
    private Outputter<LoggedNetworkTopology> topologyGen = null;
    private HashSet<ParsedHost> allHosts = new HashSet();
    private boolean collecting = false;
    private long lineNumber = 0L;
    private String rereadableLine = null;
    private String inputFilename;
    private boolean inputIsDirectory = false;
    private Path inputDirectoryPath = null;
    private String[] inputDirectoryFiles = null;
    private int inputDirectoryCursor = -1;
    private LineReader input = null;
    private CompressionCodec inputCodec = null;
    private Decompressor inputDecompressor = null;
    private Text inputLineText = new Text();
    private boolean debug = false;
    private int version = 0;
    private int numberBuckets = 99;
    private int spreadMin;
    private int spreadMax;
    private boolean spreading = false;
    private boolean delays = false;
    private boolean runtimes = false;
    private boolean collectTaskTimes = false;
    private LogRecordType canonicalJob = LogRecordType.intern("Job");
    private LogRecordType canonicalMapAttempt = LogRecordType.intern("MapAttempt");
    private LogRecordType canonicalReduceAttempt = LogRecordType.intern("ReduceAttempt");
    private LogRecordType canonicalTask = LogRecordType.intern("Task");
    private static Pattern streamingJobnamePattern = Pattern.compile("streamjob\\d+.jar");
    private HashSet<String> hostNames = new HashSet();
    private boolean fileFirstLine = true;
    private String currentFileName = null;
    private Histogram[][] runTimeDists;
    private Histogram[][] delayTimeDists;
    private Histogram[][] mapTimeSpreadDists;
    private Histogram[][] shuffleTimeSpreadDists;
    private Histogram[][] sortTimeSpreadDists;
    private Histogram[][] reduceTimeSpreadDists;
    private Histogram[][] mapTimeDists;
    private Histogram[][] shuffleTimeDists;
    private Histogram[][] sortTimeDists;
    private Histogram[][] reduceTimeDists;
    private Map<String, Long> taskAttemptStartTimes;
    private Map<String, Long> taskReduceAttemptShuffleEndTimes;
    private Map<String, Long> taskReduceAttemptSortEndTimes;
    private Map<String, Long> taskMapAttemptFinishTimes;
    private Map<String, Long> taskReduceAttemptFinishTimes;
    private long submitTimeCurrentJob;
    private long launchTimeCurrentJob;
    private String currentJobID;
    private LoggedJob.JobType thisJobType;

    private Histogram[][] newDistributionBlock() {
        return this.newDistributionBlock(null);
    }

    private Histogram[][] newDistributionBlock(String blockname) {
        Histogram[][] result = new Histogram[JobOutcome.values().length][];
        for (int i = 0; i < JobOutcome.values().length; ++i) {
            result[i] = new Histogram[LoggedJob.JobType.values().length];
            for (int j = 0; j < LoggedJob.JobType.values().length; ++j) {
                result[i][j] = blockname == null ? new Histogram() : new Histogram(blockname);
            }
        }
        return result;
    }

    private Histogram getDistribution(Histogram[][] block, JobOutcome outcome, LoggedJob.JobType type) {
        return block[outcome.ordinal()][type.ordinal()];
    }

    private void usage() {
        this.statusOutput.print("Usage: \nadministrative subcommands:\n-v1                  specify version 1 of the jt logs\n-h or -help          print this message\n-d or -debug         print voluminous debug info during processing\n-collect-prefixes    collect the prefixes of log lines\n\n  job trace subcommands\n-write-job-trace     takes a filename.\n                     writes job trace in JSON to that filename\n-single-line-job-traces  omit prettyprinting of job trace\n-omit-task-details   leave out info about each task and attempt,\n                     so only statistical info is added to each job\n-write-topology      takes a filename.\n                     writes JSON file giving network topology\n-job-digest-spectra  takes a list of percentile points\n                     writes CDFs with min, max, and those percentiles\n\nsubcommands for task statistical info\n-spreads             we have a mode where, for each job, we can\n                     develop the ratio of percentile B to percentile A\n                     of task run times.  Having developed that ratio,\n                     we can consider it to be a datum and we can\n                     build a CDF of those ratios.  -spreads turns\n                     this option on, and takes A and B\n-delays              tells us to gather and print CDFs for delays\n                     from job submit to job start\n-runtimes            prints CDFs of job wallclock times [launch\n                     to finish]\n-tasktimes           prints CDFs of job wallclock times [launch\n                     to finish]\n\n");
    }

    private boolean pathIsDirectory(Path p) throws IOException {
        FileSystem fs = p.getFileSystem(this.getConf());
        return fs.getFileStatus(p).isDirectory();
    }

    private int initializeHadoopLogsAnalyzer(String[] args) throws FileNotFoundException, IOException {
        Path jobTraceFilename = null;
        Path topologyFilename = null;
        if (args.length == 0 || args[args.length - 1].charAt(0) == '-') {
            throw new IllegalArgumentException("No input specified.");
        }
        this.inputFilename = args[args.length - 1];
        for (int i = 0; i < args.length - (this.inputFilename == null ? 0 : 1); ++i) {
            if (StringUtils.equalsIgnoreCase((String)"-h", (String)args[i]) || StringUtils.equalsIgnoreCase((String)"-help", (String)args[i])) {
                this.usage();
                return 0;
            }
            if (StringUtils.equalsIgnoreCase((String)"-c", (String)args[i]) || StringUtils.equalsIgnoreCase((String)"-collect-prefixes", (String)args[i])) {
                this.collecting = true;
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"-write-job-trace", (String)args[i])) {
                jobTraceFilename = new Path(args[++i]);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"-single-line-job-traces", (String)args[i])) {
                this.prettyprintTrace = false;
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"-omit-task-details", (String)args[i])) {
                this.omitTaskDetails = true;
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"-write-topology", (String)args[i])) {
                topologyFilename = new Path(args[++i]);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"-job-digest-spectra", (String)args[i])) {
                ArrayList<Integer> values = new ArrayList<Integer>();
                ++i;
                while (i < args.length && Character.isDigit(args[i].charAt(0))) {
                    values.add(Integer.parseInt(args[i]));
                    ++i;
                }
                if (values.size() == 0) {
                    throw new IllegalArgumentException("Empty -job-digest-spectra list");
                }
                this.attemptTimesPercentiles = new int[values.size()];
                int lastValue = 0;
                for (int j = 0; j < this.attemptTimesPercentiles.length; ++j) {
                    if ((Integer)values.get(j) <= lastValue || (Integer)values.get(j) >= 100) {
                        throw new IllegalArgumentException("Bad -job-digest-spectra percentiles list");
                    }
                    this.attemptTimesPercentiles[j] = (Integer)values.get(j);
                }
                --i;
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"-d", (String)args[i]) || StringUtils.equalsIgnoreCase((String)"-debug", (String)args[i])) {
                this.debug = true;
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"-spreads", (String)args[i])) {
                int max;
                int min = Integer.parseInt(args[i + 1]);
                if (min >= (max = Integer.parseInt(args[i + 2])) || min >= 1000 || max >= 1000) continue;
                this.spreadMin = min;
                this.spreadMax = max;
                this.spreading = true;
                i += 2;
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"-delays", (String)args[i])) {
                this.delays = true;
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"-runtimes", (String)args[i])) {
                this.runtimes = true;
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"-tasktimes", (String)args[i])) {
                this.collectTaskTimes = true;
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"-v1", (String)args[i])) {
                this.version = 1;
                continue;
            }
            throw new IllegalArgumentException("Unrecognized argument: " + args[i]);
        }
        this.runTimeDists = this.newDistributionBlock();
        this.delayTimeDists = this.newDistributionBlock();
        this.mapTimeSpreadDists = this.newDistributionBlock("map-time-spreads");
        this.shuffleTimeSpreadDists = this.newDistributionBlock();
        this.sortTimeSpreadDists = this.newDistributionBlock();
        this.reduceTimeSpreadDists = this.newDistributionBlock();
        this.mapTimeDists = this.newDistributionBlock();
        this.shuffleTimeDists = this.newDistributionBlock();
        this.sortTimeDists = this.newDistributionBlock();
        this.reduceTimeDists = this.newDistributionBlock();
        this.taskAttemptStartTimes = new HashMap<String, Long>();
        this.taskReduceAttemptShuffleEndTimes = new HashMap<String, Long>();
        this.taskReduceAttemptSortEndTimes = new HashMap<String, Long>();
        this.taskMapAttemptFinishTimes = new HashMap<String, Long>();
        this.taskReduceAttemptFinishTimes = new HashMap<String, Long>();
        Path inputPath = new Path(this.inputFilename);
        this.inputIsDirectory = this.pathIsDirectory(inputPath);
        if (jobTraceFilename != null && this.attemptTimesPercentiles == null) {
            this.attemptTimesPercentiles = new int[19];
            for (int i = 0; i < 19; ++i) {
                this.attemptTimesPercentiles[i] = (i + 1) * 5;
            }
        }
        if (!this.inputIsDirectory) {
            this.input = this.maybeUncompressedPath(inputPath);
        } else {
            this.inputDirectoryPath = inputPath;
            FileSystem fs = inputPath.getFileSystem(this.getConf());
            FileStatus[] statuses = fs.listStatus(inputPath);
            this.inputDirectoryFiles = new String[statuses.length];
            for (int i = 0; i < statuses.length; ++i) {
                this.inputDirectoryFiles[i] = statuses[i].getPath().getName();
            }
            int dropPoint = 0;
            for (int i = 0; i < this.inputDirectoryFiles.length; ++i) {
                String name = this.inputDirectoryFiles[i];
                if (name.length() >= 4 && ".crc".equals(name.substring(name.length() - 4))) continue;
                this.inputDirectoryFiles[dropPoint++] = name;
            }
            LOG.info((Object)("We dropped " + (this.inputDirectoryFiles.length - dropPoint) + " crc files."));
            String[] new_inputDirectoryFiles = new String[dropPoint];
            System.arraycopy(this.inputDirectoryFiles, 0, new_inputDirectoryFiles, 0, dropPoint);
            this.inputDirectoryFiles = new_inputDirectoryFiles;
            Arrays.sort(this.inputDirectoryFiles);
            if (!this.setNextDirectoryInputStream()) {
                throw new FileNotFoundException("Empty directory specified.");
            }
        }
        if (jobTraceFilename != null) {
            this.jobTraceGen = new DefaultOutputter<LoggedJob>();
            this.jobTraceGen.init(jobTraceFilename, this.getConf());
            if (topologyFilename != null) {
                this.topologyGen = new DefaultOutputter<LoggedNetworkTopology>();
                this.topologyGen.init(topologyFilename, this.getConf());
            }
        }
        return 0;
    }

    private LineReader maybeUncompressedPath(Path p) throws FileNotFoundException, IOException {
        CompressionCodecFactory codecs = new CompressionCodecFactory(this.getConf());
        this.inputCodec = codecs.getCodec(p);
        FileSystem fs = p.getFileSystem(this.getConf());
        FSDataInputStream fileIn = fs.open(p);
        if (this.inputCodec == null) {
            return new LineReader((InputStream)fileIn, this.getConf());
        }
        this.inputDecompressor = CodecPool.getDecompressor((CompressionCodec)this.inputCodec);
        return new LineReader((InputStream)this.inputCodec.createInputStream((InputStream)fileIn, this.inputDecompressor), this.getConf());
    }

    private boolean setNextDirectoryInputStream() throws FileNotFoundException, IOException {
        if (this.input != null) {
            this.input.close();
            LOG.info((Object)("File closed: " + this.currentFileName));
            this.input = null;
        }
        if (this.inputCodec != null) {
            CodecPool.returnDecompressor((Decompressor)this.inputDecompressor);
            this.inputDecompressor = null;
            this.inputCodec = null;
        }
        ++this.inputDirectoryCursor;
        if (this.inputDirectoryCursor >= this.inputDirectoryFiles.length) {
            return false;
        }
        this.fileFirstLine = true;
        this.currentFileName = this.inputDirectoryFiles[this.inputDirectoryCursor];
        LOG.info((Object)("\nOpening file " + this.currentFileName + "  *************************** ."));
        LOG.info((Object)("This file, " + (this.inputDirectoryCursor + 1) + "/" + this.inputDirectoryFiles.length + ", starts with line " + this.lineNumber + "."));
        this.input = this.maybeUncompressedPath(new Path(this.inputDirectoryPath, this.currentFileName));
        return true;
    }

    private String readInputLine() throws IOException {
        try {
            if (this.input == null) {
                return null;
            }
            this.inputLineText.clear();
            if (this.input.readLine(this.inputLineText) == 0) {
                return null;
            }
            return this.inputLineText.toString();
        }
        catch (EOFException e) {
            return null;
        }
    }

    private String readCountedLine() throws IOException {
        if (this.rereadableLine != null) {
            String result = this.rereadableLine;
            this.rereadableLine = null;
            return result;
        }
        String result = this.readInputLine();
        if (result != null) {
            if (this.fileFirstLine && (result.equals("") || result.charAt(0) != '\f')) {
                this.fileFirstLine = false;
                this.rereadableLine = result;
                return "\f!!FILE " + this.currentFileName + "!!\n";
            }
            this.fileFirstLine = false;
            ++this.lineNumber;
        } else if (this.inputIsDirectory && this.setNextDirectoryInputStream()) {
            result = this.readCountedLine();
        }
        return result;
    }

    private void unreadCountedLine(String unreadee) {
        if (this.rereadableLine == null) {
            this.rereadableLine = unreadee;
        }
    }

    private boolean apparentConfFileHeader(String header) {
        return confFileHeader.matcher(header).find();
    }

    private boolean apparentXMLFileStart(String line) {
        return xmlFilePrefix.matcher(line).lookingAt();
    }

    private Pair<String, String> readBalancedLine() throws IOException {
        String endlineString;
        String line = this.readCountedLine();
        if (line == null) {
            return null;
        }
        while (line.indexOf(12) > 0) {
            line = line.substring(line.indexOf(12));
        }
        if (line.length() != 0 && line.charAt(0) == '\f') {
            String subjectLine = this.readCountedLine();
            if (subjectLine != null && subjectLine.length() != 0 && this.apparentConfFileHeader(line) && this.apparentXMLFileStart(subjectLine)) {
                StringBuilder sb = new StringBuilder();
                while (subjectLine != null && subjectLine.indexOf(12) > 0) {
                    subjectLine = subjectLine.substring(subjectLine.indexOf(12));
                }
                while (subjectLine != null && (subjectLine.length() == 0 || subjectLine.charAt(0) != '\f')) {
                    sb.append(subjectLine);
                    subjectLine = this.readCountedLine();
                }
                if (subjectLine != null) {
                    this.unreadCountedLine(subjectLine);
                }
                return new Pair<String, String>(line, sb.toString());
            }
            return this.readBalancedLine();
        }
        String string = endlineString = this.version == 0 ? " " : " .";
        if (line.length() < endlineString.length()) {
            return new Pair<Object, String>(null, line);
        }
        if (!endlineString.equals(line.substring(line.length() - endlineString.length()))) {
            String addedLine;
            StringBuilder sb = new StringBuilder(line);
            do {
                if ((addedLine = this.readCountedLine()) == null) {
                    return new Pair<Object, String>(null, sb.toString());
                }
                while (addedLine.indexOf(12) > 0) {
                    addedLine = addedLine.substring(addedLine.indexOf(12));
                }
                if (addedLine.length() > 0 && addedLine.charAt(0) == '\f') {
                    this.unreadCountedLine(addedLine);
                    return new Pair<Object, String>(null, sb.toString());
                }
                sb.append("\n");
                sb.append(addedLine);
            } while (!endlineString.equals(addedLine.substring(addedLine.length() - endlineString.length())));
            line = sb.toString();
        }
        return new Pair<Object, String>(null, line);
    }

    private void incorporateSpread(Histogram taskTimes, Histogram[][] spreadTo, JobOutcome outcome, LoggedJob.JobType jtype) {
        if (!this.spreading) {
            return;
        }
        if (taskTimes.getTotalCount() <= 1L) {
            return;
        }
        int[] endpoints = new int[]{this.spreadMin, this.spreadMax};
        long[] endpointKeys = taskTimes.getCDF(1000, endpoints);
        int smallResultOffset = taskTimes.getTotalCount() < 5L ? 1 : 0;
        Histogram myTotal = spreadTo[outcome.ordinal()][jtype.ordinal()];
        long dividend = endpointKeys[2 + smallResultOffset];
        long divisor = endpointKeys[1 - smallResultOffset];
        if (divisor > 0L) {
            long mytotalRatio = dividend * 1000000L / divisor;
            myTotal.enter(mytotalRatio);
        }
    }

    private void canonicalDistributionsEnter(Histogram[][] block, JobOutcome outcome, LoggedJob.JobType type, long value) {
        this.getDistribution(block, outcome, type).enter(value);
        this.getDistribution(block, JobOutcome.OVERALL, type).enter(value);
        this.getDistribution(block, outcome, LoggedJob.JobType.OVERALL).enter(value);
        this.getDistribution(block, JobOutcome.OVERALL, LoggedJob.JobType.OVERALL).enter(value);
    }

    private void processJobLine(ParsedLine line) throws JsonProcessingException, IOException {
        try {
            if (this.version == 0 || this.version == 1) {
                String jobID = line.get("JOBID");
                String user = line.get("USER");
                String jobPriority = line.get("JOB_PRIORITY");
                String submitTime = line.get("SUBMIT_TIME");
                String jobName = line.get("JOBNAME");
                String launchTime = line.get("LAUNCH_TIME");
                String finishTime = line.get("FINISH_TIME");
                String status = line.get("JOB_STATUS");
                String totalMaps = line.get("TOTAL_MAPS");
                String totalReduces = line.get("TOTAL_REDUCES");
                if (!(jobID == null || this.jobTraceGen == null || this.jobBeingTraced != null && jobID.equals(this.jobBeingTraced.getJobID().toString()))) {
                    int i;
                    this.finalizeJob();
                    this.jobBeingTraced = new LoggedJob(jobID);
                    this.tasksInCurrentJob = new HashMap<String, LoggedTask>();
                    this.attemptsInCurrentJob = new HashMap<String, LoggedTaskAttempt>();
                    this.successfulMapAttemptTimes = new Histogram[ParsedHost.numberOfDistances() + 1];
                    for (i = 0; i < this.successfulMapAttemptTimes.length; ++i) {
                        this.successfulMapAttemptTimes[i] = new Histogram();
                    }
                    this.successfulReduceAttemptTimes = new Histogram();
                    this.failedMapAttemptTimes = new Histogram[ParsedHost.numberOfDistances() + 1];
                    for (i = 0; i < this.failedMapAttemptTimes.length; ++i) {
                        this.failedMapAttemptTimes[i] = new Histogram();
                    }
                    this.failedReduceAttemptTimes = new Histogram();
                    this.successfulNthMapperAttempts = new Histogram();
                    this.successfulNthReducerAttempts = new Histogram();
                    this.mapperLocality = new Histogram();
                }
                if (this.jobBeingTraced != null) {
                    if (user != null) {
                        this.jobBeingTraced.setUser(user);
                    }
                    if (jobPriority != null) {
                        this.jobBeingTraced.setPriority(LoggedJob.JobPriority.valueOf(jobPriority));
                    }
                    if (totalMaps != null) {
                        this.jobBeingTraced.setTotalMaps(Integer.parseInt(totalMaps));
                    }
                    if (totalReduces != null) {
                        this.jobBeingTraced.setTotalReduces(Integer.parseInt(totalReduces));
                    }
                    if (submitTime != null) {
                        this.jobBeingTraced.setSubmitTime(Long.parseLong(submitTime));
                    }
                    if (launchTime != null) {
                        this.jobBeingTraced.setLaunchTime(Long.parseLong(launchTime));
                    }
                    if (finishTime != null) {
                        this.jobBeingTraced.setFinishTime(Long.parseLong(finishTime));
                        if (status != null) {
                            this.jobBeingTraced.setOutcome(Pre21JobHistoryConstants.Values.valueOf(status));
                        }
                        this.maybeMateJobAndConf();
                    }
                }
                if (jobName != null) {
                    Matcher m = streamingJobnamePattern.matcher(jobName);
                    this.thisJobType = LoggedJob.JobType.JAVA;
                    if (m.matches()) {
                        this.thisJobType = LoggedJob.JobType.STREAMING;
                    }
                }
                if (submitTime != null) {
                    this.submitTimeCurrentJob = Long.parseLong(submitTime);
                    this.currentJobID = jobID;
                    this.taskAttemptStartTimes = new HashMap<String, Long>();
                    this.taskReduceAttemptShuffleEndTimes = new HashMap<String, Long>();
                    this.taskReduceAttemptSortEndTimes = new HashMap<String, Long>();
                    this.taskMapAttemptFinishTimes = new HashMap<String, Long>();
                    this.taskReduceAttemptFinishTimes = new HashMap<String, Long>();
                    this.launchTimeCurrentJob = 0L;
                } else if (launchTime != null && jobID != null && this.currentJobID.equals(jobID)) {
                    this.launchTimeCurrentJob = Long.parseLong(launchTime);
                } else if (finishTime != null && jobID != null && this.currentJobID.equals(jobID)) {
                    long endTime = Long.parseLong(finishTime);
                    if (this.launchTimeCurrentJob != 0L) {
                        JobOutcome thisOutcome;
                        String jobResultText = line.get("JOB_STATUS");
                        JobOutcome jobOutcome = thisOutcome = jobResultText != null && "SUCCESS".equals(jobResultText) ? JobOutcome.SUCCESS : JobOutcome.FAILURE;
                        if (this.submitTimeCurrentJob != 0L) {
                            this.canonicalDistributionsEnter(this.delayTimeDists, thisOutcome, this.thisJobType, this.launchTimeCurrentJob - this.submitTimeCurrentJob);
                        }
                        if (this.launchTimeCurrentJob != 0L) {
                            this.canonicalDistributionsEnter(this.runTimeDists, thisOutcome, this.thisJobType, endTime - this.launchTimeCurrentJob);
                        }
                        Histogram currentJobMapTimes = new Histogram();
                        Histogram currentJobShuffleTimes = new Histogram();
                        Histogram currentJobSortTimes = new Histogram();
                        Histogram currentJobReduceTimes = new Histogram();
                        for (Map.Entry<String, Long> entry : this.taskAttemptStartTimes.entrySet()) {
                            long startTime = entry.getValue();
                            Long mapEndTime = this.taskMapAttemptFinishTimes.get(entry.getKey());
                            if (mapEndTime != null) {
                                currentJobMapTimes.enter(mapEndTime - startTime);
                                this.canonicalDistributionsEnter(this.mapTimeDists, thisOutcome, this.thisJobType, mapEndTime - startTime);
                            }
                            Long shuffleEnd = this.taskReduceAttemptShuffleEndTimes.get(entry.getKey());
                            Long sortEnd = this.taskReduceAttemptSortEndTimes.get(entry.getKey());
                            Long reduceEnd = this.taskReduceAttemptFinishTimes.get(entry.getKey());
                            if (shuffleEnd == null || sortEnd == null || reduceEnd == null) continue;
                            currentJobShuffleTimes.enter(shuffleEnd - startTime);
                            currentJobSortTimes.enter(sortEnd - shuffleEnd);
                            currentJobReduceTimes.enter(reduceEnd - sortEnd);
                            this.canonicalDistributionsEnter(this.shuffleTimeDists, thisOutcome, this.thisJobType, shuffleEnd - startTime);
                            this.canonicalDistributionsEnter(this.sortTimeDists, thisOutcome, this.thisJobType, sortEnd - shuffleEnd);
                            this.canonicalDistributionsEnter(this.reduceTimeDists, thisOutcome, this.thisJobType, reduceEnd - sortEnd);
                        }
                        this.incorporateSpread(currentJobMapTimes, this.mapTimeSpreadDists, thisOutcome, this.thisJobType);
                        this.incorporateSpread(currentJobShuffleTimes, this.shuffleTimeSpreadDists, thisOutcome, this.thisJobType);
                        this.incorporateSpread(currentJobSortTimes, this.sortTimeSpreadDists, thisOutcome, this.thisJobType);
                        this.incorporateSpread(currentJobReduceTimes, this.reduceTimeSpreadDists, thisOutcome, this.thisJobType);
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("HadoopLogsAnalyzer.processJobLine: bad numerical format, at line " + this.lineNumber + "."), (Throwable)e);
        }
    }

    private void processTaskLine(ParsedLine line) {
        if (this.jobBeingTraced != null) {
            List<LoggedTask> vec;
            Pre21JobHistoryConstants.Values typ;
            Pre21JobHistoryConstants.Values stat;
            boolean taskAlreadyLogged;
            String taskID = line.get("TASKID");
            String taskType = line.get("TASK_TYPE");
            String startTime = line.get("START_TIME");
            String status = line.get("TASK_STATUS");
            String finishTime = line.get("FINISH_TIME");
            String splits = line.get("SPLITS");
            LoggedTask task = this.tasksInCurrentJob.get(taskID);
            boolean bl = taskAlreadyLogged = task != null;
            if (task == null) {
                task = new LoggedTask();
            }
            if (splits != null) {
                ArrayList<LoggedLocation> locations = null;
                StringTokenizer tok = new StringTokenizer(splits, ",", false);
                if (tok.countTokens() <= 25) {
                    locations = new ArrayList<LoggedLocation>();
                }
                while (tok.hasMoreTokens()) {
                    String nextSplit = tok.nextToken();
                    ParsedHost node = this.getAndRecordParsedHost(nextSplit);
                    if (locations == null || node == null) continue;
                    locations.add(node.makeLoggedLocation());
                }
                task.setPreferredLocations(locations);
            }
            task.setTaskID(taskID);
            if (startTime != null) {
                task.setStartTime(Long.parseLong(startTime));
            }
            if (finishTime != null) {
                task.setFinishTime(Long.parseLong(finishTime));
            }
            try {
                stat = status == null ? null : Pre21JobHistoryConstants.Values.valueOf(status);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)("A task status you don't know about is \"" + status + "\"."), (Throwable)e);
                stat = null;
            }
            task.setTaskStatus(stat);
            try {
                typ = taskType == null ? null : Pre21JobHistoryConstants.Values.valueOf(taskType);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)("A task type you don't know about is \"" + taskType + "\"."), (Throwable)e);
                typ = null;
            }
            if (typ == null) {
                return;
            }
            task.setTaskType(typ);
            List<LoggedTask> list = typ == Pre21JobHistoryConstants.Values.MAP ? this.jobBeingTraced.getMapTasks() : (vec = typ == Pre21JobHistoryConstants.Values.REDUCE ? this.jobBeingTraced.getReduceTasks() : this.jobBeingTraced.getOtherTasks());
            if (!taskAlreadyLogged) {
                vec.add(task);
                this.tasksInCurrentJob.put(taskID, task);
            }
        }
    }

    private Pattern counterPattern(String counterName) {
        Pattern result = this.counterPatterns.get(counterName);
        if (result == null) {
            String namePatternRegex = "\\[\\(" + counterName + "\\)\\([^)]+\\)\\(([0-9]+)\\)\\]";
            result = Pattern.compile(namePatternRegex);
            this.counterPatterns.put(counterName, result);
        }
        return result;
    }

    private String parseCounter(String counterString, String counterName) {
        if (counterString == null) {
            return null;
        }
        Matcher mat = this.counterPattern(counterName).matcher(counterString);
        if (mat.find()) {
            return mat.group(1);
        }
        return null;
    }

    private void incorporateCounter(SetField thunk, String counterString, String counterName) {
        String valueString = this.parseCounter(counterString, counterName);
        if (valueString != null) {
            thunk.set(Long.parseLong(valueString));
        }
    }

    private void incorporateCounters(LoggedTaskAttempt attempt2, String counterString) {
        this.incorporateCounter(new SetField(attempt2){

            @Override
            void set(long val) {
                this.attempt.hdfsBytesRead = val;
            }
        }, counterString, "HDFS_BYTES_READ");
        this.incorporateCounter(new SetField(attempt2){

            @Override
            void set(long val) {
                this.attempt.hdfsBytesWritten = val;
            }
        }, counterString, "HDFS_BYTES_WRITTEN");
        this.incorporateCounter(new SetField(attempt2){

            @Override
            void set(long val) {
                this.attempt.fileBytesRead = val;
            }
        }, counterString, "FILE_BYTES_READ");
        this.incorporateCounter(new SetField(attempt2){

            @Override
            void set(long val) {
                this.attempt.fileBytesWritten = val;
            }
        }, counterString, "FILE_BYTES_WRITTEN");
        this.incorporateCounter(new SetField(attempt2){

            @Override
            void set(long val) {
                this.attempt.mapInputBytes = val;
            }
        }, counterString, "MAP_INPUT_BYTES");
        this.incorporateCounter(new SetField(attempt2){

            @Override
            void set(long val) {
                this.attempt.mapInputRecords = val;
            }
        }, counterString, "MAP_INPUT_RECORDS");
        this.incorporateCounter(new SetField(attempt2){

            @Override
            void set(long val) {
                this.attempt.mapOutputBytes = val;
            }
        }, counterString, "MAP_OUTPUT_BYTES");
        this.incorporateCounter(new SetField(attempt2){

            @Override
            void set(long val) {
                this.attempt.mapOutputRecords = val;
            }
        }, counterString, "MAP_OUTPUT_RECORDS");
        this.incorporateCounter(new SetField(attempt2){

            @Override
            void set(long val) {
                this.attempt.combineInputRecords = val;
            }
        }, counterString, "COMBINE_INPUT_RECORDS");
        this.incorporateCounter(new SetField(attempt2){

            @Override
            void set(long val) {
                this.attempt.reduceInputGroups = val;
            }
        }, counterString, "REDUCE_INPUT_GROUPS");
        this.incorporateCounter(new SetField(attempt2){

            @Override
            void set(long val) {
                this.attempt.reduceInputRecords = val;
            }
        }, counterString, "REDUCE_INPUT_RECORDS");
        this.incorporateCounter(new SetField(attempt2){

            @Override
            void set(long val) {
                this.attempt.reduceShuffleBytes = val;
            }
        }, counterString, "REDUCE_SHUFFLE_BYTES");
        this.incorporateCounter(new SetField(attempt2){

            @Override
            void set(long val) {
                this.attempt.reduceOutputRecords = val;
            }
        }, counterString, "REDUCE_OUTPUT_RECORDS");
        this.incorporateCounter(new SetField(attempt2){

            @Override
            void set(long val) {
                this.attempt.spilledRecords = val;
            }
        }, counterString, "SPILLED_RECORDS");
        this.incorporateCounter(new SetField(attempt2){

            @Override
            void set(long val) {
                this.attempt.getResourceUsageMetrics().setCumulativeCpuUsage(val);
            }
        }, counterString, "CPU_MILLISECONDS");
        this.incorporateCounter(new SetField(attempt2){

            @Override
            void set(long val) {
                this.attempt.getResourceUsageMetrics().setVirtualMemoryUsage(val);
            }
        }, counterString, "VIRTUAL_MEMORY_BYTES");
        this.incorporateCounter(new SetField(attempt2){

            @Override
            void set(long val) {
                this.attempt.getResourceUsageMetrics().setPhysicalMemoryUsage(val);
            }
        }, counterString, "PHYSICAL_MEMORY_BYTES");
        this.incorporateCounter(new SetField(attempt2){

            @Override
            void set(long val) {
                this.attempt.getResourceUsageMetrics().setHeapUsage(val);
            }
        }, counterString, "COMMITTED_HEAP_BYTES");
    }

    private ParsedHost getAndRecordParsedHost(String hostName) {
        ParsedHost result = ParsedHost.parse(hostName);
        if (result != null && !this.allHosts.contains(result)) {
            this.allHosts.add(result);
        }
        return result;
    }

    private void processMapAttemptLine(ParsedLine line) {
        String attemptID = line.get("TASK_ATTEMPT_ID");
        String taskID = line.get("TASKID");
        String status = line.get("TASK_STATUS");
        String attemptStartTime = line.get("START_TIME");
        String attemptFinishTime = line.get("FINISH_TIME");
        String hostName = line.get("HOSTNAME");
        String counters = line.get("COUNTERS");
        if (this.jobBeingTraced != null && taskID != null) {
            String attemptNumberString;
            Matcher matcher;
            boolean attemptAlreadyExists;
            LoggedTask task = this.tasksInCurrentJob.get(taskID);
            if (task == null) {
                task = new LoggedTask();
                task.setTaskID(taskID);
                this.jobBeingTraced.getMapTasks().add(task);
                this.tasksInCurrentJob.put(taskID, task);
            }
            task.setTaskID(taskID);
            LoggedTaskAttempt attempt = this.attemptsInCurrentJob.get(attemptID);
            boolean bl = attemptAlreadyExists = attempt != null;
            if (attempt == null) {
                attempt = new LoggedTaskAttempt();
                attempt.setAttemptID(attemptID);
            }
            if (!attemptAlreadyExists) {
                this.attemptsInCurrentJob.put(attemptID, attempt);
                task.getAttempts().add(attempt);
            }
            Pre21JobHistoryConstants.Values stat = null;
            try {
                stat = status == null ? null : Pre21JobHistoryConstants.Values.valueOf(status);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)("A map attempt status you don't know about is \"" + status + "\"."), (Throwable)e);
                stat = null;
            }
            this.incorporateCounters(attempt, counters);
            attempt.setResult(stat);
            if (attemptStartTime != null) {
                attempt.setStartTime(Long.parseLong(attemptStartTime));
            }
            if (attemptFinishTime != null) {
                attempt.setFinishTime(Long.parseLong(attemptFinishTime));
            }
            int distance = Integer.MAX_VALUE;
            if (hostName != null) {
                ParsedHost host = this.getAndRecordParsedHost(hostName);
                if (host != null) {
                    attempt.setHostName(host.getNodeName(), host.getRackName());
                    attempt.setLocation(host.makeLoggedLocation());
                } else {
                    attempt.setHostName(hostName, null);
                }
                List<LoggedLocation> locs = task.getPreferredLocations();
                if (host != null && locs != null) {
                    for (LoggedLocation loc : locs) {
                        ParsedHost preferedLoc = new ParsedHost(loc);
                        distance = Math.min(distance, preferedLoc.distance(host));
                    }
                }
                this.mapperLocality.enter(distance);
            }
            distance = Math.min(distance, this.successfulMapAttemptTimes.length - 1);
            if (attempt.getStartTime() > 0L && attempt.getFinishTime() > 0L) {
                long runtime = attempt.getFinishTime() - attempt.getStartTime();
                if (stat == Pre21JobHistoryConstants.Values.SUCCESS) {
                    this.successfulMapAttemptTimes[distance].enter(runtime);
                }
                if (stat == Pre21JobHistoryConstants.Values.FAILED) {
                    this.failedMapAttemptTimes[distance].enter(runtime);
                }
            }
            if (attemptID != null && (matcher = taskAttemptIDPattern.matcher(attemptID)).matches() && (attemptNumberString = matcher.group(1)) != null) {
                int attemptNumber = Integer.parseInt(attemptNumberString);
                this.successfulNthMapperAttempts.enter(attemptNumber);
            }
        }
        try {
            if (attemptStartTime != null) {
                long startTimeValue = Long.parseLong(attemptStartTime);
                if (startTimeValue != 0L && startTimeValue + 10000L >= this.launchTimeCurrentJob) {
                    this.taskAttemptStartTimes.put(attemptID, startTimeValue);
                } else {
                    this.taskAttemptStartTimes.remove(attemptID);
                }
            } else if (status != null && attemptFinishTime != null) {
                long finishTime = Long.parseLong(attemptFinishTime);
                if (status.equals("SUCCESS")) {
                    this.taskMapAttemptFinishTimes.put(attemptID, finishTime);
                }
            }
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("HadoopLogsAnalyzer.processMapAttemptLine: bad numerical format, at line" + this.lineNumber + "."), (Throwable)e);
        }
    }

    private void processReduceAttemptLine(ParsedLine line) {
        String attemptID = line.get("TASK_ATTEMPT_ID");
        String taskID = line.get("TASKID");
        String status = line.get("TASK_STATUS");
        String attemptStartTime = line.get("START_TIME");
        String attemptFinishTime = line.get("FINISH_TIME");
        String attemptShuffleFinished = line.get("SHUFFLE_FINISHED");
        String attemptSortFinished = line.get("SORT_FINISHED");
        String counters = line.get("COUNTERS");
        String hostName = line.get("HOSTNAME");
        if (hostName != null && !this.hostNames.contains(hostName)) {
            this.hostNames.add(hostName);
        }
        if (this.jobBeingTraced != null && taskID != null) {
            String attemptNumberString;
            Matcher matcher;
            boolean attemptAlreadyExists;
            LoggedTask task = this.tasksInCurrentJob.get(taskID);
            if (task == null) {
                task = new LoggedTask();
                task.setTaskID(taskID);
                this.jobBeingTraced.getReduceTasks().add(task);
                this.tasksInCurrentJob.put(taskID, task);
            }
            task.setTaskID(taskID);
            LoggedTaskAttempt attempt = this.attemptsInCurrentJob.get(attemptID);
            boolean bl = attemptAlreadyExists = attempt != null;
            if (attempt == null) {
                attempt = new LoggedTaskAttempt();
                attempt.setAttemptID(attemptID);
            }
            if (!attemptAlreadyExists) {
                this.attemptsInCurrentJob.put(attemptID, attempt);
                task.getAttempts().add(attempt);
            }
            Pre21JobHistoryConstants.Values stat = null;
            try {
                stat = status == null ? null : Pre21JobHistoryConstants.Values.valueOf(status);
            }
            catch (IllegalArgumentException e) {
                LOG.warn((Object)("A map attempt status you don't know about is \"" + status + "\"."), (Throwable)e);
                stat = null;
            }
            this.incorporateCounters(attempt, counters);
            attempt.setResult(stat);
            if (attemptStartTime != null) {
                attempt.setStartTime(Long.parseLong(attemptStartTime));
            }
            if (attemptFinishTime != null) {
                attempt.setFinishTime(Long.parseLong(attemptFinishTime));
            }
            if (attemptShuffleFinished != null) {
                attempt.setShuffleFinished(Long.parseLong(attemptShuffleFinished));
            }
            if (attemptSortFinished != null) {
                attempt.setSortFinished(Long.parseLong(attemptSortFinished));
            }
            if (attempt.getStartTime() > 0L && attempt.getFinishTime() > 0L) {
                long runtime = attempt.getFinishTime() - attempt.getStartTime();
                if (stat == Pre21JobHistoryConstants.Values.SUCCESS) {
                    this.successfulReduceAttemptTimes.enter(runtime);
                }
                if (stat == Pre21JobHistoryConstants.Values.FAILED) {
                    this.failedReduceAttemptTimes.enter(runtime);
                }
            }
            if (hostName != null) {
                ParsedHost host = this.getAndRecordParsedHost(hostName);
                if (host != null) {
                    attempt.setHostName(host.getNodeName(), host.getRackName());
                } else {
                    attempt.setHostName(hostName, null);
                }
            }
            if (attemptID != null && (matcher = taskAttemptIDPattern.matcher(attemptID)).matches() && (attemptNumberString = matcher.group(1)) != null) {
                int attemptNumber = Integer.parseInt(attemptNumberString);
                this.successfulNthReducerAttempts.enter(attemptNumber);
            }
        }
        try {
            if (attemptStartTime != null) {
                long startTimeValue = Long.parseLong(attemptStartTime);
                if (startTimeValue != 0L && startTimeValue + 10000L >= this.launchTimeCurrentJob) {
                    this.taskAttemptStartTimes.put(attemptID, startTimeValue);
                }
            } else if (status != null && status.equals("SUCCESS") && attemptFinishTime != null) {
                long finishTime = Long.parseLong(attemptFinishTime);
                this.taskReduceAttemptFinishTimes.put(attemptID, finishTime);
                if (attemptShuffleFinished != null) {
                    this.taskReduceAttemptShuffleEndTimes.put(attemptID, Long.parseLong(attemptShuffleFinished));
                }
                if (attemptSortFinished != null) {
                    this.taskReduceAttemptSortEndTimes.put(attemptID, Long.parseLong(attemptSortFinished));
                }
            }
        }
        catch (NumberFormatException e) {
            LOG.error((Object)("HadoopLogsAnalyzer.processReduceAttemptLine: bad numerical format, at line" + this.lineNumber + "."), (Throwable)e);
        }
    }

    private void processParsedLine(ParsedLine line) throws JsonProcessingException, IOException {
        if (!this.collecting) {
            LogRecordType myType = line.getType();
            if (myType == this.canonicalJob) {
                this.processJobLine(line);
            } else if (myType == this.canonicalTask) {
                this.processTaskLine(line);
            } else if (myType == this.canonicalMapAttempt) {
                this.processMapAttemptLine(line);
            } else if (myType == this.canonicalReduceAttempt) {
                this.processReduceAttemptLine(line);
            }
        }
    }

    private void printDistributionSet(String title, Histogram[][] distSet) {
        this.statisticalOutput.print(title + "\n\n");
        for (int i = 0; i < JobOutcome.values().length; ++i) {
            for (int j = 0; j < LoggedJob.JobType.values().length; ++j) {
                JobOutcome thisOutcome = JobOutcome.values()[i];
                LoggedJob.JobType thisType = LoggedJob.JobType.values()[j];
                this.statisticalOutput.print("outcome = ");
                this.statisticalOutput.print(thisOutcome.toString());
                this.statisticalOutput.print(", and type = ");
                this.statisticalOutput.print(thisType.toString());
                this.statisticalOutput.print(".\n\n");
                Histogram dist = distSet[i][j];
                this.printSingleDistributionData(dist);
            }
        }
    }

    private void printSingleDistributionData(Histogram dist) {
        int[] percentiles = new int[this.numberBuckets];
        for (int k = 0; k < this.numberBuckets; ++k) {
            percentiles[k] = k + 1;
        }
        long[] cdf = dist.getCDF(this.numberBuckets + 1, percentiles);
        if (cdf == null) {
            this.statisticalOutput.print("(No data)\n");
        } else {
            this.statisticalOutput.print("min:  ");
            this.statisticalOutput.print(cdf[0]);
            this.statisticalOutput.print("\n");
            for (int k = 0; k < this.numberBuckets; ++k) {
                this.statisticalOutput.print(percentiles[k]);
                this.statisticalOutput.print("%   ");
                this.statisticalOutput.print(cdf[k + 1]);
                this.statisticalOutput.print("\n");
            }
            this.statisticalOutput.print("max:  ");
            this.statisticalOutput.print(cdf[this.numberBuckets + 1]);
            this.statisticalOutput.print("\n");
        }
    }

    private void maybeMateJobAndConf() throws IOException {
        if (this.jobBeingTraced != null && this.jobconf != null && this.jobBeingTraced.getJobID().toString().equals(this.jobconf.jobID)) {
            this.jobBeingTraced.setHeapMegabytes(this.jobconf.heapMegabytes);
            this.jobBeingTraced.setQueue(this.jobconf.queue);
            this.jobBeingTraced.setJobName(this.jobconf.jobName);
            this.jobBeingTraced.setClusterMapMB(this.jobconf.clusterMapMB);
            this.jobBeingTraced.setClusterReduceMB(this.jobconf.clusterReduceMB);
            this.jobBeingTraced.setJobMapMB(this.jobconf.jobMapMB);
            this.jobBeingTraced.setJobReduceMB(this.jobconf.jobReduceMB);
            this.jobBeingTraced.setJobProperties(this.jobconf.properties);
            this.jobconf = null;
            this.finalizeJob();
        }
    }

    private ArrayList<LoggedDiscreteCDF> mapCDFArrayList(Histogram[] data) {
        ArrayList<LoggedDiscreteCDF> result = new ArrayList<LoggedDiscreteCDF>();
        for (Histogram hist : data) {
            LoggedDiscreteCDF discCDF = new LoggedDiscreteCDF();
            discCDF.setCDF(hist, this.attemptTimesPercentiles, 100);
            result.add(discCDF);
        }
        return result;
    }

    private void finalizeJob() throws IOException {
        if (this.jobBeingTraced != null) {
            if (this.omitTaskDetails) {
                this.jobBeingTraced.setMapTasks(null);
                this.jobBeingTraced.setReduceTasks(null);
                this.jobBeingTraced.setOtherTasks(null);
            }
            this.jobBeingTraced.setSuccessfulMapAttemptCDFs(this.mapCDFArrayList(this.successfulMapAttemptTimes));
            this.jobBeingTraced.setFailedMapAttemptCDFs(this.mapCDFArrayList(this.failedMapAttemptTimes));
            LoggedDiscreteCDF discCDF = new LoggedDiscreteCDF();
            discCDF.setCDF(this.successfulReduceAttemptTimes, this.attemptTimesPercentiles, 100);
            this.jobBeingTraced.setSuccessfulReduceAttemptCDF(discCDF);
            discCDF = new LoggedDiscreteCDF();
            discCDF.setCDF(this.failedReduceAttemptTimes, this.attemptTimesPercentiles, 100);
            this.jobBeingTraced.setFailedReduceAttemptCDF(discCDF);
            long totalSuccessfulAttempts = 0L;
            long maxTriesToSucceed = 0L;
            for (Map.Entry<Long, Long> ent : this.successfulNthMapperAttempts) {
                totalSuccessfulAttempts += ent.getValue().longValue();
                maxTriesToSucceed = Math.max(maxTriesToSucceed, ent.getKey());
            }
            if (totalSuccessfulAttempts > 0L) {
                double[] successAfterI = new double[(int)maxTriesToSucceed + 1];
                for (int i = 0; i < successAfterI.length; ++i) {
                    successAfterI[i] = 0.0;
                }
                for (Map.Entry<Long, Long> ent : this.successfulNthMapperAttempts) {
                    successAfterI[ent.getKey().intValue()] = (double)ent.getValue().longValue() / (double)totalSuccessfulAttempts;
                }
                this.jobBeingTraced.setMapperTriesToSucceed(successAfterI);
            } else {
                this.jobBeingTraced.setMapperTriesToSucceed(null);
            }
            this.jobTraceGen.output(this.jobBeingTraced);
            this.jobBeingTraced = null;
        }
    }

    public int run(String[] args) throws IOException {
        int result = this.initializeHadoopLogsAnalyzer(args);
        if (result != 0) {
            return result;
        }
        return this.run();
    }

    int run() throws IOException {
        Pair<String, String> line = this.readBalancedLine();
        while (line != null) {
            if (this.debug && (this.lineNumber < 1000000L && this.lineNumber % 1000L == 0L || this.lineNumber % 1000000L == 0L)) {
                LOG.debug((Object)("" + this.lineNumber + " " + line.second()));
            }
            if (line.first() == null) {
                try {
                    this.processParsedLine(new ParsedLine(line.second(), this.version));
                }
                catch (StringIndexOutOfBoundsException e) {
                    LOG.warn((Object)("anomalous line #" + this.lineNumber + ":" + line), (Throwable)e);
                }
            } else {
                this.jobconf = new ParsedConfigFile(line.first(), line.second());
                if (!this.jobconf.valid) {
                    this.jobconf = null;
                }
                this.maybeMateJobAndConf();
            }
            line = this.readBalancedLine();
        }
        this.finalizeJob();
        if (this.collecting) {
            String[] typeNames = LogRecordType.lineTypes();
            for (int i = 0; i < typeNames.length; ++i) {
                this.statisticalOutput.print(typeNames[i]);
                this.statisticalOutput.print('\n');
            }
        } else {
            if (this.delays) {
                this.printDistributionSet("Job start delay spectrum:", this.delayTimeDists);
            }
            if (this.runtimes) {
                this.printDistributionSet("Job run time spectrum:", this.runTimeDists);
            }
            if (this.spreading) {
                String ratioDescription = "(" + this.spreadMax + "/1000 %ile) to (" + this.spreadMin + "/1000 %ile) scaled by 1000000";
                this.printDistributionSet("Map task success times " + ratioDescription + ":", this.mapTimeSpreadDists);
                this.printDistributionSet("Shuffle success times " + ratioDescription + ":", this.shuffleTimeSpreadDists);
                this.printDistributionSet("Sort success times " + ratioDescription + ":", this.sortTimeSpreadDists);
                this.printDistributionSet("Reduce success times " + ratioDescription + ":", this.reduceTimeSpreadDists);
            }
            if (this.collectTaskTimes) {
                this.printDistributionSet("Global map task success times:", this.mapTimeDists);
                this.printDistributionSet("Global shuffle task success times:", this.shuffleTimeDists);
                this.printDistributionSet("Global sort task success times:", this.sortTimeDists);
                this.printDistributionSet("Global reduce task success times:", this.reduceTimeDists);
            }
        }
        if (this.topologyGen != null) {
            LoggedNetworkTopology topo = new LoggedNetworkTopology(this.allHosts, "<root>", 0);
            this.topologyGen.output(topo);
            this.topologyGen.close();
        }
        if (this.jobTraceGen != null) {
            this.jobTraceGen.close();
        }
        if (this.input != null) {
            this.input.close();
            this.input = null;
        }
        if (this.inputCodec != null) {
            CodecPool.returnDecompressor((Decompressor)this.inputDecompressor);
            this.inputDecompressor = null;
            this.inputCodec = null;
        }
        return 0;
    }

    public static void main(String[] args) {
        try {
            HadoopLogsAnalyzer analyzer = new HadoopLogsAnalyzer();
            int result = ToolRunner.run((Tool)analyzer, (String[])args);
            if (result == 0) {
                return;
            }
            System.exit(result);
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"", (Throwable)e);
            e.printStackTrace(staticDebugOutput);
            System.exit(1);
        }
        catch (IOException e) {
            LOG.error((Object)"", (Throwable)e);
            e.printStackTrace(staticDebugOutput);
            System.exit(2);
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
            e.printStackTrace(staticDebugOutput);
            System.exit(3);
        }
    }

    abstract class SetField {
        LoggedTaskAttempt attempt;

        SetField(LoggedTaskAttempt attempt) {
            this.attempt = attempt;
        }

        abstract void set(long var1);
    }

    static enum JobOutcome {
        SUCCESS,
        FAILURE,
        OVERALL;

    }
}

