/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.tools.rumen.datatypes.AnonymizableDataType;
import org.apache.hadoop.tools.rumen.state.StatePool;

public class DefaultAnonymizingRumenSerializer
extends JsonSerializer<AnonymizableDataType> {
    private StatePool statePool;
    private Configuration conf;

    public DefaultAnonymizingRumenSerializer(StatePool statePool, Configuration conf) {
        this.statePool = statePool;
        this.conf = conf;
    }

    public void serialize(AnonymizableDataType object, JsonGenerator jGen, SerializerProvider sProvider) throws IOException, JsonProcessingException {
        Object val = object.getAnonymizedValue(this.statePool, this.conf);
        if (val instanceof String) {
            jGen.writeString(val.toString());
        } else {
            jGen.writeObject(val);
        }
    }
}

