/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.appmaster;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.sls.appmaster.TestAMSimulator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAMSimulator {
    private ResourceManager rm;
    private YarnConfiguration conf;

    @Before
    public void setup() {
        this.conf = new YarnConfiguration();
        this.conf.set("yarn.resourcemanager.scheduler.class", "org.apache.hadoop.yarn.sls.scheduler.ResourceSchedulerWrapper");
        this.conf.set("yarn.sls.scheduler.class", "org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler");
        this.conf.setBoolean("yarn.sls.metrics.switch", false);
        this.rm = new ResourceManager();
        this.rm.init((Configuration)this.conf);
        this.rm.start();
    }

    @Test
    public void testAMSimulator() throws Exception {
        MockAMSimulator app = new MockAMSimulator(this);
        ArrayList containers = new ArrayList();
        app.init(1, 1000, containers, this.rm, null, 0L, 1000000L, "user1", "default", false, "app1");
        app.firstStep();
        Assert.assertEquals((long)1L, (long)this.rm.getRMContext().getRMApps().size());
        Assert.assertNotNull(this.rm.getRMContext().getRMApps().get(app.appId));
        app.lastStep();
    }

    @After
    public void tearDown() {
        this.rm.stop();
    }
}

