/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.scheduler;

import com.codahale.metrics.Counter;
import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingWindowReservoir;
import com.codahale.metrics.Timer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.scheduler.CapacitySchedulerMetrics;
import org.apache.hadoop.yarn.sls.scheduler.FairSchedulerMetrics;
import org.apache.hadoop.yarn.sls.scheduler.FifoSchedulerMetrics;
import org.apache.hadoop.yarn.sls.scheduler.NodeUpdateSchedulerEventWrapper;
import org.apache.hadoop.yarn.sls.scheduler.RMNodeWrapper;
import org.apache.hadoop.yarn.sls.scheduler.ResourceSchedulerWrapper;
import org.apache.hadoop.yarn.sls.scheduler.SchedulerMetrics;
import org.apache.hadoop.yarn.sls.web.SLSWebApp;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.log4j.Logger;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ResourceSchedulerWrapper
extends AbstractYarnScheduler<SchedulerApplicationAttempt, SchedulerNode>
implements ResourceScheduler,
Configurable {
    private static final String EOL = System.getProperty("line.separator");
    private static final int SAMPLING_SIZE = 60;
    private ScheduledExecutorService pool;
    private Counter schedulerAllocateCounter;
    private Counter schedulerHandleCounter;
    private Map<SchedulerEventType, Counter> schedulerHandleCounterMap;
    private Timer schedulerAllocateTimer;
    private Timer schedulerHandleTimer;
    private Map<SchedulerEventType, Timer> schedulerHandleTimerMap;
    private List<Histogram> schedulerHistogramList;
    private Map<Histogram, Timer> histogramTimerMap;
    private Lock samplerLock;
    private Lock queueLock;
    private Configuration conf;
    private ResourceScheduler scheduler;
    private Map<ApplicationId, String> appQueueMap = new ConcurrentHashMap();
    private BufferedWriter jobRuntimeLogBW;
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private SLSWebApp web;
    private Map<ContainerId, Resource> preemptionContainerMap = new ConcurrentHashMap();
    private MetricRegistry metrics;
    private SchedulerMetrics schedulerMetrics;
    private boolean metricsON;
    private String metricsOutputDir;
    private BufferedWriter metricsLogBW;
    private boolean running = false;
    private static Map<Class, Class> defaultSchedulerMetricsMap = new HashMap();
    private Set<String> queueSet;
    private Set<String> trackedAppSet;
    public final Logger LOG = Logger.getLogger(ResourceSchedulerWrapper.class);

    public ResourceSchedulerWrapper() {
        super(ResourceSchedulerWrapper.class.getName());
        this.samplerLock = new ReentrantLock();
        this.queueLock = new ReentrantLock();
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        Class klass = conf.getClass("yarn.sls.scheduler.class", null, ResourceScheduler.class);
        this.scheduler = (ResourceScheduler)ReflectionUtils.newInstance((Class)klass, (Configuration)conf);
        this.metricsON = conf.getBoolean("yarn.sls.metrics.switch", true);
        if (this.metricsON) {
            try {
                this.initMetrics();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ShutdownHookManager.get().addShutdownHook((Runnable)new /* Unavailable Anonymous Inner Class!! */, 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Allocation allocate(ApplicationAttemptId attemptId, List<ResourceRequest> resourceRequests, List<ContainerId> containerIds, List<String> strings, List<String> strings2) {
        if (this.metricsON) {
            Timer.Context context = this.schedulerAllocateTimer.time();
            Allocation allocation = null;
            try {
                Allocation allocation2 = allocation = this.scheduler.allocate(attemptId, resourceRequests, containerIds, strings, strings2);
                return allocation2;
            }
            finally {
                context.stop();
                this.schedulerAllocateCounter.inc();
                try {
                    this.updateQueueWithAllocateRequest(allocation, attemptId, resourceRequests, containerIds);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.scheduler.allocate(attemptId, resourceRequests, containerIds, strings, strings2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(SchedulerEvent schedulerEvent) {
        AppAttemptRemovedSchedulerEvent appRemoveEvent;
        if (!this.metricsON) {
            this.scheduler.handle((Event)schedulerEvent);
            return;
        }
        if (!this.running) {
            this.running = true;
        }
        Timer.Context handlerTimer = null;
        Timer.Context operationTimer = null;
        try {
            if (schedulerEvent.getType() == SchedulerEventType.NODE_UPDATE && schedulerEvent instanceof NodeUpdateSchedulerEvent) {
                NodeUpdateSchedulerEventWrapper eventWrapper = new NodeUpdateSchedulerEventWrapper((NodeUpdateSchedulerEvent)schedulerEvent);
                schedulerEvent = eventWrapper;
                this.updateQueueWithNodeUpdate(eventWrapper);
            } else if (schedulerEvent.getType() == SchedulerEventType.APP_ATTEMPT_REMOVED && schedulerEvent instanceof AppAttemptRemovedSchedulerEvent) {
                appRemoveEvent = (AppAttemptRemovedSchedulerEvent)schedulerEvent;
                ApplicationAttemptId appAttemptId = appRemoveEvent.getApplicationAttemptID();
                String queue = (String)this.appQueueMap.get(appAttemptId.getApplicationId());
                SchedulerAppReport app = this.scheduler.getSchedulerAppInfo(appAttemptId);
                if (!app.getLiveContainers().isEmpty()) {
                    RMContainer rmc = (RMContainer)app.getLiveContainers().iterator().next();
                    this.updateQueueMetrics(queue, rmc.getContainer().getResource().getMemory(), rmc.getContainer().getResource().getVirtualCores());
                }
            }
            handlerTimer = this.schedulerHandleTimer.time();
            operationTimer = ((Timer)this.schedulerHandleTimerMap.get(schedulerEvent.getType())).time();
            this.scheduler.handle((Event)schedulerEvent);
        }
        finally {
            if (handlerTimer != null) {
                handlerTimer.stop();
            }
            if (operationTimer != null) {
                operationTimer.stop();
            }
            this.schedulerHandleCounter.inc();
            ((Counter)this.schedulerHandleCounterMap.get(schedulerEvent.getType())).inc();
            if (schedulerEvent.getType() == SchedulerEventType.APP_REMOVED && schedulerEvent instanceof AppRemovedSchedulerEvent) {
                SLSRunner.decreaseRemainingApps();
                appRemoveEvent = (AppRemovedSchedulerEvent)schedulerEvent;
                this.appQueueMap.remove(appRemoveEvent.getApplicationID());
            } else if (schedulerEvent.getType() == SchedulerEventType.APP_ADDED && schedulerEvent instanceof AppAddedSchedulerEvent) {
                AppAddedSchedulerEvent appAddEvent = (AppAddedSchedulerEvent)schedulerEvent;
                String queueName = appAddEvent.getQueue();
                this.appQueueMap.put(appAddEvent.getApplicationId(), queueName);
            }
        }
    }

    private void updateQueueWithNodeUpdate(NodeUpdateSchedulerEventWrapper eventWrapper) {
        RMNodeWrapper node = (RMNodeWrapper)eventWrapper.getRMNode();
        List containerList = node.getContainerUpdates();
        for (UpdatedContainerInfo info : containerList) {
            for (ContainerStatus status : info.getCompletedContainers()) {
                ContainerId containerId = status.getContainerId();
                SchedulerAppReport app = this.scheduler.getSchedulerAppInfo(containerId.getApplicationAttemptId());
                if (app == null) continue;
                String queue = (String)this.appQueueMap.get(containerId.getApplicationAttemptId().getApplicationId());
                int releasedMemory = 0;
                int releasedVCores = 0;
                if (status.getExitStatus() == 0) {
                    for (RMContainer rmc : app.getLiveContainers()) {
                        if (rmc.getContainerId() != containerId) continue;
                        releasedMemory += rmc.getContainer().getResource().getMemory();
                        releasedVCores += rmc.getContainer().getResource().getVirtualCores();
                        break;
                    }
                } else if (status.getExitStatus() == -100 && this.preemptionContainerMap.containsKey(containerId)) {
                    Resource preResource = (Resource)this.preemptionContainerMap.get(containerId);
                    releasedMemory += preResource.getMemory();
                    releasedVCores += preResource.getVirtualCores();
                    this.preemptionContainerMap.remove(containerId);
                }
                this.updateQueueMetrics(queue, releasedMemory, releasedVCores);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateQueueWithAllocateRequest(Allocation allocation, ApplicationAttemptId attemptId, List<ResourceRequest> resourceRequests, List<ContainerId> containerIds) throws IOException {
        Resource pendingResource = Resources.createResource((int)0, (int)0);
        Resource allocatedResource = Resources.createResource((int)0, (int)0);
        String queueName = (String)this.appQueueMap.get(attemptId.getApplicationId());
        for (ResourceRequest request : resourceRequests) {
            if (!request.getResourceName().equals("*")) continue;
            Resources.addTo((Resource)pendingResource, (Resource)Resources.multiply((Resource)request.getCapability(), (double)request.getNumContainers()));
        }
        for (Object container : allocation.getContainers()) {
            Resources.addTo((Resource)allocatedResource, (Resource)container.getResource());
            Resources.subtractFrom((Resource)pendingResource, (Resource)container.getResource());
        }
        SchedulerAppReport report = this.scheduler.getSchedulerAppInfo(attemptId);
        for (ContainerId containerId : containerIds) {
            Container container = null;
            for (Object c : report.getLiveContainers()) {
                if (!c.getContainerId().equals((Object)containerId)) continue;
                container = c.getContainer();
                break;
            }
            if (container != null) {
                Resources.subtractFrom((Resource)allocatedResource, (Resource)container.getResource());
                continue;
            }
            for (Object c : report.getReservedContainers()) {
                if (!c.getContainerId().equals((Object)containerId)) continue;
                container = c.getContainer();
                break;
            }
            if (container == null) continue;
            Resources.subtractFrom((Resource)pendingResource, (Resource)container.getResource());
        }
        HashSet preemptionContainers = new HashSet();
        if (allocation.getContainerPreemptions() != null) {
            preemptionContainers.addAll(allocation.getContainerPreemptions());
        }
        if (allocation.getStrictContainerPreemptions() != null) {
            preemptionContainers.addAll(allocation.getStrictContainerPreemptions());
        }
        if (!preemptionContainers.isEmpty()) {
            for (ContainerId containerId : preemptionContainers) {
                if (this.preemptionContainerMap.containsKey(containerId)) continue;
                Container container = null;
                for (RMContainer c : report.getLiveContainers()) {
                    if (!c.getContainerId().equals((Object)containerId)) continue;
                    container = c.getContainer();
                    break;
                }
                if (container == null) continue;
                this.preemptionContainerMap.put(containerId, container.getResource());
            }
        }
        SortedMap sortedMap = this.metrics.getCounters();
        String[] names = new String[]{"counter.queue." + queueName + ".pending.memory", "counter.queue." + queueName + ".pending.cores", "counter.queue." + queueName + ".allocated.memory", "counter.queue." + queueName + ".allocated.cores"};
        int[] values = new int[]{pendingResource.getMemory(), pendingResource.getVirtualCores(), allocatedResource.getMemory(), allocatedResource.getVirtualCores()};
        for (int i = names.length - 1; i >= 0; --i) {
            void var10_14;
            if (!var10_14.containsKey(names[i])) {
                this.metrics.counter(names[i]);
                SortedMap sortedMap2 = this.metrics.getCounters();
            }
            ((Counter)var10_14.get(names[i])).inc((long)values[i]);
        }
        this.queueLock.lock();
        try {
            if (!this.schedulerMetrics.isTracked(queueName)) {
                this.schedulerMetrics.trackQueue(queueName);
            }
        }
        finally {
            this.queueLock.unlock();
        }
    }

    private void tearDown() throws IOException {
        if (this.jobRuntimeLogBW != null) {
            this.jobRuntimeLogBW.close();
        }
        if (this.pool != null) {
            this.pool.shutdown();
        }
    }

    private void initMetrics() throws Exception {
        this.metrics = new MetricRegistry();
        this.metricsOutputDir = this.conf.get("yarn.sls.metrics.output");
        int metricsWebAddressPort = this.conf.getInt("yarn.sls.metrics.web.address.port", 10001);
        String schedulerMetricsType = this.conf.get(this.scheduler.getClass().getName());
        Class schedulerMetricsClass = schedulerMetricsType == null ? (Class)defaultSchedulerMetricsMap.get(this.scheduler.getClass()) : Class.forName(schedulerMetricsType);
        this.schedulerMetrics = (SchedulerMetrics)ReflectionUtils.newInstance((Class)schedulerMetricsClass, (Configuration)new Configuration());
        this.schedulerMetrics.init(this.scheduler, this.metrics);
        this.registerJvmMetrics();
        this.registerClusterResourceMetrics();
        this.registerContainerAppNumMetrics();
        this.registerSchedulerMetrics();
        this.initMetricsCSVOutput();
        this.web = new SLSWebApp(this, metricsWebAddressPort);
        this.web.start();
        this.pool = new ScheduledThreadPoolExecutor(2);
        this.pool.scheduleAtFixedRate((Runnable)new HistogramsRunnable(this), 0L, 1000L, TimeUnit.MILLISECONDS);
        this.pool.scheduleAtFixedRate((Runnable)new MetricsLogRunnable(this), 0L, 1000L, TimeUnit.MILLISECONDS);
        this.jobRuntimeLogBW = new BufferedWriter(new FileWriter(this.metricsOutputDir + "/jobruntime.csv"));
        this.jobRuntimeLogBW.write("JobID,real_start_time,real_end_time,simulate_start_time,simulate_end_time" + EOL);
        this.jobRuntimeLogBW.flush();
    }

    private void registerJvmMetrics() {
        this.metrics.register("variable.jvm.free.memory", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.jvm.max.memory", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.jvm.total.memory", (Metric)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void registerClusterResourceMetrics() {
        this.metrics.register("variable.cluster.allocated.memory", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.cluster.allocated.vcores", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.cluster.available.memory", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.cluster.available.vcores", (Metric)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void registerContainerAppNumMetrics() {
        this.metrics.register("variable.running.application", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.running.container", (Metric)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSchedulerMetrics() {
        this.samplerLock.lock();
        try {
            this.schedulerAllocateCounter = this.metrics.counter("counter.scheduler.operation.allocate");
            this.schedulerHandleCounter = this.metrics.counter("counter.scheduler.operation.handle");
            this.schedulerHandleCounterMap = new HashMap();
            for (SchedulerEventType e : SchedulerEventType.values()) {
                Counter counter = this.metrics.counter("counter.scheduler.operation.handle." + e);
                this.schedulerHandleCounterMap.put(e, counter);
            }
            int timeWindowSize = this.conf.getInt("yarn.sls.metrics.timer.window.size", 100);
            this.schedulerAllocateTimer = new Timer((Reservoir)new SlidingWindowReservoir(timeWindowSize));
            this.schedulerHandleTimer = new Timer((Reservoir)new SlidingWindowReservoir(timeWindowSize));
            this.schedulerHandleTimerMap = new HashMap();
            for (SchedulerEventType e : SchedulerEventType.values()) {
                Timer timer = new Timer((Reservoir)new SlidingWindowReservoir(timeWindowSize));
                this.schedulerHandleTimerMap.put(e, timer);
            }
            this.schedulerHistogramList = new ArrayList();
            this.histogramTimerMap = new HashMap();
            Histogram schedulerAllocateHistogram = new Histogram((Reservoir)new SlidingWindowReservoir(60));
            this.metrics.register("sampler.scheduler.operation.allocate.timecost", (Metric)schedulerAllocateHistogram);
            this.schedulerHistogramList.add(schedulerAllocateHistogram);
            this.histogramTimerMap.put(schedulerAllocateHistogram, this.schedulerAllocateTimer);
            Histogram schedulerHandleHistogram = new Histogram((Reservoir)new SlidingWindowReservoir(60));
            this.metrics.register("sampler.scheduler.operation.handle.timecost", (Metric)schedulerHandleHistogram);
            this.schedulerHistogramList.add(schedulerHandleHistogram);
            this.histogramTimerMap.put(schedulerHandleHistogram, this.schedulerHandleTimer);
            for (SchedulerEventType e : SchedulerEventType.values()) {
                Histogram histogram = new Histogram((Reservoir)new SlidingWindowReservoir(60));
                this.metrics.register("sampler.scheduler.operation.handle." + e + ".timecost", (Metric)histogram);
                this.schedulerHistogramList.add(histogram);
                this.histogramTimerMap.put(histogram, this.schedulerHandleTimerMap.get(e));
            }
        }
        finally {
            this.samplerLock.unlock();
        }
    }

    private void initMetricsCSVOutput() {
        int timeIntervalMS = this.conf.getInt("yarn.sls.metrics.record.interval.ms", 1000);
        File dir = new File(this.metricsOutputDir + "/metrics");
        if (!dir.exists() && !dir.mkdirs()) {
            this.LOG.error((Object)("Cannot create directory " + dir.getAbsoluteFile()));
        }
        CsvReporter reporter = CsvReporter.forRegistry((MetricRegistry)this.metrics).formatFor(Locale.US).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(new File(this.metricsOutputDir + "/metrics"));
        reporter.start((long)timeIntervalMS, TimeUnit.MILLISECONDS);
    }

    public void addAMRuntime(ApplicationId appId, long traceStartTimeMS, long traceEndTimeMS, long simulateStartTimeMS, long simulateEndTimeMS) {
        if (this.metricsON) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(appId).append(",").append(traceStartTimeMS).append(",").append(traceEndTimeMS).append(",").append(simulateStartTimeMS).append(",").append(simulateEndTimeMS);
                this.jobRuntimeLogBW.write(sb.toString() + EOL);
                this.jobRuntimeLogBW.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void updateQueueMetrics(String queue, int releasedMemory, int releasedVCores) {
        String name;
        SortedMap counterMap = this.metrics.getCounters();
        if (releasedMemory != 0) {
            name = "counter.queue." + queue + ".allocated.memory";
            if (!counterMap.containsKey(name)) {
                this.metrics.counter(name);
                counterMap = this.metrics.getCounters();
            }
            ((Counter)counterMap.get(name)).inc((long)(-releasedMemory));
        }
        if (releasedVCores != 0) {
            name = "counter.queue." + queue + ".allocated.cores";
            if (!counterMap.containsKey(name)) {
                this.metrics.counter(name);
                counterMap = this.metrics.getCounters();
            }
            ((Counter)counterMap.get(name)).inc((long)(-releasedVCores));
        }
    }

    public void setQueueSet(Set<String> queues) {
        this.queueSet = queues;
    }

    public Set<String> getQueueSet() {
        return this.queueSet;
    }

    public void setTrackedAppSet(Set<String> apps) {
        this.trackedAppSet = apps;
    }

    public Set<String> getTrackedAppSet() {
        return this.trackedAppSet;
    }

    public MetricRegistry getMetrics() {
        return this.metrics;
    }

    public SchedulerMetrics getSchedulerMetrics() {
        return this.schedulerMetrics;
    }

    public void addTrackedApp(ApplicationAttemptId appAttemptId, String oldAppId) {
        if (this.metricsON) {
            this.schedulerMetrics.trackApp(appAttemptId, oldAppId);
        }
    }

    public void removeTrackedApp(ApplicationAttemptId appAttemptId, String oldAppId) {
        if (this.metricsON) {
            this.schedulerMetrics.untrackApp(appAttemptId, oldAppId);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void serviceInit(Configuration conf) throws Exception {
        ((AbstractYarnScheduler)this.scheduler).init(conf);
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        ((AbstractYarnScheduler)this.scheduler).start();
        super.serviceStart();
    }

    public void serviceStop() throws Exception {
        ((AbstractYarnScheduler)this.scheduler).stop();
        super.serviceStop();
    }

    public void setRMContext(RMContext rmContext) {
        this.scheduler.setRMContext(rmContext);
    }

    public void reinitialize(Configuration conf, RMContext rmContext) throws IOException {
        this.scheduler.reinitialize(conf, rmContext);
    }

    public void recover(RMStateStore.RMState rmState) throws Exception {
        this.scheduler.recover(rmState);
    }

    public QueueInfo getQueueInfo(String s, boolean b, boolean b2) throws IOException {
        return this.scheduler.getQueueInfo(s, b, b2);
    }

    public List<QueueUserACLInfo> getQueueUserAclInfo() {
        return this.scheduler.getQueueUserAclInfo();
    }

    public Resource getMinimumResourceCapability() {
        return this.scheduler.getMinimumResourceCapability();
    }

    public Resource getMaximumResourceCapability() {
        return this.scheduler.getMaximumResourceCapability();
    }

    public ResourceCalculator getResourceCalculator() {
        return this.scheduler.getResourceCalculator();
    }

    public int getNumClusterNodes() {
        return this.scheduler.getNumClusterNodes();
    }

    public SchedulerNodeReport getNodeReport(NodeId nodeId) {
        return this.scheduler.getNodeReport(nodeId);
    }

    public SchedulerAppReport getSchedulerAppInfo(ApplicationAttemptId attemptId) {
        return this.scheduler.getSchedulerAppInfo(attemptId);
    }

    public QueueMetrics getRootQueueMetrics() {
        return this.scheduler.getRootQueueMetrics();
    }

    public synchronized boolean checkAccess(UserGroupInformation callerUGI, QueueACL acl, String queueName) {
        return this.scheduler.checkAccess(callerUGI, acl, queueName);
    }

    public ApplicationResourceUsageReport getAppResourceUsageReport(ApplicationAttemptId appAttemptId) {
        return this.scheduler.getAppResourceUsageReport(appAttemptId);
    }

    public List<ApplicationAttemptId> getAppsInQueue(String queue) {
        return this.scheduler.getAppsInQueue(queue);
    }

    public RMContainer getRMContainer(ContainerId containerId) {
        return null;
    }

    public String moveApplication(ApplicationId appId, String newQueue) throws YarnException {
        return this.scheduler.moveApplication(appId, newQueue);
    }

    @InterfaceAudience.LimitedPrivate(value={"yarn"})
    @InterfaceStability.Unstable
    public Resource getClusterResource() {
        return null;
    }

    public synchronized List<Container> getTransferredContainers(ApplicationAttemptId currentAttempt) {
        return new ArrayList<Container>();
    }

    public Map<ApplicationId, SchedulerApplication<SchedulerApplicationAttempt>> getSchedulerApplications() {
        return new HashMap<ApplicationId, SchedulerApplication<SchedulerApplicationAttempt>>();
    }

    protected void completedContainer(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
    }

    static /* synthetic */ BufferedWriter access$000(ResourceSchedulerWrapper x0) {
        return x0.metricsLogBW;
    }

    static /* synthetic */ SLSWebApp access$100(ResourceSchedulerWrapper x0) {
        return x0.web;
    }

    static /* synthetic */ void access$200(ResourceSchedulerWrapper x0) throws IOException {
        x0.tearDown();
    }

    static /* synthetic */ ResourceScheduler access$300(ResourceSchedulerWrapper x0) {
        return x0.scheduler;
    }

    static /* synthetic */ Lock access$400(ResourceSchedulerWrapper x0) {
        return x0.samplerLock;
    }

    static /* synthetic */ List access$500(ResourceSchedulerWrapper x0) {
        return x0.schedulerHistogramList;
    }

    static /* synthetic */ Map access$600(ResourceSchedulerWrapper x0) {
        return x0.histogramTimerMap;
    }

    static /* synthetic */ BufferedWriter access$002(ResourceSchedulerWrapper x0, BufferedWriter x1) {
        x0.metricsLogBW = x1;
        return x0.metricsLogBW;
    }

    static /* synthetic */ String access$700(ResourceSchedulerWrapper x0) {
        return x0.metricsOutputDir;
    }

    static /* synthetic */ boolean access$800(ResourceSchedulerWrapper x0) {
        return x0.running;
    }

    static /* synthetic */ String access$900() {
        return EOL;
    }

    static {
        defaultSchedulerMetricsMap.put(FairScheduler.class, FairSchedulerMetrics.class);
        defaultSchedulerMetricsMap.put(FifoScheduler.class, FifoSchedulerMetrics.class);
        defaultSchedulerMetricsMap.put(CapacityScheduler.class, CapacitySchedulerMetrics.class);
    }
}

