/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.scheduler;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.yarn.sls.scheduler.TaskRunner;
import org.apache.hadoop.yarn.sls.scheduler.TestTaskRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTaskRunner {
    private TaskRunner runner;

    @Before
    public void setUp() {
        this.runner = new TaskRunner();
        this.runner.setQueueSize(5);
    }

    @After
    public void cleanUp() {
        this.runner.stop();
    }

    @Test
    public void testSingleTask() throws Exception {
        this.runner.start();
        this.runner.schedule((TaskRunner.Task)new SingleTask(0L));
        SingleTask.latch.await(5000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)SingleTask.first);
    }

    @Test
    public void testDualTask() throws Exception {
        this.runner.start();
        this.runner.schedule((TaskRunner.Task)new DualTask(0L, 10L, 10L));
        DualTask.latch.await(5000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)DualTask.first);
        Assert.assertTrue((boolean)DualTask.last);
    }

    @Test
    public void testTriTask() throws Exception {
        this.runner.start();
        this.runner.schedule((TaskRunner.Task)new TriTask(0L, 10L, 5L));
        TriTask.latch.await(5000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)TriTask.first);
        Assert.assertTrue((boolean)TriTask.middle);
        Assert.assertTrue((boolean)TriTask.last);
    }

    @Test
    public void testMultiTask() throws Exception {
        this.runner.start();
        this.runner.schedule((TaskRunner.Task)new MultiTask(0L, 20L, 5L));
        MultiTask.latch.await(5000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)MultiTask.first);
        Assert.assertEquals((long)3L, (long)MultiTask.middle);
        Assert.assertTrue((boolean)MultiTask.last);
    }

    @Test
    public void testPreStartQueueing() throws Exception {
        this.runner.schedule((TaskRunner.Task)new PreStartTask(210L));
        Thread.sleep(210L);
        this.runner.start();
        long startedAt = System.currentTimeMillis();
        PreStartTask.latch.await(5000L, TimeUnit.MILLISECONDS);
        long runAt = System.currentTimeMillis();
        Assert.assertTrue((boolean)PreStartTask.first);
        Assert.assertTrue((runAt - startedAt >= 200L ? 1 : 0) != 0);
    }
}

