/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.nodemanager;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NodeInfo {
    private static int NODE_ID = 0;

    public static NodeId newNodeID(String host, int port) {
        return NodeId.newInstance((String)host, (int)port);
    }

    public static RMNode newNodeInfo(String rackName, String hostName, Resource resource, int port) {
        NodeId nodeId = NodeInfo.newNodeID(hostName, port);
        String nodeAddr = hostName + ":" + port;
        String httpAddress = hostName;
        return new FakeRMNodeImpl(nodeId, nodeAddr, httpAddress, resource, rackName, "Me good", port, hostName, null);
    }

    public static RMNode newNodeInfo(String rackName, String hostName, Resource resource) {
        return NodeInfo.newNodeInfo(rackName, hostName, resource, NODE_ID++);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    private static class FakeRMNodeImpl
    implements RMNode {
        private NodeId nodeId;
        private String hostName;
        private String nodeAddr;
        private String httpAddress;
        private int cmdPort;
        private volatile Resource perNode;
        private String rackName;
        private String healthReport;
        private NodeState state;
        private List<ContainerId> toCleanUpContainers;
        private List<ApplicationId> toCleanUpApplications;

        public FakeRMNodeImpl(NodeId nodeId, String nodeAddr, String httpAddress, Resource perNode, String rackName, String healthReport, int cmdPort, String hostName, NodeState state) {
            this.nodeId = nodeId;
            this.nodeAddr = nodeAddr;
            this.httpAddress = httpAddress;
            this.perNode = perNode;
            this.rackName = rackName;
            this.healthReport = healthReport;
            this.cmdPort = cmdPort;
            this.hostName = hostName;
            this.state = state;
            this.toCleanUpApplications = new ArrayList<ApplicationId>();
            this.toCleanUpContainers = new ArrayList<ContainerId>();
        }

        public NodeId getNodeID() {
            return this.nodeId;
        }

        public String getHostName() {
            return this.hostName;
        }

        public int getCommandPort() {
            return this.cmdPort;
        }

        public int getHttpPort() {
            return 0;
        }

        public String getNodeAddress() {
            return this.nodeAddr;
        }

        public String getHttpAddress() {
            return this.httpAddress;
        }

        public String getHealthReport() {
            return this.healthReport;
        }

        public long getLastHealthReportTime() {
            return 0L;
        }

        public Resource getTotalCapability() {
            return this.perNode;
        }

        public String getRackName() {
            return this.rackName;
        }

        public Node getNode() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public NodeState getState() {
            return this.state;
        }

        public List<ContainerId> getContainersToCleanUp() {
            return this.toCleanUpContainers;
        }

        public List<ApplicationId> getAppsToCleanup() {
            return this.toCleanUpApplications;
        }

        public void updateNodeHeartbeatResponseForCleanup(NodeHeartbeatResponse response) {
        }

        public NodeHeartbeatResponse getLastNodeHeartBeatResponse() {
            return null;
        }

        public void resetLastNodeHeartBeatResponse() {
        }

        public List<UpdatedContainerInfo> pullContainerUpdates() {
            ArrayList<UpdatedContainerInfo> list = new ArrayList<UpdatedContainerInfo>();
            ArrayList<ContainerStatus> list2 = new ArrayList<ContainerStatus>();
            for (ContainerId cId : this.toCleanUpContainers) {
                list2.add(ContainerStatus.newInstance((ContainerId)cId, (ContainerState)ContainerState.RUNNING, (String)"", (int)0));
            }
            list.add(new UpdatedContainerInfo(new ArrayList(), list2));
            return list;
        }

        public String getNodeManagerVersion() {
            return null;
        }

        public Set<String> getNodeLabels() {
            return RMNodeLabelsManager.EMPTY_STRING_SET;
        }
    }
}

