/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.scheduler;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerUpdates;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.scheduler.NodeUpdateSchedulerEventWrapper;
import org.apache.hadoop.yarn.sls.scheduler.RMNodeWrapper;
import org.apache.hadoop.yarn.sls.scheduler.SchedulerMetrics;
import org.apache.hadoop.yarn.sls.scheduler.SchedulerWrapper;
import org.apache.hadoop.yarn.sls.scheduler.Tracker;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SLSFairScheduler
extends FairScheduler
implements SchedulerWrapper,
Configurable {
    private SchedulerMetrics schedulerMetrics;
    private boolean metricsON;
    private Tracker tracker;
    private Map<ContainerId, Resource> preemptionContainerMap = new ConcurrentHashMap<ContainerId, Resource>();

    @Override
    public SchedulerMetrics getSchedulerMetrics() {
        return this.schedulerMetrics;
    }

    @Override
    public Tracker getTracker() {
        return this.tracker;
    }

    public SLSFairScheduler() {
        this.tracker = new Tracker();
    }

    public void setConf(Configuration conf) {
        super.setConfig(conf);
        this.metricsON = conf.getBoolean("yarn.sls.metrics.switch", true);
        if (this.metricsON) {
            try {
                this.schedulerMetrics = SchedulerMetrics.getInstance(conf, FairScheduler.class);
                this.schedulerMetrics.init((ResourceScheduler)this, conf);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Allocation allocate(ApplicationAttemptId attemptId, List<ResourceRequest> resourceRequests, List<SchedulingRequest> schedulingRequests, List<ContainerId> containerIds, List<String> blacklistAdditions, List<String> blacklistRemovals, ContainerUpdates updateRequests) {
        if (this.metricsON) {
            Timer.Context context = this.schedulerMetrics.getSchedulerAllocateTimer().time();
            Allocation allocation = null;
            try {
                Allocation allocation2 = allocation = super.allocate(attemptId, resourceRequests, schedulingRequests, containerIds, blacklistAdditions, blacklistRemovals, updateRequests);
                return allocation2;
            }
            finally {
                context.stop();
                this.schedulerMetrics.increaseSchedulerAllocationCounter();
                try {
                    this.updateQueueWithAllocateRequest(allocation, attemptId, resourceRequests, containerIds);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return super.allocate(attemptId, resourceRequests, schedulingRequests, containerIds, blacklistAdditions, blacklistRemovals, updateRequests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(SchedulerEvent schedulerEvent) {
        if (!this.metricsON) {
            super.handle(schedulerEvent);
            return;
        }
        if (!this.schedulerMetrics.isRunning()) {
            this.schedulerMetrics.setRunning(true);
        }
        Timer.Context handlerTimer = null;
        Timer.Context operationTimer = null;
        try {
            if (schedulerEvent.getType() == SchedulerEventType.NODE_UPDATE && schedulerEvent instanceof NodeUpdateSchedulerEvent) {
                NodeUpdateSchedulerEventWrapper eventWrapper = new NodeUpdateSchedulerEventWrapper((NodeUpdateSchedulerEvent)schedulerEvent);
                schedulerEvent = eventWrapper;
                this.updateQueueWithNodeUpdate(eventWrapper);
            } else if (schedulerEvent.getType() == SchedulerEventType.APP_ATTEMPT_REMOVED && schedulerEvent instanceof AppAttemptRemovedSchedulerEvent) {
                AppAttemptRemovedSchedulerEvent appRemoveEvent = (AppAttemptRemovedSchedulerEvent)schedulerEvent;
                ApplicationAttemptId appAttemptId = appRemoveEvent.getApplicationAttemptID();
                String queueName = this.getSchedulerApp(appAttemptId).getQueue().getName();
                SchedulerAppReport app = this.getSchedulerAppInfo(appAttemptId);
                if (!app.getLiveContainers().isEmpty()) {
                    RMContainer rmc = (RMContainer)app.getLiveContainers().iterator().next();
                    this.schedulerMetrics.updateQueueMetricsByRelease(rmc.getContainer().getResource(), queueName);
                }
            }
            handlerTimer = this.schedulerMetrics.getSchedulerHandleTimer().time();
            operationTimer = this.schedulerMetrics.getSchedulerHandleTimer((SchedulerEventType)schedulerEvent.getType()).time();
            super.handle(schedulerEvent);
        }
        finally {
            if (handlerTimer != null) {
                handlerTimer.stop();
            }
            if (operationTimer != null) {
                operationTimer.stop();
            }
            this.schedulerMetrics.increaseSchedulerHandleCounter((SchedulerEventType)schedulerEvent.getType());
            if (schedulerEvent.getType() == SchedulerEventType.APP_ATTEMPT_REMOVED && schedulerEvent instanceof AppAttemptRemovedSchedulerEvent) {
                SLSRunner.decreaseRemainingApps();
            }
        }
    }

    private void updateQueueWithNodeUpdate(NodeUpdateSchedulerEventWrapper eventWrapper) {
        RMNodeWrapper node = (RMNodeWrapper)eventWrapper.getRMNode();
        List<UpdatedContainerInfo> containerList = node.getContainerUpdates();
        for (UpdatedContainerInfo info : containerList) {
            for (ContainerStatus status : info.getCompletedContainers()) {
                ContainerId containerId = status.getContainerId();
                SchedulerAppReport app = super.getSchedulerAppInfo(containerId.getApplicationAttemptId());
                if (app == null) continue;
                int releasedMemory = 0;
                int releasedVCores = 0;
                if (status.getExitStatus() == 0) {
                    for (RMContainer rmc : app.getLiveContainers()) {
                        if (rmc.getContainerId() != containerId) continue;
                        Resource resource = rmc.getContainer().getResource();
                        releasedMemory = (int)((long)releasedMemory + resource.getMemorySize());
                        releasedVCores += resource.getVirtualCores();
                        break;
                    }
                } else if (status.getExitStatus() == -100 && this.preemptionContainerMap.containsKey(containerId)) {
                    Resource preResource = this.preemptionContainerMap.get(containerId);
                    releasedMemory = (int)((long)releasedMemory + preResource.getMemorySize());
                    releasedVCores += preResource.getVirtualCores();
                    this.preemptionContainerMap.remove(containerId);
                }
                String queue = this.getSchedulerApp(containerId.getApplicationAttemptId()).getQueueName();
                this.schedulerMetrics.updateQueueMetricsByRelease(Resource.newInstance((int)releasedMemory, (int)releasedVCores), queue);
            }
        }
    }

    private void updateQueueWithAllocateRequest(Allocation allocation, ApplicationAttemptId attemptId, List<ResourceRequest> resourceRequests, List<ContainerId> containerIds) throws IOException {
        Resource pendingResource = Resources.createResource((int)0, (int)0);
        Resource allocatedResource = Resources.createResource((int)0, (int)0);
        for (ResourceRequest request : resourceRequests) {
            if (!request.getResourceName().equals("*")) continue;
            Resources.addTo((Resource)pendingResource, (Resource)Resources.multiply((Resource)request.getCapability(), (double)request.getNumContainers()));
        }
        for (Object container : allocation.getContainers()) {
            Resources.addTo((Resource)allocatedResource, (Resource)container.getResource());
            Resources.subtractFrom((Resource)pendingResource, (Resource)container.getResource());
        }
        SchedulerAppReport report = super.getSchedulerAppInfo(attemptId);
        for (ContainerId containerId : containerIds) {
            Container container = null;
            for (RMContainer c : report.getLiveContainers()) {
                if (!c.getContainerId().equals((Object)containerId)) continue;
                container = c.getContainer();
                break;
            }
            if (container != null) {
                Resources.subtractFrom((Resource)allocatedResource, (Resource)container.getResource());
                continue;
            }
            for (RMContainer c : report.getReservedContainers()) {
                if (!c.getContainerId().equals((Object)containerId)) continue;
                container = c.getContainer();
                break;
            }
            if (container == null) continue;
            Resources.subtractFrom((Resource)pendingResource, (Resource)container.getResource());
        }
        HashSet preemptionContainers = new HashSet();
        if (allocation.getContainerPreemptions() != null) {
            preemptionContainers.addAll(allocation.getContainerPreemptions());
        }
        if (allocation.getStrictContainerPreemptions() != null) {
            preemptionContainers.addAll(allocation.getStrictContainerPreemptions());
        }
        if (!preemptionContainers.isEmpty()) {
            for (ContainerId containerId : preemptionContainers) {
                if (this.preemptionContainerMap.containsKey(containerId)) continue;
                Container container = null;
                for (RMContainer c : report.getLiveContainers()) {
                    if (!c.getContainerId().equals((Object)containerId)) continue;
                    container = c.getContainer();
                    break;
                }
                if (container == null) continue;
                this.preemptionContainerMap.put(containerId, container.getResource());
            }
        }
        String string = this.getSchedulerApp(attemptId).getQueueName();
        this.schedulerMetrics.updateQueueMetrics(pendingResource, allocatedResource, string);
    }

    public void serviceStop() throws Exception {
        try {
            if (this.metricsON) {
                this.schedulerMetrics.tearDown();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.serviceStop();
    }

    @Override
    public String getRealQueueName(String queue) throws YarnException {
        if (!this.getQueueManager().exists(queue)) {
            throw new YarnException("Can't find the queue by the given name: " + queue + "! Please check if queue " + queue + " is in the allocation file.");
        }
        return this.getQueueManager().getQueue(queue).getQueueName();
    }
}

