/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.appmaster;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.sls.ReservationClientUtil;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.appmaster.AMSimulator;
import org.apache.hadoop.yarn.sls.scheduler.ContainerSimulator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class MRAMSimulator
extends AMSimulator {
    public static final String MAP_TYPE = "map";
    public static final String REDUCE_TYPE = "reduce";
    private static final int PRIORITY_REDUCE = 10;
    private static final int PRIORITY_MAP = 20;
    private LinkedList<ContainerSimulator> pendingMaps = new LinkedList();
    private LinkedList<ContainerSimulator> pendingFailedMaps = new LinkedList();
    private LinkedList<ContainerSimulator> scheduledMaps = new LinkedList();
    private Map<ContainerId, ContainerSimulator> assignedMaps = new HashMap<ContainerId, ContainerSimulator>();
    private LinkedList<ContainerSimulator> pendingReduces = new LinkedList();
    private LinkedList<ContainerSimulator> pendingFailedReduces = new LinkedList();
    private LinkedList<ContainerSimulator> scheduledReduces = new LinkedList();
    private Map<ContainerId, ContainerSimulator> assignedReduces = new HashMap<ContainerId, ContainerSimulator>();
    private LinkedList<ContainerSimulator> allMaps = new LinkedList();
    private LinkedList<ContainerSimulator> allReduces = new LinkedList();
    private int mapFinished = 0;
    private int mapTotal = 0;
    private int reduceFinished = 0;
    private int reduceTotal = 0;
    private boolean isFinished = false;
    private static final Logger LOG = LoggerFactory.getLogger(MRAMSimulator.class);

    @Override
    public void init(int heartbeatInterval, List<ContainerSimulator> containerList, ResourceManager rm, SLSRunner se, long traceStartTime, long traceFinishTime, String user, String queue, boolean isTracked, String oldAppId, long baselineStartTimeMS, Resource amContainerResource, Map<String, String> params, Map<ApplicationId, AMSimulator> appIdAMSim) {
        super.init(heartbeatInterval, containerList, rm, se, traceStartTime, traceFinishTime, user, queue, isTracked, oldAppId, baselineStartTimeMS, amContainerResource, params, appIdAMSim);
        this.amtype = "mapreduce";
        for (ContainerSimulator cs : containerList) {
            if (cs.getType().equals(MAP_TYPE)) {
                cs.setPriority(20);
                this.allMaps.add(cs);
                continue;
            }
            if (!cs.getType().equals(REDUCE_TYPE)) continue;
            cs.setPriority(10);
            this.allReduces.add(cs);
        }
        LOG.info("Added new job with {} mapper and {} reducers", (Object)this.allMaps.size(), (Object)this.allReduces.size());
        this.mapTotal = this.allMaps.size();
        this.reduceTotal = this.allReduces.size();
        this.totalContainers = this.mapTotal + this.reduceTotal;
    }

    @Override
    public synchronized void notifyAMContainerLaunched(Container masterContainer) throws Exception {
        if (null != masterContainer) {
            this.restart();
            super.notifyAMContainerLaunched(masterContainer);
        }
    }

    @Override
    protected void processResponseQueue() throws Exception {
        while (!this.responseQueue.isEmpty()) {
            AllocateResponse response = (AllocateResponse)this.responseQueue.take();
            if (!response.getCompletedContainersStatuses().isEmpty()) {
                for (ContainerStatus cs : response.getCompletedContainersStatuses()) {
                    ContainerId containerId = cs.getContainerId();
                    if (cs.getExitStatus() == 0) {
                        if (this.assignedMaps.containsKey(containerId)) {
                            LOG.debug("Application {} has one mapper finished ({}).", (Object)this.appId, (Object)containerId);
                            this.assignedMaps.remove(containerId);
                            ++this.mapFinished;
                            ++this.finishedContainers;
                        } else if (this.assignedReduces.containsKey(containerId)) {
                            LOG.debug("Application {} has one reducer finished ({}).", (Object)this.appId, (Object)containerId);
                            this.assignedReduces.remove(containerId);
                            ++this.reduceFinished;
                            ++this.finishedContainers;
                        } else if (this.amContainer.getId().equals((Object)containerId)) {
                            this.isFinished = true;
                            LOG.info("Application {} goes to finish.", (Object)this.appId);
                        }
                        if (this.mapFinished < this.mapTotal || this.reduceFinished < this.reduceTotal) continue;
                        this.lastStep();
                        continue;
                    }
                    if (this.assignedMaps.containsKey(containerId)) {
                        LOG.debug("Application {} has one mapper killed ({}).", (Object)this.appId, (Object)containerId);
                        this.pendingFailedMaps.add(this.assignedMaps.remove(containerId));
                        continue;
                    }
                    if (this.assignedReduces.containsKey(containerId)) {
                        LOG.debug("Application {} has one reducer killed ({}).", (Object)this.appId, (Object)containerId);
                        this.pendingFailedReduces.add(this.assignedReduces.remove(containerId));
                        continue;
                    }
                    if (!this.amContainer.getId().equals((Object)containerId)) continue;
                    LOG.info("Application {}'s AM is going to be killed. Waiting for rescheduling...", (Object)this.appId);
                }
            }
            if (this.isAMContainerRunning && this.mapFinished >= this.mapTotal && this.reduceFinished >= this.reduceTotal) {
                this.isAMContainerRunning = false;
                LOG.debug("Application {} sends out event to clean up its AM container.", (Object)this.appId);
                this.isFinished = true;
                break;
            }
            for (Container container : response.getAllocatedContainers()) {
                ContainerSimulator cs;
                if (!this.scheduledMaps.isEmpty()) {
                    cs = this.scheduledMaps.remove();
                    LOG.debug("Application {} starts to launch a mapper ({}).", (Object)this.appId, (Object)container.getId());
                    this.assignedMaps.put(container.getId(), cs);
                    this.se.getNmMap().get(container.getNodeId()).addNewContainer(container, cs.getLifeTime());
                    continue;
                }
                if (this.scheduledReduces.isEmpty()) continue;
                cs = this.scheduledReduces.remove();
                LOG.debug("Application {} starts to launch a reducer ({}).", (Object)this.appId, (Object)container.getId());
                this.assignedReduces.put(container.getId(), cs);
                this.se.getNmMap().get(container.getNodeId()).addNewContainer(container, cs.getLifeTime());
            }
        }
    }

    private void restart() throws YarnException, IOException, InterruptedException {
        this.isFinished = false;
        this.pendingFailedMaps.clear();
        this.pendingMaps.clear();
        this.pendingReduces.clear();
        this.pendingFailedReduces.clear();
        int added = 0;
        for (ContainerSimulator cs : this.allMaps) {
            if (added >= this.mapTotal - this.mapFinished) break;
            this.pendingMaps.add(cs);
        }
        added = 0;
        for (ContainerSimulator cs : this.allReduces) {
            if (added >= this.reduceTotal - this.reduceFinished) break;
            this.pendingReduces.add(cs);
        }
        this.amContainer = null;
    }

    private List<ContainerSimulator> mergeLists(List<ContainerSimulator> left, List<ContainerSimulator> right) {
        ArrayList<ContainerSimulator> list = new ArrayList<ContainerSimulator>();
        list.addAll(left);
        list.addAll(right);
        return list;
    }

    @Override
    protected void sendContainerRequest() throws YarnException, IOException, InterruptedException {
        if (this.isFinished) {
            return;
        }
        List<Object> ask = null;
        if (this.mapFinished != this.mapTotal) {
            if (!this.pendingMaps.isEmpty()) {
                ask = this.packageRequests(this.mergeLists(this.pendingMaps, this.scheduledMaps), 20);
                LOG.debug("Application {} sends out request for {} mappers.", (Object)this.appId, (Object)this.pendingMaps.size());
                this.scheduledMaps.addAll(this.pendingMaps);
                this.pendingMaps.clear();
            } else if (!this.pendingFailedMaps.isEmpty()) {
                ask = this.packageRequests(this.mergeLists(this.pendingFailedMaps, this.scheduledMaps), 20);
                LOG.debug("Application {} sends out requests for {} failed mappers.", (Object)this.appId, (Object)this.pendingFailedMaps.size());
                this.scheduledMaps.addAll(this.pendingFailedMaps);
                this.pendingFailedMaps.clear();
            }
        } else if (this.reduceFinished != this.reduceTotal) {
            if (!this.pendingReduces.isEmpty()) {
                ask = this.packageRequests(this.mergeLists(this.pendingReduces, this.scheduledReduces), 10);
                LOG.debug("Application {} sends out requests for {} reducers.", (Object)this.appId, (Object)this.pendingReduces.size());
                this.scheduledReduces.addAll(this.pendingReduces);
                this.pendingReduces.clear();
            } else if (!this.pendingFailedReduces.isEmpty()) {
                ask = this.packageRequests(this.mergeLists(this.pendingFailedReduces, this.scheduledReduces), 10);
                LOG.debug("Application {} sends out request for {} failed reducers.", (Object)this.appId, (Object)this.pendingFailedReduces.size());
                this.scheduledReduces.addAll(this.pendingFailedReduces);
                this.pendingFailedReduces.clear();
            }
        }
        if (ask == null) {
            ask = new ArrayList();
        }
        final AllocateRequest request = this.createAllocateRequest(ask);
        if (this.totalContainers == 0) {
            request.setProgress(1.0f);
        } else {
            request.setProgress((float)this.finishedContainers / (float)this.totalContainers);
        }
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)this.appAttemptId.toString());
        Token token = ((RMApp)this.rm.getRMContext().getRMApps().get(this.appAttemptId.getApplicationId())).getRMAppAttempt(this.appAttemptId).getAMRMToken();
        ugi.addTokenIdentifier(token.decodeIdentifier());
        AllocateResponse response = (AllocateResponse)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<AllocateResponse>(){

            @Override
            public AllocateResponse run() throws Exception {
                return MRAMSimulator.this.rm.getApplicationMasterService().allocate(request);
            }
        });
        if (response != null) {
            this.responseQueue.put(response);
        }
    }

    @Override
    public void initReservation(ReservationId reservationId, long deadline, long now) {
        Resource mapRes = this.getMaxResource(this.allMaps);
        long mapDur = this.getMaxDuration(this.allMaps);
        Resource redRes = this.getMaxResource(this.allReduces);
        long redDur = this.getMaxDuration(this.allReduces);
        ReservationSubmissionRequest rr = ReservationClientUtil.createMRReservation(reservationId, "reservation_" + reservationId.getId(), mapRes, this.allMaps.size(), mapDur, redRes, this.allReduces.size(), redDur, now + this.traceStartTimeMS, now + deadline, this.queue);
        this.setReservationRequest(rr);
    }

    private Resource getMaxResource(Collection<ContainerSimulator> containers) {
        return containers.parallelStream().map(ContainerSimulator::getResource).reduce(Resource.newInstance((int)0, (int)0), Resources::componentwiseMax);
    }

    private long getMaxDuration(Collection<ContainerSimulator> containers) {
        return containers.parallelStream().mapToLong(ContainerSimulator::getLifeTime).reduce(0L, Long::max);
    }

    @Override
    protected void checkStop() {
        if (this.isFinished) {
            super.setEndTime(System.currentTimeMillis());
        }
    }

    @Override
    public void lastStep() throws Exception {
        super.lastStep();
        this.allMaps.clear();
        this.allReduces.clear();
        this.assignedMaps.clear();
        this.assignedReduces.clear();
        this.pendingFailedMaps.clear();
        this.pendingFailedReduces.clear();
        this.pendingMaps.clear();
        this.pendingReduces.clear();
        this.scheduledMaps.clear();
        this.scheduledReduces.clear();
        this.responseQueue.clear();
    }
}

