/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming.io;

import java.io.DataInput;
import java.io.IOException;
import org.apache.hadoop.streaming.PipeMapRed;
import org.apache.hadoop.streaming.io.OutputReader;
import org.apache.hadoop.typedbytes.TypedBytesInput;
import org.apache.hadoop.typedbytes.TypedBytesWritable;

public class TypedBytesOutputReader
extends OutputReader<TypedBytesWritable, TypedBytesWritable> {
    private byte[] bytes;
    private DataInput clientIn;
    private TypedBytesWritable key;
    private TypedBytesWritable value;
    private TypedBytesInput in;

    @Override
    public void initialize(PipeMapRed pipeMapRed) throws IOException {
        super.initialize(pipeMapRed);
        this.clientIn = pipeMapRed.getClientInput();
        this.key = new TypedBytesWritable();
        this.value = new TypedBytesWritable();
        this.in = new TypedBytesInput(this.clientIn);
    }

    @Override
    public boolean readKeyValue() throws IOException {
        this.bytes = this.in.readRaw();
        if (this.bytes == null) {
            return false;
        }
        this.key.set(this.bytes, 0, this.bytes.length);
        this.bytes = this.in.readRaw();
        this.value.set(this.bytes, 0, this.bytes.length);
        return true;
    }

    @Override
    public TypedBytesWritable getCurrentKey() throws IOException {
        return this.key;
    }

    @Override
    public TypedBytesWritable getCurrentValue() throws IOException {
        return this.value;
    }

    @Override
    public String getLastOutput() {
        return new TypedBytesWritable(this.bytes).toString();
    }
}

