/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipException;

public class JarBuilder {
    private static final int BUFF_SIZE = 32768;
    private byte[] buffer = new byte[32768];
    protected boolean verbose = false;

    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(List srcNames, List srcUnjar, String dstJar) throws IOException {
        String source2 = null;
        JarOutputStream jarOut = null;
        JarFile jarSource = null;
        jarOut = new JarOutputStream(new FileOutputStream(dstJar));
        boolean throwing = false;
        try {
            if (srcNames != null) {
                for (String source2 : srcNames) {
                    File fsource = new File(source2);
                    String base = this.getBasePathInJarOut(source2);
                    if (!fsource.exists()) {
                        throwing = true;
                        throw new FileNotFoundException(fsource.getAbsolutePath());
                    }
                    if (fsource.isDirectory()) {
                        this.addDirectory(jarOut, base, fsource, 0);
                        continue;
                    }
                    this.addFileStream(jarOut, base, fsource);
                }
            }
            if (srcUnjar != null) {
                for (String source2 : srcUnjar) {
                    jarSource = new JarFile(source2);
                    this.addJarEntries(jarOut, jarSource);
                    jarSource.close();
                }
            }
        }
        finally {
            block14: {
                try {
                    jarOut.close();
                }
                catch (ZipException z) {
                    if (throwing) break block14;
                    throw new IOException(z.toString());
                }
            }
        }
    }

    protected String fileExtension(String file) {
        int leafPos = file.lastIndexOf(47);
        if (leafPos == file.length() - 1) {
            return "";
        }
        String leafName = file.substring(leafPos + 1);
        int dotPos = leafName.lastIndexOf(46);
        if (dotPos == -1) {
            return "";
        }
        String ext = leafName.substring(dotPos + 1);
        return ext;
    }

    protected String getBasePathInJarOut(String sourceFile) {
        String ext = this.fileExtension(sourceFile);
        if (ext.equals("class")) {
            return "classes/";
        }
        if (ext.equals("jar") || ext.equals("zip")) {
            return "lib/";
        }
        return "";
    }

    private void addJarEntries(JarOutputStream dst, JarFile src) throws IOException {
        Enumeration<JarEntry> entries = src.entries();
        JarEntry entry = null;
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            InputStream in = src.getInputStream(entry);
            this.addNamedStream(dst, entry.getName(), in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNamedStream(JarOutputStream dst, String name, InputStream in) throws IOException {
        block9: {
            if (this.verbose) {
                System.err.println("JarBuilder.addNamedStream " + name);
            }
            try {
                dst.putNextEntry(new JarEntry(name));
                int bytesRead = 0;
                while ((bytesRead = in.read(this.buffer, 0, 32768)) != -1) {
                    dst.write(this.buffer, 0, bytesRead);
                }
            }
            catch (ZipException ze) {
                if (ze.getMessage().indexOf("duplicate entry") >= 0) {
                    if (this.verbose) {
                        System.err.println(ze + " Skip duplicate entry " + name);
                    }
                    break block9;
                }
                throw ze;
            }
            finally {
                in.close();
                dst.flush();
                dst.closeEntry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFileStream(JarOutputStream dst, String jarBaseName, File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            String name = jarBaseName + file.getName();
            this.addNamedStream(dst, name, (InputStream)in);
        }
    }

    void addDirectory(JarOutputStream dst, String jarBaseName, File dir, int depth) throws IOException {
        File[] contents = dir.listFiles();
        if (contents != null) {
            for (int i = 0; i < contents.length; ++i) {
                String fBaseName;
                File f = contents[i];
                String string = fBaseName = depth == 0 ? "" : dir.getName();
                if (jarBaseName.length() > 0) {
                    fBaseName = jarBaseName + "/" + fBaseName;
                }
                if (f.isDirectory()) {
                    this.addDirectory(dst, fBaseName, f, depth + 1);
                    continue;
                }
                this.addFileStream(dst, fBaseName + "/", f);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: JarFiles merged.jar [src.jar | dir | file ]+");
        } else {
            JarBuilder jarFiles = new JarBuilder();
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<String> unjar = new ArrayList<String>();
            for (int i = 1; i < args.length; ++i) {
                boolean expandAsJar;
                String f = args[i];
                String ext = jarFiles.fileExtension(f);
                boolean bl = expandAsJar = ext.equals("jar") || ext.equals("zip");
                if (expandAsJar) {
                    unjar.add(f);
                    continue;
                }
                names.add(f);
            }
            try {
                jarFiles.merge(names, unjar, args[0]);
                Date lastMod = new Date(new File(args[0]).lastModified());
                System.out.println("Merge done to " + args[0] + " " + lastMod);
            }
            catch (Exception ge) {
                ge.printStackTrace(System.err);
            }
        }
    }
}

