/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.streaming.DumpTypedBytes;
import org.apache.hadoop.typedbytes.TypedBytesInput;
import org.junit.Assert;
import org.junit.Test;

public class TestDumpTypedBytes {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDumping() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 2, true, null);
        DistributedFileSystem fs = cluster.getFileSystem();
        PrintStream psBackup = System.out;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream psOut = new PrintStream(out);
        System.setOut(psOut);
        DumpTypedBytes dumptb = new DumpTypedBytes(conf);
        try {
            Path root = new Path("/typedbytestest");
            Assert.assertTrue((boolean)fs.mkdirs(root));
            Assert.assertTrue((boolean)fs.exists(root));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(new Path(root, "test.txt")));
            try {
                for (int i = 0; i < 100; ++i) {
                    writer.write("" + 10 * i + "\n");
                }
            }
            finally {
                writer.close();
            }
            String[] args = new String[]{"/typedbytestest"};
            int ret = dumptb.run(args);
            Assert.assertEquals((String)"Return value != 0.", (long)0L, (long)ret);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            TypedBytesInput tbinput = new TypedBytesInput((DataInput)new DataInputStream(in));
            int counter = 0;
            Object key = tbinput.read();
            while (key != null) {
                Assert.assertEquals(Long.class, key.getClass());
                Object value = tbinput.read();
                Assert.assertEquals(String.class, value.getClass());
                Assert.assertTrue((String)"Invalid output.", (Integer.parseInt(value.toString()) % 10 == 0 ? 1 : 0) != 0);
                ++counter;
                key = tbinput.read();
            }
            Assert.assertEquals((String)"Wrong number of outputs.", (long)100L, (long)counter);
        }
        finally {
            try {
                fs.close();
            }
            catch (Exception e) {}
            System.setOut(psBackup);
            cluster.shutdown();
        }
    }
}

