/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.streaming.TestStreaming;
import org.apache.hadoop.streaming.UtilTest;
import org.junit.Before;
import org.junit.Test;

public class TestStreamXmlMultipleRecords
extends TestStreaming {
    private static final Log LOG = LogFactory.getLog(TestStreamXmlMultipleRecords.class);
    private boolean hasPerl = false;
    private long blockSize;
    private String isSlowMatch;
    private Configuration conf = null;
    private String myPerlMapper = "perl -n -a -e 'print join(\"\\n\", map { \"$_\\t1\" } @F), \"\\n\";'";
    private String myPerlReducer = "perl -n -a -e '$freq{$F[0]}++; END { print \"is\\t$freq{is}\\n\"; }'";

    public TestStreamXmlMultipleRecords() throws IOException {
        this.input = "<line>This is a single line,\nand it is containing multiple words.</line>                     <line>Only is appears more than once.</line>\n";
        this.outputExpect = "is\t3\n";
        this.map = this.myPerlMapper;
        this.reduce = this.myPerlReducer;
        this.hasPerl = UtilTest.hasPerlSupport();
    }

    @Before
    public void setUp() throws IOException {
        super.setUp();
        FileSystem.closeAll();
    }

    protected Configuration getConf() {
        this.conf = new Configuration();
        this.conf.setLong("fs.local.block.size", this.blockSize);
        return this.conf;
    }

    protected String[] genArgs() {
        this.args.add("-inputreader");
        this.args.add("StreamXmlRecordReader,begin=<line>,end=</line>,slowmatch=" + this.isSlowMatch);
        return super.genArgs();
    }

    @Test
    public void testStreamXmlMultiInnerFast() throws Exception {
        if (this.hasPerl) {
            this.blockSize = 60L;
            this.isSlowMatch = "false";
            super.testCommandLine();
        } else {
            LOG.warn((Object)"No perl; skipping test.");
        }
    }

    @Test
    public void testStreamXmlMultiOuterFast() throws Exception {
        if (this.hasPerl) {
            this.blockSize = 80L;
            this.isSlowMatch = "false";
            super.testCommandLine();
        } else {
            LOG.warn((Object)"No perl; skipping test.");
        }
    }

    @Test
    public void testStreamXmlMultiInnerSlow() throws Exception {
        if (this.hasPerl) {
            this.blockSize = 60L;
            this.isSlowMatch = "true";
            super.testCommandLine();
        } else {
            LOG.warn((Object)"No perl; skipping test.");
        }
    }

    @Test
    public void testStreamXmlMultiOuterSlow() throws Exception {
        if (this.hasPerl) {
            this.blockSize = 80L;
            this.isSlowMatch = "true";
            super.testCommandLine();
        } else {
            LOG.warn((Object)"No perl; skipping test.");
        }
    }

    @Test
    public void testCommandLine() {
    }
}

