/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.streaming.StreamJob;
import org.apache.hadoop.streaming.TestStreaming;
import org.junit.Assert;
import org.junit.Test;

public class TestSymLink {
    String INPUT_FILE = "/testing-streaming/input.txt";
    String OUTPUT_DIR = "/testing-streaming/out";
    String CACHE_FILE = "/testing-streaming/cache.txt";
    String input = "check to see if we can read this none reduce";
    String map = TestStreaming.XARGS_CAT;
    String reduce = TestStreaming.CAT;
    String mapString = "testlink\n";
    String cacheString = "This is just the cache string";
    StreamJob job;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testSymLink() throws Exception {
        boolean mayExit = false;
        MiniMRCluster mr = null;
        MiniDFSCluster dfs = null;
        try {
            String[] argv;
            Configuration conf = new Configuration();
            dfs = new MiniDFSCluster(conf, 1, true, null);
            DistributedFileSystem fileSys = dfs.getFileSystem();
            String namenode = fileSys.getUri().toString();
            mr = new MiniMRCluster(1, namenode, 3);
            ArrayList<String> args = new ArrayList<String>();
            for (Map.Entry entry : mr.createJobConf()) {
                args.add("-jobconf");
                args.add((String)entry.getKey() + "=" + (String)entry.getValue());
            }
            for (String arg : argv = new String[]{"-input", this.INPUT_FILE, "-output", this.OUTPUT_DIR, "-mapper", this.map, "-reducer", this.reduce, "-jobconf", "stream.tmpdir=" + System.getProperty("test.build.data", "/tmp"), "-jobconf", "mapreduce.map.java.opts=-Dcontrib.name=" + System.getProperty("contrib.name") + " " + "-Dbuild.test=" + System.getProperty("build.test") + " " + conf.get("mapreduce.map.java.opts", conf.get("mapred.child.java.opts", "")), "-jobconf", "mapreduce.reduce.java.opts=-Dcontrib.name=" + System.getProperty("contrib.name") + " " + "-Dbuild.test=" + System.getProperty("build.test") + " " + conf.get("mapreduce.reduce.java.opts", conf.get("mapred.child.java.opts", "")), "-cacheFile", fileSys.getUri() + this.CACHE_FILE + "#testlink", "-jobconf", "mapred.jar=" + TestStreaming.STREAMING_JAR}) {
                args.add(arg);
            }
            argv = args.toArray(new String[args.size()]);
            fileSys.delete(new Path(this.OUTPUT_DIR), true);
            FSDataOutputStream file = fileSys.create(new Path(this.INPUT_FILE));
            file.writeBytes(this.mapString);
            file.close();
            file = fileSys.create(new Path(this.CACHE_FILE));
            file.writeBytes(this.cacheString);
            file.close();
            this.job = new StreamJob(argv, mayExit);
            this.job.go();
            fileSys = dfs.getFileSystem();
            String line = null;
            Path[] fileList = FileUtil.stat2Paths((FileStatus[])fileSys.listStatus(new Path(this.OUTPUT_DIR), (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()));
            for (int i = 0; i < fileList.length; ++i) {
                System.out.println(fileList[i].toString());
                BufferedReader bread = new BufferedReader(new InputStreamReader((InputStream)fileSys.open(fileList[i])));
                line = bread.readLine();
                System.out.println(line);
            }
            Assert.assertEquals((Object)(this.cacheString + "\t"), line);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new TestStreaming().testCommandLine();
    }
}

