/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.streaming.StreamAggregate;
import org.apache.hadoop.streaming.StreamJob;
import org.apache.hadoop.streaming.StreamUtil;
import org.apache.hadoop.streaming.TestStreaming;
import org.apache.hadoop.streaming.UtilTest;
import org.junit.Assert;
import org.junit.Test;

public class TestStreamAggregate {
    protected File INPUT_FILE = new File("stream_aggregate_input.txt");
    protected File OUTPUT_DIR = new File("stream_aggregate_out");
    protected String input = "roses are red\nviolets are blue\nbunnies are pink\n";
    protected String map = UtilTest.makeJavaCommand(StreamAggregate.class, (String[])new String[]{".", "\\n"});
    protected String outputExpect = "are\t3\nblue\t1\nbunnies\t1\npink\t1\nred\t1\nroses\t1\nviolets\t1\n";
    private StreamJob job;

    public TestStreamAggregate() throws IOException {
        UtilTest utilTest = new UtilTest(this.getClass().getName());
        utilTest.checkUserDir();
        utilTest.redirectIfAntJunit();
    }

    protected void createInput() throws IOException {
        DataOutputStream out = new DataOutputStream(new FileOutputStream(this.INPUT_FILE.getAbsoluteFile()));
        out.write(this.input.getBytes("UTF-8"));
        out.close();
    }

    protected String[] genArgs() {
        return new String[]{"-input", this.INPUT_FILE.getAbsolutePath(), "-output", this.OUTPUT_DIR.getAbsolutePath(), "-mapper", this.map, "-reducer", "aggregate", "-jobconf", "mapreduce.task.files.preserve.failedtasks=true", "-jobconf", "stream.tmpdir=" + System.getProperty("test.build.data", "/tmp")};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCommandLine() throws Exception {
        try {
            try {
                FileUtil.fullyDelete((File)this.OUTPUT_DIR.getAbsoluteFile());
            }
            catch (Exception e) {
                // empty catch block
            }
            this.createInput();
            boolean mayExit = false;
            this.job = new StreamJob(this.genArgs(), mayExit);
            this.job.go();
            File outFile = new File(this.OUTPUT_DIR, "part-00000").getAbsoluteFile();
            String output = StreamUtil.slurp((File)outFile);
            outFile.delete();
            System.err.println("outEx1=" + this.outputExpect);
            System.err.println("  out1=" + output);
            Assert.assertEquals((Object)this.outputExpect, (Object)output);
        }
        finally {
            this.INPUT_FILE.delete();
            FileUtil.fullyDelete((File)this.OUTPUT_DIR.getAbsoluteFile());
        }
    }

    public static void main(String[] args) throws Exception {
        new TestStreaming().testCommandLine();
    }
}

