/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.KeyValueTextInputFormat;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.streaming.StreamInputFormat;
import org.apache.hadoop.streaming.StreamJob;
import org.junit.Assert;
import org.junit.Test;

public class TestStreamJob {
    @Test(expected=IllegalArgumentException.class)
    public void testCreateJobWithExtraArgs() throws IOException {
        ArrayList<String> dummyArgs = new ArrayList<String>();
        dummyArgs.add("-input");
        dummyArgs.add("dummy");
        dummyArgs.add("-output");
        dummyArgs.add("dummy");
        dummyArgs.add("-mapper");
        dummyArgs.add("dummy");
        dummyArgs.add("dummy");
        dummyArgs.add("-reducer");
        dummyArgs.add("dummy");
        StreamJob.createJob((String[])dummyArgs.toArray(new String[0]));
    }

    @Test
    public void testCreateJob() throws IOException {
        ArrayList<String> dummyArgs = new ArrayList<String>();
        dummyArgs.add("-input");
        dummyArgs.add("dummy");
        dummyArgs.add("-output");
        dummyArgs.add("dummy");
        dummyArgs.add("-mapper");
        dummyArgs.add("dummy");
        dummyArgs.add("-reducer");
        dummyArgs.add("dummy");
        ArrayList<String> args = new ArrayList<String>(dummyArgs);
        args.add("-inputformat");
        args.add("org.apache.hadoop.mapred.KeyValueTextInputFormat");
        JobConf job = StreamJob.createJob((String[])args.toArray(new String[0]));
        Assert.assertEquals(KeyValueTextInputFormat.class, job.getInputFormat().getClass());
        args = new ArrayList(dummyArgs);
        args.add("-inputformat");
        args.add("org.apache.hadoop.mapred.SequenceFileInputFormat");
        job = StreamJob.createJob((String[])args.toArray(new String[0]));
        Assert.assertEquals(SequenceFileInputFormat.class, job.getInputFormat().getClass());
        args = new ArrayList(dummyArgs);
        args.add("-inputformat");
        args.add("org.apache.hadoop.mapred.KeyValueTextInputFormat");
        args.add("-inputreader");
        args.add("StreamXmlRecordReader,begin=<doc>,end=</doc>");
        job = StreamJob.createJob((String[])args.toArray(new String[0]));
        Assert.assertEquals(StreamInputFormat.class, job.getInputFormat().getClass());
    }

    @Test
    public void testOptions() throws Exception {
        StreamJob streamJob = new StreamJob();
        Assert.assertEquals((long)1L, (long)streamJob.run(new String[0]));
        Assert.assertEquals((long)0L, (long)streamJob.run(new String[]{"-help"}));
        Assert.assertEquals((long)0L, (long)streamJob.run(new String[]{"-info"}));
    }
}

