/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.streaming.StreamJob;
import org.apache.hadoop.streaming.StreamUtil;
import org.apache.hadoop.streaming.TrApp;
import org.apache.hadoop.streaming.UtilTest;
import org.junit.Assert;
import org.junit.Test;

public class TestStreamReduceNone {
    protected File INPUT_FILE = new File("stream_reduce_none_input.txt");
    protected File OUTPUT_DIR = new File("stream_reduce_none_out");
    protected String input = "roses.are.red\nviolets.are.blue\nbunnies.are.pink\n";
    protected String map = UtilTest.makeJavaCommand(TrApp.class, (String[])new String[]{".", "\\n"});
    protected String outputExpect = "roses\t\nare\t\nred\t\nviolets\t\nare\t\nblue\t\nbunnies\t\nare\t\npink\t\n";
    private StreamJob job;

    public TestStreamReduceNone() throws IOException {
        UtilTest utilTest = new UtilTest(this.getClass().getName());
        utilTest.checkUserDir();
        utilTest.redirectIfAntJunit();
    }

    protected void createInput() throws IOException {
        DataOutputStream out = new DataOutputStream(new FileOutputStream(this.INPUT_FILE.getAbsoluteFile()));
        out.write(this.input.getBytes("UTF-8"));
        out.close();
    }

    protected String[] genArgs() {
        return new String[]{"-input", this.INPUT_FILE.getAbsolutePath(), "-output", this.OUTPUT_DIR.getAbsolutePath(), "-mapper", this.map, "-reducer", "org.apache.hadoop.mapred.lib.IdentityReducer", "-numReduceTasks", "0", "-jobconf", "mapreduce.task.files.preserve.failedtasks=true", "-jobconf", "mapreduce.job.maps=1", "-jobconf", "stream.tmpdir=" + System.getProperty("test.build.data", "/tmp")};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCommandLine() throws Exception {
        String outFileName = "part-00000";
        File outFile = null;
        try {
            try {
                FileUtil.fullyDelete((File)this.OUTPUT_DIR.getAbsoluteFile());
            }
            catch (Exception e) {
                // empty catch block
            }
            this.createInput();
            boolean mayExit = false;
            this.job = new StreamJob(this.genArgs(), mayExit);
            this.job.go();
            outFile = new File(this.OUTPUT_DIR, outFileName).getAbsoluteFile();
            String output = StreamUtil.slurp((File)outFile);
            System.err.println("outEx1=" + this.outputExpect);
            System.err.println("  out1=" + output);
            Assert.assertEquals((Object)this.outputExpect, (Object)output);
        }
        finally {
            this.INPUT_FILE.delete();
            FileUtil.fullyDelete((File)this.OUTPUT_DIR.getAbsoluteFile());
        }
    }

    public static void main(String[] args) throws Exception {
        new TestStreamReduceNone().testCommandLine();
    }
}

