/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hadoop.streaming.StderrApp;
import org.apache.hadoop.streaming.StreamJob;
import org.apache.hadoop.streaming.UtilTest;
import org.junit.Assert;
import org.junit.Test;

public class TestStreamingStderr {
    public TestStreamingStderr() throws IOException {
        UtilTest utilTest = new UtilTest(this.getClass().getName());
        utilTest.checkUserDir();
        utilTest.redirectIfAntJunit();
    }

    protected String[] genArgs(File input, File output, int preLines, int duringLines, int postLines) {
        return new String[]{"-input", input.getAbsolutePath(), "-output", output.getAbsolutePath(), "-mapper", UtilTest.makeJavaCommand(StderrApp.class, (String[])new String[]{Integer.toString(preLines), Integer.toString(duringLines), Integer.toString(postLines)}), "-reducer", "NONE", "-jobconf", "mapreduce.task.files.preserve.failedtasks=true", "-jobconf", "mapreduce.task.timeout=5000", "-jobconf", "stream.tmpdir=" + System.getProperty("test.build.data", "/tmp")};
    }

    protected File setupInput(String base, boolean hasInput) throws IOException {
        File input = new File(base + "-input.txt");
        UtilTest.recursiveDelete((File)input);
        FileOutputStream in = new FileOutputStream(input.getAbsoluteFile());
        if (hasInput) {
            in.write("hello\n".getBytes());
        }
        in.close();
        return input;
    }

    protected File setupOutput(String base) throws IOException {
        File output = new File(base + "-out");
        UtilTest.recursiveDelete((File)output);
        return output;
    }

    public void runStreamJob(String baseName, boolean hasInput, int preLines, int duringLines, int postLines) throws Exception {
        File input = this.setupInput(baseName, hasInput);
        File output = this.setupOutput(baseName);
        boolean mayExit = false;
        int returnStatus = 0;
        StreamJob job = new StreamJob(this.genArgs(input, output, preLines, duringLines, postLines), mayExit);
        returnStatus = job.go();
        Assert.assertEquals((String)"StreamJob success", (long)0L, (long)returnStatus);
    }

    @Test
    public void testStderrNoInput() throws Exception {
        this.runStreamJob("target/stderr-pre", false, 10000, 0, 0);
    }

    @Test
    public void testStderrAfterOutput() throws Exception {
        this.runStreamJob("target/stderr-post", false, 0, 0, 10000);
    }

    @Test
    public void testStderrCountsAsProgress() throws Exception {
        this.runStreamJob("target/stderr-progress", true, 10, 1000, 0);
    }
}

