/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.Shell;

/*
 * Exception performing whole class analysis ignored.
 */
class UtilTest {
    private static final Log LOG = LogFactory.getLog(UtilTest.class);
    private String userDir_;
    private String antTestDir_;
    private String testName_;

    static void recursiveDelete(File file) {
        if (!(file = file.getAbsoluteFile()).exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                UtilTest.recursiveDelete((File)child);
            }
        }
        if (!file.delete()) {
            throw new RuntimeException("Failed to delete " + file);
        }
    }

    public UtilTest(String testName) {
        this.testName_ = testName;
        this.userDir_ = System.getProperty("user.dir");
        this.antTestDir_ = System.getProperty("test.build.data", this.userDir_);
        System.out.println("test.build.data-or-user.dir=" + this.antTestDir_);
    }

    void checkUserDir() {
    }

    void redirectIfAntJunit() throws IOException {
        boolean fromAntJunit;
        boolean bl = fromAntJunit = System.getProperty("test.build.data") != null;
        if (fromAntJunit) {
            new File(this.antTestDir_).mkdirs();
            File outFile = new File(this.antTestDir_, this.testName_ + ".log");
            PrintStream out = new PrintStream(new FileOutputStream(outFile));
            System.setOut(out);
            System.setErr(out);
        }
    }

    public static String collate(List<String> args, String sep) {
        StringBuffer buf = new StringBuffer();
        Iterator<String> it = args.iterator();
        while (it.hasNext()) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(it.next());
        }
        return buf.toString();
    }

    public static String makeJavaCommand(Class<?> main, String[] argv) {
        ArrayList<String> vargs = new ArrayList<String>();
        File javaHomeBin = new File(System.getProperty("java.home"), "bin");
        File jvm = new File(javaHomeBin, "java");
        vargs.add(jvm.toString());
        vargs.add("-classpath");
        vargs.add("\"" + System.getProperty("java.class.path") + "\"");
        vargs.add("-Xmx" + Runtime.getRuntime().maxMemory());
        vargs.add(main.getName());
        for (int i = 0; i < argv.length; ++i) {
            vargs.add(argv[i]);
        }
        return UtilTest.collate(vargs, (String)" ");
    }

    public static boolean isCygwin() {
        String OS = System.getProperty("os.name");
        return OS.indexOf("Windows") > -1;
    }

    public static boolean hasPerlSupport() {
        boolean hasPerl = false;
        Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(new String[]{"perl", "-e", "print 42"});
        try {
            shexec.execute();
            if (shexec.getOutput().equals("42")) {
                hasPerl = true;
            } else {
                LOG.warn((Object)"Perl is installed, but isn't behaving as expected.");
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not run perl: " + e));
        }
        return hasPerl;
    }
}

