/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Trash;

public class TestTrash
extends TestCase {
    private static final Path TEST_DIR = new Path(new File(System.getProperty("test.build.data", "/tmp")).toURI().toString().replace(' ', '+'), "testTrash");

    protected static Path writeFile(FileSystem fs, Path f) throws IOException {
        FSDataOutputStream out = fs.create(f);
        out.writeBytes("dhruba: " + f);
        out.close();
        TestTrash.assertTrue((boolean)fs.exists(f));
        return f;
    }

    protected static Path mkdir(FileSystem fs, Path p) throws IOException {
        TestTrash.assertTrue((boolean)fs.mkdirs(p));
        TestTrash.assertTrue((boolean)fs.exists(p));
        TestTrash.assertTrue((boolean)fs.getFileStatus(p).isDir());
        return p;
    }

    protected static void checkTrash(FileSystem fs, Path trashRoot, Path path) throws IOException {
        Path p = new Path(trashRoot + "/" + path.toUri().getPath());
        TestTrash.assertTrue((boolean)fs.exists(p));
    }

    static void checkNotInTrash(FileSystem fs, Path trashRoot, String pathname) throws IOException {
        Path p = new Path(trashRoot + "/" + new Path(pathname).getName());
        TestTrash.assertTrue((!fs.exists(p) ? 1 : 0) != 0);
    }

    protected static void trashShell(FileSystem fs, Path base) throws IOException {
        Configuration conf = new Configuration();
        conf.set("fs.trash.interval", "10");
        conf.set("fs.default.name", fs.getUri().toString());
        FsShell shell = new FsShell();
        shell.setConf(conf);
        Path trashRoot = null;
        Path myPath = new Path(base, "test/mkdirs");
        TestTrash.mkdir(fs, myPath);
        Path myFile = new Path(base, "test/mkdirs/myFile");
        TestTrash.writeFile(fs, myFile);
        String[] args = new String[]{"-expunge"};
        int val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        TestTrash.assertTrue((val == 0 ? 1 : 0) != 0);
        args = new String[]{"-rm", myFile.toString()};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        TestTrash.assertTrue((val == 0 ? 1 : 0) != 0);
        trashRoot = shell.getCurrentTrashDir();
        TestTrash.checkTrash(fs, trashRoot, myFile);
        TestTrash.writeFile(fs, myFile);
        args = new String[]{"-rm", new Path(base, "test/mkdirs/myFile").toString()};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        TestTrash.assertTrue((val == 0 ? 1 : 0) != 0);
        TestTrash.writeFile(fs, myFile);
        args = new String[]{"-rmr", new Path(base, "test/mkdirs").toString()};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        TestTrash.assertTrue((val == 0 ? 1 : 0) != 0);
        TestTrash.mkdir(fs, myPath);
        args = new String[]{"-rmr", new Path(base, "test/mkdirs").toString()};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        TestTrash.assertTrue((val == 0 ? 1 : 0) != 0);
        Path toErase = new Path(trashRoot, "toErase");
        int retVal = -1;
        TestTrash.writeFile(fs, toErase);
        try {
            retVal = shell.run(new String[]{"-rm", toErase.toString()});
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        TestTrash.assertTrue((retVal == 0 ? 1 : 0) != 0);
        TestTrash.checkNotInTrash(fs, trashRoot, toErase.toString());
        TestTrash.checkNotInTrash(fs, trashRoot, toErase.toString() + ".1");
        args = new String[]{"-expunge"};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        TestTrash.assertTrue((val == 0 ? 1 : 0) != 0);
        TestTrash.checkNotInTrash(fs, trashRoot, new Path(base, "test/mkdirs/myFile").toString());
        TestTrash.mkdir(fs, myPath);
        TestTrash.writeFile(fs, myFile);
        args = new String[]{"-rm", myFile.toString()};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        TestTrash.assertTrue((val == 0 ? 1 : 0) != 0);
        TestTrash.checkTrash(fs, trashRoot, myFile);
        args = new String[]{"-rmr", myPath.toString()};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        TestTrash.assertTrue((val == 0 ? 1 : 0) != 0);
        TestTrash.checkTrash(fs, trashRoot, myPath);
        args = new String[]{"-rmr", trashRoot.getParent().getParent().toString()};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        TestTrash.assertTrue((val == -1 ? 1 : 0) != 0);
        TestTrash.assertTrue((boolean)fs.exists(trashRoot));
        TestTrash.mkdir(fs, myPath);
        TestTrash.writeFile(fs, myFile);
        args = new String[]{"-rm", "-skipTrash", myFile.toString()};
        val = -1;
        try {
            TestTrash.assertEquals((int)0, (int)shell.run(new String[]{"-expunge"}));
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        TestTrash.assertFalse((boolean)fs.exists(trashRoot));
        TestTrash.assertFalse((boolean)fs.exists(myFile));
        TestTrash.assertTrue((val == 0 ? 1 : 0) != 0);
        TestTrash.mkdir(fs, myPath);
        TestTrash.writeFile(fs, myFile);
        args = new String[]{"-rmr", "-skipTrash", myPath.toString()};
        val = -1;
        try {
            TestTrash.assertEquals((int)0, (int)shell.run(new String[]{"-expunge"}));
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        TestTrash.assertFalse((boolean)fs.exists(trashRoot));
        TestTrash.assertFalse((boolean)fs.exists(myPath));
        TestTrash.assertFalse((boolean)fs.exists(myFile));
        TestTrash.assertTrue((val == 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trashNonDefaultFS(Configuration conf) throws IOException {
        conf.set("fs.trash.interval", "10");
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        Path p = TEST_DIR;
        Path f = new Path(p, "foo/bar");
        if (lfs.exists(p)) {
            lfs.delete(p, true);
        }
        try {
            f = TestTrash.writeFile((FileSystem)lfs, f);
            FileSystem.closeAll();
            FileSystem localFs = FileSystem.get((URI)URI.create("file:///"), (Configuration)conf);
            Trash lTrash = new Trash(localFs, conf);
            lTrash.moveToTrash(f.getParent());
            TestTrash.checkTrash(localFs, lTrash.getCurrentTrashDir(), f);
        }
        finally {
            if (lfs.exists(p)) {
                lfs.delete(p, true);
            }
        }
    }

    public void testTrash() throws IOException {
        Configuration conf = new Configuration();
        conf.setClass("fs.file.impl", TestLFS.class, FileSystem.class);
        TestTrash.trashShell((FileSystem)FileSystem.getLocal((Configuration)conf), TEST_DIR);
    }

    public void testNonDefaultFS() throws IOException {
        Configuration conf = new Configuration();
        conf.setClass("fs.file.impl", TestLFS.class, FileSystem.class);
        conf.set("fs.default.name", "invalid://host/bar/foo");
        TestTrash.trashNonDefaultFS(conf);
    }

    static class TestLFS
    extends LocalFileSystem {
        Path home;

        TestLFS() {
            this(TEST_DIR);
        }

        TestLFS(Path home) {
            this.home = home;
        }

        public Path getHomeDirectory() {
            return this.home;
        }
    }
}

