/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.UpgradeUtilities;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;

public class TestDFSRollback
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hdfs.TestDFSRollback");
    private Configuration conf;
    private int testCounter = 0;
    private MiniDFSCluster cluster = null;

    void log(String label, int numDirs) {
        LOG.info((Object)"============================================================");
        LOG.info((Object)("***TEST " + this.testCounter++ + "*** " + label + ":" + " numDirs=" + numDirs));
    }

    void checkResult(HdfsConstants.NodeType nodeType, String[] baseDirs) throws IOException {
        int i;
        switch (nodeType) {
            case NAME_NODE: {
                for (i = 0; i < baseDirs.length; ++i) {
                    TestDFSRollback.assertTrue((boolean)new File(baseDirs[i], "current").isDirectory());
                    TestDFSRollback.assertTrue((boolean)new File(baseDirs[i], "current/VERSION").isFile());
                    TestDFSRollback.assertTrue((boolean)new File(baseDirs[i], "current/edits").isFile());
                    TestDFSRollback.assertTrue((boolean)new File(baseDirs[i], "current/fsimage").isFile());
                    TestDFSRollback.assertTrue((boolean)new File(baseDirs[i], "current/fstime").isFile());
                }
                break;
            }
            case DATA_NODE: {
                for (i = 0; i < baseDirs.length; ++i) {
                    TestDFSRollback.assertEquals((long)UpgradeUtilities.checksumContents(nodeType, new File(baseDirs[i], "current")), (long)UpgradeUtilities.checksumMasterContents(nodeType));
                }
                break;
            }
        }
        for (i = 0; i < baseDirs.length; ++i) {
            TestDFSRollback.assertFalse((boolean)new File(baseDirs[i], "previous").isDirectory());
        }
    }

    void startNameNodeShouldFail(HdfsConstants.StartupOption operation) {
        try {
            this.cluster = new MiniDFSCluster(this.conf, 0, operation);
            throw new AssertionError((Object)"NameNode should have failed to start");
        }
        catch (Exception exception) {
            return;
        }
    }

    void startDataNodeShouldFail(HdfsConstants.StartupOption operation) {
        try {
            this.cluster.startDataNodes(this.conf, 1, false, operation, null);
            throw new AssertionError((Object)"DataNode should have failed to start");
        }
        catch (Exception expected) {
            TestDFSRollback.assertFalse((boolean)this.cluster.isDataNodeUp());
            return;
        }
    }

    public void testRollback() throws Exception {
        UpgradeUtilities.initialize();
        for (int numDirs = 1; numDirs <= 2; ++numDirs) {
            this.conf = new Configuration();
            this.conf.setInt("dfs.datanode.scan.period.hours", -1);
            this.conf = UpgradeUtilities.initializeStorageStateConf(numDirs, this.conf);
            String[] nameNodeDirs = this.conf.getStrings("dfs.name.dir");
            String[] dataNodeDirs = this.conf.getStrings("dfs.data.dir");
            this.log("Normal NameNode rollback", numDirs);
            UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.NAME_NODE, nameNodeDirs, "current");
            UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.NAME_NODE, nameNodeDirs, "previous");
            this.cluster = new MiniDFSCluster(this.conf, 0, HdfsConstants.StartupOption.ROLLBACK);
            this.checkResult(HdfsConstants.NodeType.NAME_NODE, nameNodeDirs);
            this.cluster.shutdown();
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            this.log("Normal DataNode rollback", numDirs);
            UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.NAME_NODE, nameNodeDirs, "current");
            UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.NAME_NODE, nameNodeDirs, "previous");
            this.cluster = new MiniDFSCluster(this.conf, 0, HdfsConstants.StartupOption.ROLLBACK);
            UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.DATA_NODE, dataNodeDirs, "current");
            UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.DATA_NODE, dataNodeDirs, "previous");
            this.cluster.startDataNodes(this.conf, 1, false, HdfsConstants.StartupOption.ROLLBACK, null);
            this.checkResult(HdfsConstants.NodeType.DATA_NODE, dataNodeDirs);
            this.cluster.shutdown();
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            UpgradeUtilities.createEmptyDirs(dataNodeDirs);
            this.log("NameNode rollback without existing previous dir", numDirs);
            UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.NAME_NODE, nameNodeDirs, "current");
            this.startNameNodeShouldFail(HdfsConstants.StartupOption.ROLLBACK);
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            this.log("DataNode rollback without existing previous dir", numDirs);
            UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.NAME_NODE, nameNodeDirs, "current");
            this.cluster = new MiniDFSCluster(this.conf, 0, HdfsConstants.StartupOption.UPGRADE);
            UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.DATA_NODE, dataNodeDirs, "current");
            this.cluster.startDataNodes(this.conf, 1, false, HdfsConstants.StartupOption.ROLLBACK, null);
            this.cluster.shutdown();
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            UpgradeUtilities.createEmptyDirs(dataNodeDirs);
            this.log("DataNode rollback with future stored layout version in previous", numDirs);
            UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.NAME_NODE, nameNodeDirs, "current");
            UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.NAME_NODE, nameNodeDirs, "previous");
            this.cluster = new MiniDFSCluster(this.conf, 0, HdfsConstants.StartupOption.ROLLBACK);
            UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.DATA_NODE, dataNodeDirs, "current");
            File[] baseDirs = UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.DATA_NODE, dataNodeDirs, "previous");
            UpgradeUtilities.createVersionFile(HdfsConstants.NodeType.DATA_NODE, baseDirs, new StorageInfo(Integer.MIN_VALUE, UpgradeUtilities.getCurrentNamespaceID(this.cluster), UpgradeUtilities.getCurrentFsscTime(this.cluster)));
            this.startDataNodeShouldFail(HdfsConstants.StartupOption.ROLLBACK);
            this.cluster.shutdown();
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            UpgradeUtilities.createEmptyDirs(dataNodeDirs);
            this.log("DataNode rollback with newer fsscTime in previous", numDirs);
            UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.NAME_NODE, nameNodeDirs, "current");
            UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.NAME_NODE, nameNodeDirs, "previous");
            this.cluster = new MiniDFSCluster(this.conf, 0, HdfsConstants.StartupOption.ROLLBACK);
            UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.DATA_NODE, dataNodeDirs, "current");
            baseDirs = UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.DATA_NODE, dataNodeDirs, "previous");
            UpgradeUtilities.createVersionFile(HdfsConstants.NodeType.DATA_NODE, baseDirs, new StorageInfo(UpgradeUtilities.getCurrentLayoutVersion(), UpgradeUtilities.getCurrentNamespaceID(this.cluster), Long.MAX_VALUE));
            this.startDataNodeShouldFail(HdfsConstants.StartupOption.ROLLBACK);
            this.cluster.shutdown();
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            UpgradeUtilities.createEmptyDirs(dataNodeDirs);
            this.log("NameNode rollback with no edits file", numDirs);
            UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.NAME_NODE, nameNodeDirs, "current");
            for (File f : baseDirs = UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.NAME_NODE, nameNodeDirs, "previous")) {
                FileUtil.fullyDelete((File)new File(f, "edits"));
            }
            this.startNameNodeShouldFail(HdfsConstants.StartupOption.ROLLBACK);
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            this.log("NameNode rollback with no image file", numDirs);
            UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.NAME_NODE, nameNodeDirs, "current");
            for (File f : baseDirs = UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.NAME_NODE, nameNodeDirs, "previous")) {
                FileUtil.fullyDelete((File)new File(f, "fsimage"));
            }
            this.startNameNodeShouldFail(HdfsConstants.StartupOption.ROLLBACK);
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            this.log("NameNode rollback with corrupt version file", numDirs);
            UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.NAME_NODE, nameNodeDirs, "current");
            for (File f : baseDirs = UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.NAME_NODE, nameNodeDirs, "previous")) {
                UpgradeUtilities.corruptFile(new File(f, "VERSION"));
            }
            this.startNameNodeShouldFail(HdfsConstants.StartupOption.ROLLBACK);
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            this.log("NameNode rollback with old layout version in previous", numDirs);
            UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.NAME_NODE, nameNodeDirs, "current");
            baseDirs = UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.NAME_NODE, nameNodeDirs, "previous");
            UpgradeUtilities.createVersionFile(HdfsConstants.NodeType.NAME_NODE, baseDirs, new StorageInfo(1, UpgradeUtilities.getCurrentNamespaceID(null), UpgradeUtilities.getCurrentFsscTime(null)));
            this.startNameNodeShouldFail(HdfsConstants.StartupOption.UPGRADE);
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
        }
    }

    protected void tearDown() throws Exception {
        LOG.info((Object)"Shutting down MiniDFSCluster");
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        new TestDFSRollback().testRollback();
    }
}

