/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.util.ConcurrentModificationException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestFileCreation;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;

public class TestFileCreationEmpty
extends TestCase {
    private boolean isConcurrentModificationException = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLeaseExpireEmptyFiles() throws Exception {
        Thread.UncaughtExceptionHandler oldUEH = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (e instanceof ConcurrentModificationException) {
                    FSNamesystem.LOG.error((Object)("t=" + t), e);
                    TestFileCreationEmpty.this.isConcurrentModificationException = true;
                }
            }
        });
        System.out.println("testLeaseExpireEmptyFiles start");
        long leasePeriod = 1000L;
        int DATANODE_NUM = 3;
        Configuration conf = new Configuration();
        conf.setInt("heartbeat.recheck.interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 3, true, null);
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = (DistributedFileSystem)cluster.getFileSystem();
            TestFileCreation.createFile((FileSystem)dfs, new Path("/foo"), 3);
            TestFileCreation.createFile((FileSystem)dfs, new Path("/foo2"), 3);
            TestFileCreation.createFile((FileSystem)dfs, new Path("/foo3"), 3);
            cluster.setLeasePeriod(1000L, 1000L);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            TestFileCreationEmpty.assertFalse((boolean)this.isConcurrentModificationException);
        }
        finally {
            Thread.setDefaultUncaughtExceptionHandler(oldUEH);
            cluster.shutdown();
        }
    }
}

