/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Random;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HftpFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class TestFileStatus {
    static final long seed = 3735928559L;
    static final int blockSize = 8192;
    static final int fileSize = 16384;

    public TestFileStatus() {
        ((Log4JLogger)FSNamesystem.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)FileSystem.LOG).getLogger().setLevel(Level.ALL);
    }

    private void writeFile(FileSystem fileSys, Path name, int repl, int fileSize, int blockSize) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, (long)blockSize);
        byte[] buffer = new byte[fileSize];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
    }

    private void checkFile(FileSystem fileSys, Path name, int repl) throws IOException {
        DFSTestUtil.waitReplication(fileSys, name, (short)repl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileStatus() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.ls.limit", 2);
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        FileSystem fs = cluster.getFileSystem();
        HftpFileSystem hftpfs = cluster.getHftpFileSystem();
        DFSClient dfsClient = new DFSClient(NameNode.getAddress((Configuration)conf), conf);
        try {
            Path path = new Path("/");
            System.out.println("Path : \"" + path.toString() + "\"");
            Assert.assertTrue((String)"/ should be a directory", (fs.getFileStatus(path).isDir() ? 1 : 0) != 0);
            HdfsFileStatus fileInfo = dfsClient.getFileInfo("/noSuchFile");
            Assert.assertTrue((fileInfo == null ? 1 : 0) != 0);
            Path file1 = new Path("filestatus.dat");
            this.writeFile(fs, file1, 1, 16384, 8192);
            System.out.println("Created file filestatus.dat with one  replicas.");
            this.checkFile(fs, file1, 1);
            System.out.println("Path : \"" + file1 + "\"");
            FileStatus status = fs.getFileStatus(file1);
            Assert.assertTrue((String)(file1 + " should be a file"), (!status.isDir() ? 1 : 0) != 0);
            Assert.assertTrue((status.getBlockSize() == 8192L ? 1 : 0) != 0);
            Assert.assertTrue((status.getReplication() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((status.getLen() == 16384L ? 1 : 0) != 0);
            Assert.assertEquals((Object)fs.makeQualified(file1).toString(), (Object)status.getPath().toString());
            DFSClient.DFSDataInputStream fin = (DFSClient.DFSDataInputStream)fs.open(file1);
            Assert.assertEquals((long)status.getLen(), (long)fin.getVisibleLength());
            FileStatus[] stats = fs.listStatus(file1);
            Assert.assertEquals((long)1L, (long)stats.length);
            status = stats[0];
            Assert.assertTrue((String)(file1 + " should be a file"), (!status.isDir() ? 1 : 0) != 0);
            Assert.assertTrue((status.getBlockSize() == 8192L ? 1 : 0) != 0);
            Assert.assertTrue((status.getReplication() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((status.getLen() == 16384L ? 1 : 0) != 0);
            Assert.assertEquals((Object)fs.makeQualified(file1).toString(), (Object)status.getPath().toString());
            Path dir = new Path("/test/mkdirs");
            stats = fs.listStatus(dir);
            Assert.assertTrue((null == stats ? 1 : 0) != 0);
            try {
                status = fs.getFileStatus(dir);
                Assert.fail((String)"getFileStatus of non-existent path should fail");
            }
            catch (FileNotFoundException fe) {
                Assert.assertTrue((boolean)fe.getMessage().startsWith("File does not exist"));
            }
            Assert.assertTrue((boolean)fs.mkdirs(dir));
            Assert.assertTrue((boolean)fs.exists(dir));
            System.out.println("Dir : \"" + dir + "\"");
            status = fs.getFileStatus(dir);
            Assert.assertTrue((String)(dir + " should be a directory"), (boolean)status.isDir());
            Assert.assertTrue((String)(dir + " should be zero size "), (status.getLen() == 0L ? 1 : 0) != 0);
            Assert.assertEquals((Object)fs.makeQualified(dir).toString(), (Object)status.getPath().toString());
            stats = fs.listStatus(dir);
            Assert.assertEquals((String)(dir + " should be empty"), (long)0L, (long)stats.length);
            Assert.assertEquals((String)(dir + " should be zero size "), (long)0L, (long)fs.getContentSummary(dir).getLength());
            Assert.assertEquals((String)(dir + " should be zero size using hftp"), (long)0L, (long)hftpfs.getContentSummary(dir).getLength());
            Assert.assertTrue((String)(dir + " should be zero size "), (fs.getFileStatus(dir).getLen() == 0L ? 1 : 0) != 0);
            System.out.println("Dir : \"" + dir + "\"");
            Path file2 = new Path(dir, "filestatus2.dat");
            this.writeFile(fs, file2, 1, 2048, 8192);
            System.out.println("Created file filestatus2.dat with one  replicas.");
            this.checkFile(fs, file2, 1);
            System.out.println("Path : \"" + file2 + "\"");
            status = fs.getFileStatus(file2);
            Assert.assertTrue((status.getBlockSize() == 8192L ? 1 : 0) != 0);
            Assert.assertTrue((status.getReplication() == 1 ? 1 : 0) != 0);
            file2 = fs.makeQualified(file2);
            Assert.assertEquals((Object)file2.toString(), (Object)status.getPath().toString());
            Path file3 = new Path(dir, "filestatus3.dat");
            this.writeFile(fs, file3, 1, 2048, 8192);
            System.out.println("Created file filestatus3.dat with one  replicas.");
            this.checkFile(fs, file3, 1);
            file3 = fs.makeQualified(file3);
            int expected = 4096;
            Assert.assertEquals((String)(dir + " size should be " + 4096), (long)4096L, (long)fs.getContentSummary(dir).getLength());
            Assert.assertEquals((String)(dir + " size should be " + 4096 + " using hftp"), (long)4096L, (long)hftpfs.getContentSummary(dir).getLength());
            stats = fs.listStatus(dir);
            Assert.assertEquals((String)(dir + " should have two entries"), (long)2L, (long)stats.length);
            Assert.assertEquals((Object)file2.toString(), (Object)stats[0].getPath().toString());
            Assert.assertEquals((Object)file3.toString(), (Object)stats[1].getPath().toString());
            Path dir3 = fs.makeQualified(new Path(dir, "dir3"));
            fs.mkdirs(dir3);
            dir3 = fs.makeQualified(dir3);
            stats = fs.listStatus(dir);
            Assert.assertEquals((String)(dir + " should have three entries"), (long)3L, (long)stats.length);
            Assert.assertEquals((Object)dir3.toString(), (Object)stats[0].getPath().toString());
            Assert.assertEquals((Object)file2.toString(), (Object)stats[1].getPath().toString());
            Assert.assertEquals((Object)file3.toString(), (Object)stats[2].getPath().toString());
            Path dir4 = fs.makeQualified(new Path(dir, "dir4"));
            fs.mkdirs(dir4);
            dir4 = fs.makeQualified(dir4);
            Path dir5 = fs.makeQualified(new Path(dir, "dir5"));
            fs.mkdirs(dir5);
            dir5 = fs.makeQualified(dir5);
            stats = fs.listStatus(dir);
            Assert.assertEquals((String)(dir + " should have five entries"), (long)5L, (long)stats.length);
            Assert.assertEquals((Object)dir3.toString(), (Object)stats[0].getPath().toString());
            Assert.assertEquals((Object)dir4.toString(), (Object)stats[1].getPath().toString());
            Assert.assertEquals((Object)dir5.toString(), (Object)stats[2].getPath().toString());
            Assert.assertEquals((Object)file2.toString(), (Object)stats[3].getPath().toString());
            Assert.assertEquals((Object)file3.toString(), (Object)stats[4].getPath().toString());
            fs.setPermission(dir, new FsPermission(0));
            try {
                String username = UserGroupInformation.getCurrentUser().getShortUserName() + "1";
                HftpFileSystem hftp2 = cluster.getHftpFileSystemAs(username, conf, "somegroup");
                hftp2.getContentSummary(dir);
                Assert.fail();
            }
            catch (IOException ioe) {
                FileSystem.LOG.info((Object)"GOOD: getting an exception", (Throwable)ioe);
            }
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }
}

