/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.hdfs.tools.DFSAdmin;

public class TestCheckpoint
extends TestCase {
    static final long seed = 3735928559L;
    static final int blockSize = 4096;
    static final int fileSize = 8192;
    static final int numDatanodes = 3;
    short replication = (short)3;

    private void writeFile(FileSystem fileSys, Path name, int repl) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 4096L);
        byte[] buffer = new byte[8192];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
    }

    private void checkFile(FileSystem fileSys, Path name, int repl) throws IOException {
        TestCheckpoint.assertTrue((boolean)fileSys.exists(name));
        short replication = fileSys.getFileStatus(name).getReplication();
        TestCheckpoint.assertEquals((String)("replication for " + name), (int)repl, (int)replication);
    }

    private void cleanupFile(FileSystem fileSys, Path name) throws IOException {
        TestCheckpoint.assertTrue((boolean)fileSys.exists(name));
        fileSys.delete(name, true);
        TestCheckpoint.assertTrue((!fileSys.exists(name) ? 1 : 0) != 0);
    }

    private void resurrectNameDir(File namedir) throws IOException {
        String name;
        String parentdir = namedir.getParent();
        File oldname = new File(parentdir, (name = namedir.getName()) + ".old");
        if (!oldname.renameTo(namedir)) {
            TestCheckpoint.assertTrue((boolean)false);
        }
    }

    private void removeOneNameDir(File namedir) throws IOException {
        String name;
        String parentdir = namedir.getParent();
        File newname = new File(parentdir, (name = namedir.getName()) + ".old");
        if (!namedir.renameTo(newname)) {
            TestCheckpoint.assertTrue((boolean)false);
        }
    }

    private void testNamedirError(Configuration conf, Collection<File> namedirs) throws IOException {
        System.out.println("Starting testNamedirError");
        MiniDFSCluster cluster = null;
        if (namedirs.size() <= 1) {
            return;
        }
        File first = namedirs.iterator().next();
        this.removeOneNameDir(first);
        try {
            cluster = new MiniDFSCluster(conf, 0, false, null);
            cluster.shutdown();
            TestCheckpoint.assertTrue((boolean)false);
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.resurrectNameDir(first);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSecondaryNamenodeError1(Configuration conf) throws IOException {
        Storage.StorageDirectory sd;
        System.out.println("Starting testSecondaryNamenodeError 1");
        Path file1 = new Path("checkpointxx.dat");
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 3, false, null);
        cluster.waitActive();
        FileSystem fileSys = cluster.getFileSystem();
        try {
            TestCheckpoint.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            SecondaryNameNode secondary = this.startSecondaryNameNode(conf);
            SecondaryNameNode.ErrorSimulator.setErrorSimulation((int)0);
            try {
                secondary.doCheckpoint();
                TestCheckpoint.assertTrue((boolean)false);
            }
            catch (IOException e) {
                // empty catch block
            }
            SecondaryNameNode.ErrorSimulator.clearErrorSimulation((int)0);
            secondary.shutdown();
            this.writeFile(fileSys, file1, this.replication);
            this.checkFile(fileSys, file1, this.replication);
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
        System.out.println("Starting testSecondaryNamenodeError 2");
        cluster = new MiniDFSCluster(conf, 3, false, null);
        cluster.waitActive();
        FSImage image = cluster.getNameNode().getFSImage();
        Iterator it = image.dirIterator((Storage.StorageDirType)FSImage.NameNodeDirType.IMAGE);
        while (it.hasNext()) {
            sd = (Storage.StorageDirectory)it.next();
            TestCheckpoint.assertFalse((boolean)FSImage.getImageFile((Storage.StorageDirectory)sd, (FSImage.NameNodeFile)FSImage.NameNodeFile.IMAGE_NEW).exists());
        }
        it = image.dirIterator((Storage.StorageDirType)FSImage.NameNodeDirType.EDITS);
        while (it.hasNext()) {
            sd = (Storage.StorageDirectory)it.next();
            TestCheckpoint.assertFalse((boolean)image.getEditNewFile(sd).exists());
            File edits = image.getEditFile(sd);
            TestCheckpoint.assertTrue((boolean)edits.exists());
            long editsLen = edits.length();
            TestCheckpoint.assertTrue((editsLen == 4L ? 1 : 0) != 0);
        }
        fileSys = cluster.getFileSystem();
        try {
            this.checkFile(fileSys, file1, this.replication);
            this.cleanupFile(fileSys, file1);
            SecondaryNameNode secondary = this.startSecondaryNameNode(conf);
            secondary.doCheckpoint();
            secondary.shutdown();
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSecondaryNamenodeError2(Configuration conf) throws IOException {
        SecondaryNameNode secondary;
        System.out.println("Starting testSecondaryNamenodeError 21");
        Path file1 = new Path("checkpointyy.dat");
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 3, false, null);
        cluster.waitActive();
        FileSystem fileSys = cluster.getFileSystem();
        try {
            TestCheckpoint.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            secondary = this.startSecondaryNameNode(conf);
            SecondaryNameNode.ErrorSimulator.setErrorSimulation((int)1);
            try {
                secondary.doCheckpoint();
                TestCheckpoint.assertTrue((boolean)false);
            }
            catch (IOException e) {
                // empty catch block
            }
            SecondaryNameNode.ErrorSimulator.clearErrorSimulation((int)1);
            secondary.shutdown();
            this.writeFile(fileSys, file1, this.replication);
            this.checkFile(fileSys, file1, this.replication);
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
        System.out.println("Starting testSecondaryNamenodeError 22");
        cluster = new MiniDFSCluster(conf, 3, false, null);
        cluster.waitActive();
        fileSys = cluster.getFileSystem();
        try {
            this.checkFile(fileSys, file1, this.replication);
            this.cleanupFile(fileSys, file1);
            secondary = this.startSecondaryNameNode(conf);
            secondary.doCheckpoint();
            secondary.shutdown();
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSecondaryNamenodeError3(Configuration conf) throws IOException {
        SecondaryNameNode secondary;
        System.out.println("Starting testSecondaryNamenodeError 31");
        Path file1 = new Path("checkpointzz.dat");
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 3, false, null);
        cluster.waitActive();
        FileSystem fileSys = cluster.getFileSystem();
        try {
            TestCheckpoint.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            secondary = this.startSecondaryNameNode(conf);
            SecondaryNameNode.ErrorSimulator.setErrorSimulation((int)0);
            try {
                secondary.doCheckpoint();
                TestCheckpoint.assertTrue((boolean)false);
            }
            catch (IOException e) {
                // empty catch block
            }
            SecondaryNameNode.ErrorSimulator.clearErrorSimulation((int)0);
            secondary.shutdown();
            secondary = this.startSecondaryNameNode(conf);
            secondary.doCheckpoint();
            secondary.shutdown();
            this.writeFile(fileSys, file1, this.replication);
            this.checkFile(fileSys, file1, this.replication);
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
        System.out.println("Starting testSecondaryNamenodeError 32");
        cluster = new MiniDFSCluster(conf, 3, false, null);
        cluster.waitActive();
        fileSys = cluster.getFileSystem();
        try {
            this.checkFile(fileSys, file1, this.replication);
            this.cleanupFile(fileSys, file1);
            secondary = this.startSecondaryNameNode(conf);
            secondary.doCheckpoint();
            secondary.shutdown();
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testSecondaryFailsToReturnImage(Configuration conf) throws IOException {
        System.out.println("Starting testSecondaryFailsToReturnImage");
        Path file1 = new Path("checkpointRI.dat");
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 3, false, null);
        cluster.waitActive();
        FileSystem fileSys = cluster.getFileSystem();
        FSImage image = cluster.getNameNode().getFSImage();
        try {
            TestCheckpoint.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            Storage.StorageDirectory sd = null;
            Iterator it = image.dirIterator((Storage.StorageDirType)FSImage.NameNodeDirType.IMAGE);
            while (it.hasNext()) {
                sd = (Storage.StorageDirectory)it.next();
            }
            TestCheckpoint.assertTrue((sd != null ? 1 : 0) != 0);
            long fsimageLength = FSImage.getImageFile((Storage.StorageDirectory)sd, (FSImage.NameNodeFile)FSImage.NameNodeFile.IMAGE).length();
            SecondaryNameNode secondary = this.startSecondaryNameNode(conf);
            SecondaryNameNode.ErrorSimulator.setErrorSimulation((int)2);
            try {
                secondary.doCheckpoint();
                TestCheckpoint.assertTrue((boolean)false);
            }
            catch (IOException e) {
                System.out.println("testSecondaryFailsToReturnImage: doCheckpoint() failed predictably - " + e);
            }
            SecondaryNameNode.ErrorSimulator.clearErrorSimulation((int)2);
            Iterator it2 = image.dirIterator((Storage.StorageDirType)FSImage.NameNodeDirType.IMAGE);
            while (it2.hasNext()) {
                TestCheckpoint.assertTrue((FSImage.getImageFile((Storage.StorageDirectory)((Storage.StorageDirectory)it2.next()), (FSImage.NameNodeFile)FSImage.NameNodeFile.IMAGE).length() == fsimageLength ? 1 : 0) != 0);
            }
            secondary.shutdown();
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
    }

    void testStartup(Configuration conf) throws IOException {
        System.out.println("Startup of the name-node in the checkpoint directory.");
        String primaryDirs = conf.get("dfs.name.dir");
        String primaryEditsDirs = conf.get("dfs.name.edits.dir");
        String checkpointDirs = conf.get("fs.checkpoint.dir");
        String checkpointEditsDirs = conf.get("fs.checkpoint.edits.dir");
        NameNode nn = this.startNameNode(conf, checkpointDirs, checkpointEditsDirs, HdfsConstants.StartupOption.REGULAR);
        System.out.println("Startup of secondary in the same dir as the primary.");
        SecondaryNameNode secondary = null;
        try {
            secondary = this.startSecondaryNameNode(conf);
            TestCheckpoint.assertFalse((boolean)secondary.getFSImage().isLockSupported(0));
            secondary.shutdown();
        }
        catch (IOException e) {
            TestCheckpoint.assertTrue((secondary == null ? 1 : 0) != 0);
        }
        nn.stop();
        nn = null;
        System.out.println("Startup of primary in the same dir as the secondary.");
        nn = this.startNameNode(conf, primaryDirs, primaryEditsDirs, HdfsConstants.StartupOption.REGULAR);
        boolean succeed = false;
        do {
            try {
                secondary = this.startSecondaryNameNode(conf);
                succeed = true;
            }
            catch (IOException ie) {
                System.out.println("Try again: " + ie.getLocalizedMessage());
            }
        } while (!succeed);
        nn.stop();
        nn = null;
        try {
            nn = this.startNameNode(conf, checkpointDirs, checkpointEditsDirs, HdfsConstants.StartupOption.REGULAR);
            TestCheckpoint.assertFalse((boolean)nn.getFSImage().isLockSupported(0));
            nn.stop();
            nn = null;
        }
        catch (IOException e) {
            TestCheckpoint.assertTrue((nn == null ? 1 : 0) != 0);
        }
        System.out.println("Startup of two secondaries in the same dir.");
        nn = this.startNameNode(conf, primaryDirs, primaryEditsDirs, HdfsConstants.StartupOption.REGULAR);
        SecondaryNameNode secondary2 = null;
        try {
            secondary2 = this.startSecondaryNameNode(conf);
            TestCheckpoint.assertFalse((boolean)secondary2.getFSImage().isLockSupported(0));
            secondary2.shutdown();
        }
        catch (IOException e) {
            TestCheckpoint.assertTrue((secondary2 == null ? 1 : 0) != 0);
        }
        nn.stop();
        nn = null;
        secondary.shutdown();
        System.out.println("Import a checkpoint with existing primary image.");
        try {
            nn = this.startNameNode(conf, primaryDirs, primaryEditsDirs, HdfsConstants.StartupOption.IMPORT);
            TestCheckpoint.assertTrue((boolean)false);
        }
        catch (IOException e) {
            TestCheckpoint.assertTrue((nn == null ? 1 : 0) != 0);
        }
        System.out.println("Import a checkpoint with existing primary image.");
        List nameDirs = (List)FSNamesystem.getNamespaceDirs((Configuration)conf);
        List nameEditsDirs = (List)FSNamesystem.getNamespaceEditsDirs((Configuration)conf);
        long fsimageLength = new File(new File((File)nameDirs.get(0), "current"), FSImage.NameNodeFile.IMAGE.getName()).length();
        for (File dir : nameDirs) {
            if (dir.exists() && !FileUtil.fullyDelete((File)dir)) {
                throw new IOException("Cannot remove directory: " + dir);
            }
            if (dir.mkdirs()) continue;
            throw new IOException("Cannot create directory " + dir);
        }
        for (File dir : nameEditsDirs) {
            if (dir.exists() && !FileUtil.fullyDelete((File)dir)) {
                throw new IOException("Cannot remove directory: " + dir);
            }
            if (dir.mkdirs()) continue;
            throw new IOException("Cannot create directory " + dir);
        }
        nn = this.startNameNode(conf, primaryDirs, primaryEditsDirs, HdfsConstants.StartupOption.IMPORT);
        FSImage image = nn.getFSImage();
        Iterator it = image.dirIterator((Storage.StorageDirType)FSImage.NameNodeDirType.IMAGE);
        while (it.hasNext()) {
            TestCheckpoint.assertTrue((FSImage.getImageFile((Storage.StorageDirectory)((Storage.StorageDirectory)it.next()), (FSImage.NameNodeFile)FSImage.NameNodeFile.IMAGE).length() == fsimageLength ? 1 : 0) != 0);
        }
        nn.stop();
        nn = this.startNameNode(conf, primaryDirs, primaryEditsDirs, HdfsConstants.StartupOption.REGULAR);
        Collection secondaryDirs = FSImage.getCheckpointDirs((Configuration)conf, null);
        for (File dir : secondaryDirs) {
            Storage.rename((File)new File(dir, "current"), (File)new File(dir, "lastcheckpoint.tmp"));
        }
        secondary = this.startSecondaryNameNode(conf);
        secondary.shutdown();
        for (File dir : secondaryDirs) {
            TestCheckpoint.assertTrue((boolean)new File(dir, "current").exists());
            TestCheckpoint.assertFalse((boolean)new File(dir, "lastcheckpoint.tmp").exists());
        }
        for (File dir : secondaryDirs) {
            Storage.rename((File)new File(dir, "previous.checkpoint"), (File)new File(dir, "lastcheckpoint.tmp"));
        }
        secondary = this.startSecondaryNameNode(conf);
        secondary.shutdown();
        for (File dir : secondaryDirs) {
            TestCheckpoint.assertTrue((boolean)new File(dir, "current").exists());
            TestCheckpoint.assertTrue((boolean)new File(dir, "previous.checkpoint").exists());
            TestCheckpoint.assertFalse((boolean)new File(dir, "lastcheckpoint.tmp").exists());
        }
        nn.stop();
        nn = null;
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 3, false, null);
        cluster.waitActive();
        cluster.shutdown();
    }

    NameNode startNameNode(Configuration conf, String imageDirs, String editsDirs, HdfsConstants.StartupOption start) throws IOException {
        conf.set("fs.default.name", "hdfs://localhost:0");
        conf.set("dfs.http.address", "0.0.0.0:0");
        conf.set("dfs.name.dir", imageDirs);
        conf.set("dfs.name.edits.dir", editsDirs);
        String[] args = new String[]{start.getName()};
        NameNode nn = NameNode.createNameNode((String[])args, (Configuration)conf);
        TestCheckpoint.assertTrue((boolean)nn.isInSafeMode());
        return nn;
    }

    SecondaryNameNode startSecondaryNameNode(Configuration conf) throws IOException {
        conf.set("dfs.secondary.http.address", "0.0.0.0:0");
        return new SecondaryNameNode(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCheckpoint() throws IOException {
        SecondaryNameNode secondary;
        Path file1 = new Path("checkpoint.dat");
        Path file2 = new Path("checkpoint2.dat");
        Collection<File> namedirs = null;
        Configuration conf = new Configuration();
        conf.set("dfs.secondary.http.address", "0.0.0.0:0");
        this.replication = (short)conf.getInt("dfs.replication", 3);
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 3, true, null);
        cluster.waitActive();
        FileSystem fileSys = cluster.getFileSystem();
        try {
            TestCheckpoint.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            TestCheckpoint.assertTrue((!fileSys.exists(file2) ? 1 : 0) != 0);
            namedirs = cluster.getNameDirs();
            this.writeFile(fileSys, file1, this.replication);
            this.checkFile(fileSys, file1, this.replication);
            secondary = this.startSecondaryNameNode(conf);
            SecondaryNameNode.ErrorSimulator.initializeErrorSimulationEvent((int)3);
            secondary.doCheckpoint();
            secondary.shutdown();
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
        cluster = new MiniDFSCluster(conf, 3, false, null);
        cluster.waitActive();
        fileSys = cluster.getFileSystem();
        try {
            this.checkFile(fileSys, file1, this.replication);
            this.cleanupFile(fileSys, file1);
            this.writeFile(fileSys, file2, this.replication);
            this.checkFile(fileSys, file2, this.replication);
            secondary = this.startSecondaryNameNode(conf);
            secondary.doCheckpoint();
            secondary.shutdown();
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
        cluster = new MiniDFSCluster(conf, 3, false, null);
        cluster.waitActive();
        fileSys = cluster.getFileSystem();
        TestCheckpoint.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
        try {
            this.checkFile(fileSys, file2, this.replication);
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
        this.testSecondaryNamenodeError1(conf);
        this.testSecondaryNamenodeError2(conf);
        this.testSecondaryNamenodeError3(conf);
        this.testNamedirError(conf, namedirs);
        this.testSecondaryFailsToReturnImage(conf);
        this.testStartup(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaveNamespace() throws IOException {
        MiniDFSCluster cluster = null;
        DistributedFileSystem fs = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster(conf, 3, false, null);
            cluster.waitActive();
            fs = (DistributedFileSystem)cluster.getFileSystem();
            DFSAdmin admin = new DFSAdmin(conf);
            String[] args = new String[]{"-saveNamespace"};
            try {
                admin.run(args);
            }
            catch (IOException eIO) {
                TestCheckpoint.assertTrue((boolean)eIO.getLocalizedMessage().contains("Safe mode should be turned ON"));
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            Path file = new Path("namespace.dat");
            this.writeFile((FileSystem)fs, file, this.replication);
            this.checkFile((FileSystem)fs, file, this.replication);
            Collection<File> editsDirs = cluster.getNameEditsDirs();
            for (File ed : editsDirs) {
                TestCheckpoint.assertTrue((new File(ed, "current/edits").length() > 4L ? 1 : 0) != 0);
            }
            fs.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_ENTER);
            try {
                admin.run(args);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            for (File ed : editsDirs) {
                TestCheckpoint.assertTrue((new File(ed, "current/edits").length() == 4L ? 1 : 0) != 0);
            }
            cluster.shutdown();
            cluster = null;
            cluster = new MiniDFSCluster(conf, 3, false, null);
            cluster.waitActive();
            fs = (DistributedFileSystem)cluster.getFileSystem();
            this.checkFile((FileSystem)fs, file, this.replication);
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

