/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;

public class TestComputeInvalidateWork
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCompInvalidate() throws Exception {
        Configuration conf = new Configuration();
        int NUM_OF_DATANODES = 3;
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 3, true, null);
        try {
            cluster.waitActive();
            FSNamesystem namesystem = cluster.getNameNode().getNamesystem();
            DatanodeDescriptor[] nodes = namesystem.heartbeats.toArray(new DatanodeDescriptor[3]);
            TestComputeInvalidateWork.assertEquals((int)nodes.length, (int)3);
            FSNamesystem fSNamesystem = namesystem;
            synchronized (fSNamesystem) {
                for (int i = 0; i < nodes.length; ++i) {
                    for (int j = 0; j < 3 * namesystem.blockInvalidateLimit + 1; ++j) {
                        Block block = new Block((long)(i * (namesystem.blockInvalidateLimit + 1) + j), 0L, 1000L);
                        namesystem.addToInvalidatesNoLog(block, (DatanodeInfo)nodes[i]);
                    }
                }
                TestComputeInvalidateWork.assertEquals((int)(namesystem.blockInvalidateLimit * 3), (int)namesystem.computeInvalidateWork(4));
                TestComputeInvalidateWork.assertEquals((int)(namesystem.blockInvalidateLimit * 3), (int)namesystem.computeInvalidateWork(3));
                TestComputeInvalidateWork.assertEquals((int)(namesystem.blockInvalidateLimit * 2), (int)namesystem.computeInvalidateWork(2));
                int workCount = namesystem.computeInvalidateWork(1);
                if (workCount == 1) {
                    TestComputeInvalidateWork.assertEquals((int)(namesystem.blockInvalidateLimit + 1), (int)namesystem.computeInvalidateWork(2));
                } else {
                    TestComputeInvalidateWork.assertEquals((int)workCount, (int)namesystem.blockInvalidateLimit);
                    TestComputeInvalidateWork.assertEquals((int)2, (int)namesystem.computeInvalidateWork(2));
                }
            }
        }
        finally {
            cluster.shutdown();
        }
    }
}

