/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestMetaSave {
    static final int NUM_DATA_NODES = 2;
    static final long seed = 3735928559L;
    static final int blockSize = 8192;
    private static MiniDFSCluster cluster = null;
    private static FileSystem fileSys = null;

    private void createFile(FileSystem fileSys, Path name) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)2, 8192L);
        byte[] buffer = new byte[1024];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
    }

    @BeforeClass
    public static void setUp() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("dfs.replication.interval", 1000);
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setLong("heartbeat.recheck.interval", 1L);
        cluster = new MiniDFSCluster(conf, 2, true, null);
        cluster.waitActive();
        fileSys = cluster.getFileSystem();
    }

    @Test
    public void testMetaSave() throws IOException, InterruptedException {
        FSNamesystem namesystem = cluster.getNameNode().getNamesystem();
        for (int i = 0; i < 2; ++i) {
            Path file = new Path("/filestatus" + i);
            this.createFile(fileSys, file);
        }
        cluster.stopDataNode(1);
        Thread.sleep(15000L);
        namesystem.setReplication("/filestatus0", (short)4);
        namesystem.metaSave("metasave.out.txt");
        String logFile = System.getProperty("hadoop.log.dir") + "/" + "metasave.out.txt";
        FileInputStream fstream = new FileInputStream(logFile);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String line = reader.readLine();
        Assert.assertTrue((boolean)line.equals("3 files and directories, 2 blocks = 5 total"));
        line = reader.readLine();
        Assert.assertTrue((boolean)line.equals("Live Datanodes: 1"));
        line = reader.readLine();
        Assert.assertTrue((boolean)line.equals("Dead Datanodes: 1"));
        line = reader.readLine();
        line = reader.readLine();
        Assert.assertTrue((boolean)line.matches("^/filestatus[01]:.*"));
    }

    @AfterClass
    public static void tearDown() throws IOException {
        if (fileSys != null) {
            fileSys.close();
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }
}

