/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class Timer {
    long startTimeEpoch;
    long finishTimeEpoch;
    private DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public void startTime() throws IOException {
        this.startTimeEpoch = System.currentTimeMillis();
    }

    public void stopTime() throws IOException {
        this.finishTimeEpoch = System.currentTimeMillis();
    }

    public long getIntervalMillis() throws IOException {
        return this.finishTimeEpoch - this.startTimeEpoch;
    }

    public void printlnWithTimestamp(String message) throws IOException {
        System.out.println(this.formatCurrentTime() + "  " + message);
    }

    public String formatTime(long millis) {
        return this.formatter.format(millis);
    }

    public String getIntervalString() throws IOException {
        long time = this.getIntervalMillis();
        return this.formatTime(time);
    }

    public String formatCurrentTime() {
        return this.formatTime(System.currentTimeMillis());
    }
}

