/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.WordCount;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class TestJobCounters
extends TestCase {
    String TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", File.separator + "tmp")).toString().replace(' ', '+');

    private void validateMapredFileCounters(org.apache.hadoop.mapred.Counters counter, long mapInputBytes, long fileBytesRead, long fileBytesWritten, long mapOutputBytes, long mapOutputMaterializedBytes) {
        TestJobCounters.assertTrue((counter.findCounter((Enum)Task.Counter.MAP_INPUT_BYTES).getValue() != 0L ? 1 : 0) != 0);
        TestJobCounters.assertEquals((long)mapInputBytes, (long)counter.findCounter((Enum)Task.Counter.MAP_INPUT_BYTES).getValue());
        TestJobCounters.assertTrue((counter.findCounter((Enum)FileInputFormat.Counter.BYTES_READ).getValue() != 0L ? 1 : 0) != 0);
        TestJobCounters.assertEquals((long)fileBytesRead, (long)counter.findCounter((Enum)FileInputFormat.Counter.BYTES_READ).getValue());
        TestJobCounters.assertTrue((counter.findCounter((Enum)FileOutputFormat.Counter.BYTES_WRITTEN).getValue() != 0L ? 1 : 0) != 0);
        if (mapOutputBytes >= 0L) {
            TestJobCounters.assertTrue((counter.findCounter((Enum)Task.Counter.MAP_OUTPUT_BYTES).getValue() != 0L ? 1 : 0) != 0);
        }
        if (mapOutputMaterializedBytes >= 0L) {
            TestJobCounters.assertTrue((counter.findCounter((Enum)Task.Counter.MAP_OUTPUT_MATERIALIZED_BYTES).getValue() != 0L ? 1 : 0) != 0);
        }
    }

    private void validateMapredCounters(org.apache.hadoop.mapred.Counters counter, long spillRecCnt, long mapInputRecords, long mapOutputRecords) {
        TestJobCounters.assertEquals((long)spillRecCnt, (long)counter.findCounter((Enum)Task.Counter.SPILLED_RECORDS).getCounter());
        TestJobCounters.assertEquals((long)mapInputRecords, (long)counter.findCounter((Enum)Task.Counter.MAP_INPUT_RECORDS).getCounter());
        TestJobCounters.assertEquals((long)mapOutputRecords, (long)counter.findCounter((Enum)Task.Counter.MAP_OUTPUT_RECORDS).getCounter());
    }

    private void validateFileCounters(Counters counter, long fileBytesRead, long fileBytesWritten, long mapOutputBytes, long mapOutputMaterializedBytes) {
        TestJobCounters.assertTrue((counter.findCounter((Enum)FileInputFormat.Counter.BYTES_READ).getValue() != 0L ? 1 : 0) != 0);
        TestJobCounters.assertEquals((long)fileBytesRead, (long)counter.findCounter((Enum)FileInputFormat.Counter.BYTES_READ).getValue());
        TestJobCounters.assertTrue((counter.findCounter((Enum)FileOutputFormat.Counter.BYTES_WRITTEN).getValue() != 0L ? 1 : 0) != 0);
        if (mapOutputBytes >= 0L) {
            TestJobCounters.assertTrue((counter.findCounter((Enum)Task.Counter.MAP_OUTPUT_BYTES).getValue() != 0L ? 1 : 0) != 0);
        }
        if (mapOutputMaterializedBytes >= 0L) {
            TestJobCounters.assertTrue((counter.findCounter((Enum)Task.Counter.MAP_OUTPUT_MATERIALIZED_BYTES).getValue() != 0L ? 1 : 0) != 0);
        }
    }

    private void validateCounters(Counters counter, long spillRecCnt, long mapInputRecords, long mapOutputRecords) {
        TestJobCounters.assertEquals((long)spillRecCnt, (long)counter.findCounter((Enum)Task.Counter.SPILLED_RECORDS).getValue());
        TestJobCounters.assertEquals((long)mapInputRecords, (long)counter.findCounter((Enum)Task.Counter.MAP_INPUT_RECORDS).getValue());
        TestJobCounters.assertEquals((long)mapOutputRecords, (long)counter.findCounter((Enum)Task.Counter.MAP_OUTPUT_RECORDS).getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createWordsFile(File inpFile) throws Exception {
        BufferedWriter out = new BufferedWriter(new FileWriter(inpFile));
        try {
            int REPLICAS = 5;
            int NUMLINES = 500;
            int NUMWORDSPERLINE = 4;
            for (int i = 0; i < REPLICAS; ++i) {
                for (int j = 1; j <= NUMLINES * NUMWORDSPERLINE; j += NUMWORDSPERLINE) {
                    out.write("word" + j + " word" + (j + 1) + " word" + (j + 2) + " word" + (j + 3) + '\n');
                }
            }
        }
        finally {
            ((Writer)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOldJobWithMapAndReducers() throws Exception {
        JobConf conf = new JobConf(TestJobCounters.class);
        conf.setJobName("wordcount-map-reducers");
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(IntWritable.class);
        conf.setMapperClass(WordCount.MapClass.class);
        conf.setCombinerClass(WordCount.Reduce.class);
        conf.setReducerClass(WordCount.Reduce.class);
        conf.setNumMapTasks(3);
        conf.setNumReduceTasks(1);
        conf.setInt("io.sort.mb", 1);
        conf.setInt("io.sort.factor", 2);
        conf.set("io.sort.record.percent", "0.05");
        conf.set("io.sort.spill.percent", "0.80");
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path testDir = new Path(this.TEST_ROOT_DIR, "countertest");
        conf.set("test.build.data", testDir.toString());
        try {
            if (fs.exists(testDir)) {
                fs.delete(testDir, true);
            }
            if (!fs.mkdirs(testDir)) {
                throw new IOException("Mkdirs failed to create " + testDir.toString());
            }
            String inDir = testDir + File.separator + "genins" + File.separator;
            String outDir = testDir + File.separator;
            Path wordsIns = new Path(inDir);
            if (!fs.mkdirs(wordsIns)) {
                throw new IOException("Mkdirs failed to create " + wordsIns.toString());
            }
            long inputSize = 0L;
            File inpFile = new File(inDir + "input5_2k_1");
            this.createWordsFile(inpFile);
            inputSize += inpFile.length();
            inpFile = new File(inDir + "input5_2k_2");
            this.createWordsFile(inpFile);
            inputSize += inpFile.length();
            inpFile = new File(inDir + "input5_2k_3");
            this.createWordsFile(inpFile);
            inputSize += inpFile.length();
            FileInputFormat.setInputPaths((JobConf)conf, (String)inDir);
            Path outputPath1 = new Path(outDir, "output5_2k_3");
            FileOutputFormat.setOutputPath((JobConf)conf, (Path)outputPath1);
            RunningJob myJob = JobClient.runJob((JobConf)conf);
            org.apache.hadoop.mapred.Counters c1 = myJob.getCounters();
            this.validateMapredCounters(c1, 64000L, 7500L, 30000L);
            this.validateMapredFileCounters(c1, inputSize, inputSize, 0L, 0L, 0L);
            inpFile = new File(inDir + "input5_2k_4");
            this.createWordsFile(inpFile);
            inputSize += inpFile.length();
            conf.setNumMapTasks(4);
            Path outputPath2 = new Path(outDir, "output5_2k_4");
            FileOutputFormat.setOutputPath((JobConf)conf, (Path)outputPath2);
            myJob = JobClient.runJob((JobConf)conf);
            c1 = myJob.getCounters();
            this.validateMapredCounters(c1, 88000L, 10000L, 40000L);
            this.validateMapredFileCounters(c1, inputSize, inputSize, 0L, 0L, 0L);
            conf.setNumReduceTasks(0);
            Path outputPath3 = new Path(outDir, "output5_2k_5");
            FileOutputFormat.setOutputPath((JobConf)conf, (Path)outputPath3);
            myJob = JobClient.runJob((JobConf)conf);
            c1 = myJob.getCounters();
            this.validateMapredCounters(c1, 0L, 10000L, 40000L);
            this.validateMapredFileCounters(c1, inputSize, inputSize, 0L, -1L, -1L);
        }
        finally {
            if (fs.exists(testDir)) {
                fs.delete(testDir, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNewJobWithMapAndReducers() throws Exception {
        JobConf conf = new JobConf(TestJobCounters.class);
        conf.setInt("io.sort.mb", 1);
        conf.setInt("io.sort.factor", 2);
        conf.set("io.sort.record.percent", "0.05");
        conf.set("io.sort.spill.percent", "0.80");
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path testDir = new Path(this.TEST_ROOT_DIR, "countertest2");
        conf.set("test.build.data", testDir.toString());
        try {
            if (fs.exists(testDir)) {
                fs.delete(testDir, true);
            }
            if (!fs.mkdirs(testDir)) {
                throw new IOException("Mkdirs failed to create " + testDir.toString());
            }
            String inDir = testDir + File.separator + "genins" + File.separator;
            Path wordsIns = new Path(inDir);
            if (!fs.mkdirs(wordsIns)) {
                throw new IOException("Mkdirs failed to create " + wordsIns.toString());
            }
            String outDir = testDir + File.separator;
            long inputSize = 0L;
            File inpFile = new File(inDir + "input5_2k_1");
            this.createWordsFile(inpFile);
            inputSize += inpFile.length();
            inpFile = new File(inDir + "input5_2k_2");
            this.createWordsFile(inpFile);
            inputSize += inpFile.length();
            inpFile = new File(inDir + "input5_2k_3");
            this.createWordsFile(inpFile);
            inputSize += inpFile.length();
            FileInputFormat.setInputPaths((JobConf)conf, (String)inDir);
            Path outputPath1 = new Path(outDir, "output5_2k_3");
            FileOutputFormat.setOutputPath((JobConf)conf, (Path)outputPath1);
            Job job = new Job((Configuration)conf);
            job.setJobName("wordcount-map-reducers");
            job.setOutputKeyClass(Text.class);
            job.setOutputValueClass(IntWritable.class);
            job.setMapperClass(NewMapTokenizer.class);
            job.setCombinerClass(NewIdentityReducer.class);
            job.setReducerClass(NewIdentityReducer.class);
            job.setNumReduceTasks(1);
            job.waitForCompletion(false);
            Counters c1 = job.getCounters();
            LogFactory.getLog(((Object)((Object)this)).getClass()).info((Object)c1);
            this.validateCounters(c1, 64000L, 7500L, 30000L);
            this.validateFileCounters(c1, inputSize, 0L, 0L, 0L);
            inpFile = new File(inDir + "input5_2k_4");
            this.createWordsFile(inpFile);
            inputSize += inpFile.length();
            JobConf newJobConf = new JobConf(job.getConfiguration());
            Path outputPath2 = new Path(outDir, "output5_2k_4");
            FileOutputFormat.setOutputPath((JobConf)newJobConf, (Path)outputPath2);
            Job newJob = new Job((Configuration)newJobConf);
            newJob.waitForCompletion(false);
            c1 = newJob.getCounters();
            LogFactory.getLog(((Object)((Object)this)).getClass()).info((Object)c1);
            this.validateCounters(c1, 88000L, 10000L, 40000L);
            this.validateFileCounters(c1, inputSize, 0L, 0L, 0L);
            JobConf newJobConf2 = new JobConf(newJob.getConfiguration());
            Path outputPath3 = new Path(outDir, "output5_2k_5");
            FileOutputFormat.setOutputPath((JobConf)newJobConf2, (Path)outputPath3);
            Job newJob2 = new Job((Configuration)newJobConf2);
            newJob2.setNumReduceTasks(0);
            newJob2.waitForCompletion(false);
            c1 = newJob2.getCounters();
            LogFactory.getLog(((Object)((Object)this)).getClass()).info((Object)c1);
            this.validateCounters(c1, 0L, 10000L, 40000L);
            this.validateFileCounters(c1, inputSize, 0L, -1L, -1L);
        }
        finally {
            if (fs.exists(testDir)) {
                fs.delete(testDir, true);
            }
        }
    }

    private long getTaskCounterUsage(JobClient client, JobID id, int numReports, int taskId, boolean isMap) throws Exception {
        TaskReport[] reports = null;
        reports = isMap ? client.getMapTaskReports(id) : client.getReduceTaskReports(id);
        TestJobCounters.assertNotNull((String)("No reports found for " + (isMap ? "map" : "reduce") + " tasks" + "' in job " + id), (Object)reports);
        TestJobCounters.assertEquals((String)"Mismatch in task id", (int)numReports, (int)reports.length);
        org.apache.hadoop.mapred.Counters counters = reports[taskId].getCounters();
        return counters.getCounter((Enum)Task.Counter.COMMITTED_HEAP_BYTES);
    }

    private static RunningJob runHeapUsageTestJob(JobConf conf, Path testRootDir, String heapOptions, long targetMapValue, long targetReduceValue, FileSystem fs, JobClient client, Path inDir) throws IOException {
        JobConf jobConf = new JobConf((Configuration)conf);
        jobConf.setNumMapTasks(1);
        jobConf.setNumReduceTasks(1);
        jobConf.setMapperClass(MemoryLoaderMapper.class);
        jobConf.setReducerClass(MemoryLoaderReducer.class);
        jobConf.setInputFormat(TextInputFormat.class);
        jobConf.setOutputKeyClass(LongWritable.class);
        jobConf.setOutputValueClass(Text.class);
        jobConf.setMaxMapAttempts(1);
        jobConf.setMaxReduceAttempts(1);
        jobConf.set("mapred.child.java.opts", heapOptions);
        jobConf.setLong("map.memory-loader.target-value", targetMapValue);
        jobConf.setLong("reduce.memory-loader.target-value", targetReduceValue);
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{inDir});
        Path outDir = new Path(testRootDir, "out");
        fs.delete(outDir, true);
        FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)outDir);
        RunningJob job = client.submitJob(jobConf);
        job.waitForCompletion();
        JobID jobID = job.getID();
        TestJobCounters.assertTrue((String)("Job " + jobID + " failed!"), (boolean)job.isSuccessful());
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHeapUsageCounter() throws Exception {
        JobConf conf = new JobConf();
        LocalFileSystem fileSystem = FileSystem.getLocal((Configuration)conf);
        File rootDir = new File(System.getProperty("test.build.data", "/tmp"));
        File testRootDir = new File(rootDir, "testHeapUsageCounter");
        Path testRootDirPath = new Path(testRootDir.toString());
        fileSystem.delete(testRootDirPath, true);
        fileSystem.setWorkingDirectory(testRootDirPath);
        fileSystem.deleteOnExit(testRootDirPath);
        MiniMRCluster mrCluster = new MiniMRCluster(1, fileSystem.getUri().toString(), 1);
        try {
            conf = mrCluster.createJobConf();
            JobClient jobClient = new JobClient(conf);
            File file = new File(testRootDir, "in");
            Path inDir = new Path(file.toString());
            this.createWordsFile(file);
            RunningJob lowMemJob = TestJobCounters.runHeapUsageTestJob(conf, testRootDirPath, "-Xms32m -Xmx1G", 0L, 0L, (FileSystem)fileSystem, jobClient, inDir);
            JobID lowMemJobID = lowMemJob.getID();
            long lowMemJobMapHeapUsage = this.getTaskCounterUsage(jobClient, lowMemJobID, 1, 0, true);
            System.out.println("Job1 (low memory job) map task heap usage: " + lowMemJobMapHeapUsage);
            long lowMemJobReduceHeapUsage = this.getTaskCounterUsage(jobClient, lowMemJobID, 1, 0, false);
            System.out.println("Job1 (low memory job) reduce task heap usage: " + lowMemJobReduceHeapUsage);
            RunningJob highMemJob = TestJobCounters.runHeapUsageTestJob(conf, testRootDirPath, "-Xms32m -Xmx1G", lowMemJobMapHeapUsage + 0x10000000L, lowMemJobReduceHeapUsage + 0x10000000L, (FileSystem)fileSystem, jobClient, inDir);
            JobID highMemJobID = highMemJob.getID();
            long highMemJobMapHeapUsage = this.getTaskCounterUsage(jobClient, highMemJobID, 1, 0, true);
            System.out.println("Job2 (high memory job) map task heap usage: " + highMemJobMapHeapUsage);
            long highMemJobReduceHeapUsage = this.getTaskCounterUsage(jobClient, highMemJobID, 1, 0, false);
            System.out.println("Job2 (high memory job) reduce task heap usage: " + highMemJobReduceHeapUsage);
            TestJobCounters.assertTrue((String)"Incorrect map heap usage reported by the map task", (lowMemJobMapHeapUsage < highMemJobMapHeapUsage ? 1 : 0) != 0);
            TestJobCounters.assertTrue((String)"Incorrect reduce heap usage reported by the reduce task", (lowMemJobReduceHeapUsage < highMemJobReduceHeapUsage ? 1 : 0) != 0);
        }
        finally {
            mrCluster.shutdown();
            try {
                fileSystem.delete(testRootDirPath, true);
            }
            catch (IOException ioe) {}
        }
    }

    static class MemoryLoaderReducer
    extends MapReduceBase
    implements Reducer<WritableComparable, Writable, WritableComparable, Writable> {
        static final String TARGET_VALUE = "reduce.memory-loader.target-value";
        private static MemoryLoader loader = null;

        MemoryLoaderReducer() {
        }

        public void reduce(WritableComparable key, Iterator<Writable> val, OutputCollector<WritableComparable, Writable> output, Reporter reporter) throws IOException {
            Assert.assertNotNull((String)"Reducer not configured!", (Object)loader);
            loader.load();
            output.collect((Object)key, (Object)key);
        }

        public void configure(JobConf conf) {
            loader = new MemoryLoader(conf.getLong(TARGET_VALUE, -1L));
        }
    }

    static class MemoryLoaderMapper
    extends MapReduceBase
    implements org.apache.hadoop.mapred.Mapper<WritableComparable, Writable, WritableComparable, Writable> {
        static final String TARGET_VALUE = "map.memory-loader.target-value";
        private static MemoryLoader loader = null;

        MemoryLoaderMapper() {
        }

        public void map(WritableComparable key, Writable val, OutputCollector<WritableComparable, Writable> output, Reporter reporter) throws IOException {
            Assert.assertNotNull((String)"Mapper not configured!", (Object)loader);
            loader.load();
            output.collect((Object)key, (Object)val);
        }

        public void configure(JobConf conf) {
            loader = new MemoryLoader(conf.getLong(TARGET_VALUE, -1L));
        }
    }

    static class MemoryLoader {
        private static final int DEFAULT_UNIT_LOAD_SIZE = 0xA00000;
        private long targetValue;
        private List<String> loadObjects = new ArrayList<String>();

        MemoryLoader(long targetValue) {
            this.targetValue = targetValue;
        }

        void load() {
            while (Runtime.getRuntime().totalMemory() < this.targetValue) {
                System.out.println("Loading memory with 10485760 characters. Current usage : " + Runtime.getRuntime().totalMemory());
                this.loadObjects.add(RandomStringUtils.random((int)0xA00000));
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static class NewIdentityReducer
    extends org.apache.hadoop.mapreduce.Reducer<Text, IntWritable, Text, IntWritable> {
        private IntWritable result = new IntWritable();

        public void reduce(Text key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            for (IntWritable val : values) {
                sum += val.get();
            }
            this.result.set(sum);
            context.write((Object)key, (Object)this.result);
        }
    }

    public static class NewMapTokenizer
    extends Mapper<Object, Text, Text, IntWritable> {
        private static final IntWritable one = new IntWritable(1);
        private Text word = new Text();

        public void map(Object key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            StringTokenizer itr = new StringTokenizer(value.toString());
            while (itr.hasMoreTokens()) {
                this.word.set(itr.nextToken());
                context.write((Object)this.word, (Object)one);
            }
        }
    }
}

