/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.LimitTasksPerJobTaskScheduler;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.Queue;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskScheduler;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.server.jobtracker.TaskTracker;

public class TestJobQueueInformation
extends TestCase {
    private MiniMRCluster mrCluster;
    private MiniDFSCluster dfsCluster;
    private JobConf jc;
    private static final String JOB_SCHEDULING_INFO = "TESTSCHEDULINGINFO";
    private static final Path TEST_DIR = new Path(System.getProperty("test.build.data", "/tmp"), "job-queue-info-testing");
    private static final Path IN_DIR = new Path(TEST_DIR, "input");
    private static final Path SHARE_DIR = new Path(TEST_DIR, "share");
    private static final Path OUTPUT_DIR = new Path(TEST_DIR, "output");

    static String getSignalFile() {
        return new Path(SHARE_DIR, "signal").toString();
    }

    private JobConf configureWaitingJob(JobConf conf) throws IOException {
        UtilsForTests.configureWaitingJobConf(conf, IN_DIR, OUTPUT_DIR, 2, 0, "test-job-queue-info", TestJobQueueInformation.getSignalFile(), TestJobQueueInformation.getSignalFile());
        return conf;
    }

    protected void setUp() throws Exception {
        super.setUp();
        int taskTrackers = 4;
        Configuration conf = new Configuration();
        this.dfsCluster = new MiniDFSCluster(conf, 4, true, null);
        this.jc = new JobConf();
        this.jc.setClass("mapred.jobtracker.taskScheduler", TestTaskScheduler.class, TaskScheduler.class);
        this.jc.setLong("mapred.jobtracker.taskScheduler.maxRunningTasksPerJob", 10L);
        this.mrCluster = new MiniMRCluster(0, 0, 4, this.dfsCluster.getFileSystem().getUri().toString(), 1, null, null, null, this.jc);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.mrCluster.shutdown();
        this.dfsCluster.shutdown();
    }

    public void testJobQueues() throws IOException {
        JobClient jc = new JobClient(this.mrCluster.createJobConf());
        String expectedQueueInfo = "Maximum Tasks Per Job :: 10";
        JobQueueInfo[] queueInfos = jc.getQueues();
        TestJobQueueInformation.assertNotNull((Object)queueInfos);
        TestJobQueueInformation.assertEquals((int)1, (int)queueInfos.length);
        TestJobQueueInformation.assertEquals((String)"default", (String)queueInfos[0].getQueueName());
        TestJobQueueInformation.assertEquals((String)Queue.QueueState.RUNNING.getStateName(), (String)queueInfos[0].getQueueState());
        JobConf conf = this.mrCluster.createJobConf();
        FileSystem fileSys = this.dfsCluster.getFileSystem();
        conf = this.configureWaitingJob(conf);
        conf.setJobName("test-job-queue-info-test");
        fileSys.delete(SHARE_DIR, true);
        RunningJob rJob = jc.submitJob(conf);
        while (rJob.getJobState() != 1) {
            UtilsForTests.waitFor(10L);
        }
        int numberOfJobs = 0;
        for (JobQueueInfo queueInfo : queueInfos) {
            JobStatus[] jobStatusList = jc.getJobsFromQueue(queueInfo.getQueueName());
            TestJobQueueInformation.assertNotNull((Object)queueInfo.getQueueName());
            TestJobQueueInformation.assertNotNull((Object)queueInfo.getSchedulingInfo());
            TestJobQueueInformation.assertEquals((String)expectedQueueInfo, (String)queueInfo.getSchedulingInfo());
            numberOfJobs += jobStatusList.length;
            for (JobStatus status : jobStatusList) {
                TestJobQueueInformation.assertEquals((String)JOB_SCHEDULING_INFO, (String)status.getSchedulingInfo());
            }
        }
        TestJobQueueInformation.assertEquals((int)1, (int)numberOfJobs);
        UtilsForTests.signalTasks(this.dfsCluster, fileSys, TestJobQueueInformation.getSignalFile(), TestJobQueueInformation.getSignalFile(), 4);
    }

    public static class TestTaskScheduler
    extends LimitTasksPerJobTaskScheduler {
        public synchronized List<Task> assignTasks(TaskTracker taskTracker) throws IOException {
            Collection jips = this.jobQueueJobInProgressListener.getJobQueue();
            if (jips != null && !jips.isEmpty()) {
                for (JobInProgress jip : jips) {
                    jip.setSchedulingInfo((Object)TestJobQueueInformation.JOB_SCHEDULING_INFO);
                }
            }
            return super.assignTasks(taskTracker);
        }
    }
}

