/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapred.UtilsForTests;
import org.junit.Ignore;

@Ignore
public class TestJobTrackerSafeMode
extends TestCase {
    final Path testDir = new Path(System.getProperty("test.build.data", "/tmp"), "jt-safemode");
    final Path inDir = new Path(this.testDir, "input");
    final Path shareDir = new Path(this.testDir, "share");
    final Path outputDir = new Path(this.testDir, "output");
    final int numDir = 1;
    final int numTrackers = 2;
    private static final Log LOG = LogFactory.getLog(TestJobTrackerSafeMode.class);

    private JobConf configureJob(JobConf conf, int maps, int reduces, String mapSignal, String redSignal) throws IOException {
        UtilsForTests.configureWaitingJobConf(conf, this.inDir, this.outputDir, maps, reduces, "test-jobtracker-safemode", mapSignal, redSignal);
        return conf;
    }

    private void testSafeMode(MiniDFSCluster dfs, MiniMRCluster mr) throws IOException, InterruptedException {
        TaskTracker t;
        FileSystem fileSys = dfs.getFileSystem();
        JobConf jobConf = mr.createJobConf();
        String mapSignalFile = UtilsForTests.getMapSignalFile(this.shareDir);
        String redSignalFile = UtilsForTests.getReduceSignalFile(this.shareDir);
        JobTracker jobtracker = mr.getJobTrackerRunner().getJobTracker();
        int numTracker = jobtracker.getClusterStatus(false).getTaskTrackers();
        JobConf job = this.configureJob(jobConf, 40, 0, mapSignalFile, redSignalFile);
        fileSys.delete(this.shareDir, true);
        JobClient jobClient = new JobClient(job);
        RunningJob rJob = jobClient.submitJob(job);
        JobID id = rJob.getID();
        mr.initializeJob(id);
        while (UtilsForTests.getJobStatus(jobClient, id).mapProgress() < 0.5f) {
            LOG.info((Object)"Waiting for the job to be 50% done");
            UtilsForTests.waitFor(100L);
        }
        mr.stopJobTracker();
        mr.getJobTrackerConf().setBoolean("mapred.jobtracker.restart.recover", true);
        UtilsForTests.signalTasks(dfs, fileSys, true, mapSignalFile, redSignalFile);
        UtilsForTests.signalTasks(dfs, fileSys, false, mapSignalFile, redSignalFile);
        HashSet<String> trackers = new HashSet<String>();
        for (int i = 0; i < numTracker; ++i) {
            t = mr.getTaskTrackerRunner(i).getTaskTracker();
            trackers.add(t.getName());
            int runningCount = t.getRunningTaskStatuses().size();
            while (runningCount != 0) {
                LOG.info((Object)("Waiting for tracker " + t.getName() + " to stabilize"));
                UtilsForTests.waitFor(100L);
                runningCount = 0;
                for (TaskStatus status : t.getRunningTaskStatuses()) {
                    if (!status.getIsMap() || status.getRunState() != TaskStatus.State.UNASSIGNED && status.getRunState() != TaskStatus.State.RUNNING) continue;
                    ++runningCount;
                }
            }
        }
        LOG.info((Object)"Trackers have stabilized");
        --numTracker;
        int trackerToKill = numTracker++;
        t = mr.getTaskTrackerRunner(trackerToKill).getTaskTracker();
        trackers.remove(t.getName());
        HashSet<String> lostTrackers = new HashSet<String>();
        lostTrackers.add(t.getName());
        LOG.info((Object)("Stopping tracker : " + t.getName()));
        mr.getTaskTrackerRunner(trackerToKill).getTaskTracker().shutdown();
        mr.stopTaskTracker(trackerToKill);
        mr.startJobTracker();
        UtilsForTests.waitForJobTracker(jobClient);
        jobtracker = mr.getJobTrackerRunner().getJobTracker();
        LOG.info((Object)"Start a new tracker");
        mr.startTaskTracker(null, null, numTracker, 1);
        LOG.info((Object)"Start a new tracker");
        mr.startTaskTracker(null, null, ++numTracker, 1);
        boolean shouldSchedule = jobtracker.recoveryManager.shouldSchedule();
        while (!this.checkTrackers(jobtracker, trackers, lostTrackers)) {
            TestJobTrackerSafeMode.assertFalse((String)"JobTracker has opened up scheduling before all the trackers were recovered", (boolean)shouldSchedule);
            UtilsForTests.waitFor(100L);
            shouldSchedule = jobtracker.recoveryManager.shouldSchedule();
        }
        TestJobTrackerSafeMode.assertTrue((String)"JobTracker hasnt opened up scheduling even all the trackers were recovered", (boolean)jobtracker.recoveryManager.shouldSchedule());
        TestJobTrackerSafeMode.assertEquals((String)"Recovery manager is in inconsistent state", (int)0, (int)jobtracker.recoveryManager.recoveredTrackers.size());
        UtilsForTests.waitTillDone(jobClient);
    }

    private boolean checkTrackers(JobTracker jobtracker, Set<String> present, Set<String> absent) {
        TaskTrackerStatus status;
        long jobtrackerRecoveryFinishTime = jobtracker.getStartTime() + jobtracker.getRecoveryDuration();
        for (String trackerName : present) {
            status = jobtracker.getTaskTrackerStatus(trackerName);
            if (status != null && status.getLastSeen() >= jobtrackerRecoveryFinishTime) continue;
            return false;
        }
        for (String trackerName : absent) {
            status = jobtracker.getTaskTrackerStatus(trackerName);
            if (status == null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJobTrackerSafeMode() throws IOException, InterruptedException {
        String namenode = null;
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        FileSystem fileSys = null;
        try {
            Configuration conf = new Configuration();
            conf.setBoolean("dfs.replication.considerLoad", false);
            dfs = new MiniDFSCluster(conf, 1, true, null, null);
            dfs.waitActive();
            fileSys = dfs.getFileSystem();
            fileSys.delete(this.testDir, true);
            if (!fileSys.mkdirs(this.inDir)) {
                throw new IOException("Mkdirs failed to create " + this.inDir.toString());
            }
            UtilsForTests.writeFile(dfs.getNameNode(), conf, new Path(this.inDir + "/file"), (short)1);
            dfs.startDataNodes(conf, 1, true, null, null, null, null);
            dfs.waitActive();
            namenode = dfs.getFileSystem().getUri().getHost() + ":" + dfs.getFileSystem().getUri().getPort();
            JobConf jtConf = new JobConf();
            jtConf.set("mapred.jobtracker.job.history.block.size", "512");
            jtConf.set("mapred.jobtracker.job.history.buffer.size", "512");
            jtConf.setInt("mapred.tasktracker.map.tasks.maximum", 1);
            jtConf.setInt("mapred.tasktracker.reduce.tasks.maximum", 1);
            jtConf.setLong("mapred.tasktracker.expiry.interval", 5000L);
            jtConf.setInt("mapred.reduce.copy.backoff", 4);
            jtConf.setLong("mapred.job.reuse.jvm.num.tasks", -1L);
            mr = new MiniMRCluster(2, namenode, 1, null, null, jtConf);
            this.testSafeMode(dfs, mr);
        }
        finally {
            if (mr != null) {
                try {
                    mr.shutdown();
                }
                catch (Exception e) {}
            }
            if (dfs != null) {
                try {
                    dfs.shutdown();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        new TestJobTrackerSafeMode().testJobTrackerSafeMode();
    }
}

